/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.index;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import org.jetbrains.annotations.NotNull;

public class ES6FileCachedDataEvaluator
extends JSFileCachedDataEvaluator {
    public ES6FileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outCachedData", "com/intellij/lang/ecmascript6/index/ES6FileCachedDataEvaluator", "<init>"));
        }
        super(outCachedData);
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.myCachedData.setIsCommonJSModule();
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.myCachedData.setIsCommonJSModule();
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.myCachedData.setIsCommonJSModule();
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    public void visitJSVariable(JSVariable node) {
        this.checkIfExportStatement((JSAttributeListOwner)node);
    }

    public void visitJSClass(JSClass aClass) {
        this.checkIfExportStatement((JSAttributeListOwner)aClass);
        this.setSkipChildren();
    }

    public void visitJSFunctionDeclaration(JSFunction node) {
        this.checkIfExportStatement((JSAttributeListOwner)node);
        this.setSkipChildren();
    }

    private void checkIfExportStatement(@NotNull JSAttributeListOwner node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/ecmascript6/index/ES6FileCachedDataEvaluator", "checkIfExportStatement"));
        }
        JSAttributeList attributeList = node.getAttributeList();
        if (attributeList != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
            this.myCachedData.setIsCommonJSModule();
            this.myCachedData.setHasES6Syntax();
        }
    }
}

