/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower.cache;

import com.intellij.openapi.util.Pair;
import com.intellij.util.MergingBackgroundExecutor;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrevRequestSkippingCache<K, V> {
    private final Fetcher<K, V> myFetcher;
    private final Map<K, Future<V>> myRecentFutureMap;
    private final MergingBackgroundExecutor<Pair<FetchCallback<K, V>, Future<V>>> myCheckExecutor;
    private final MergingBackgroundExecutor<Runnable> myFetchExecutor;
    private final BlockingQueue<FetchCallback<K, V>> myFetchQueue;
    private volatile FetchCallback<K, V> myLatestCallback;

    public PrevRequestSkippingCache(@NotNull Fetcher<K, V> fetcher) {
        if (fetcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetcher", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "<init>"));
        }
        this.myRecentFutureMap = Collections.synchronizedMap(new LinkedHashMap<K, Future<V>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Future<V>> eldest) {
                return this.size() > 10;
            }
        });
        this.myFetchQueue = new LinkedBlockingQueue<FetchCallback<K, V>>();
        this.myFetcher = fetcher;
        this.myCheckExecutor = new MergingBackgroundExecutor(2, pair -> {
            if (!this.canBeSkipped((FetchCallback)pair.first)) {
                this.processFuture((FetchCallback)pair.first, (Future)pair.second);
            }
        });
        this.myFetchExecutor = MergingBackgroundExecutor.newRunnableExecutor((int)2);
    }

    public void fetch(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "fetch"));
        }
        this.myLatestCallback = callback;
        if (!this.checkRecentCache(callback)) {
            this.fetchAsync(callback);
        }
    }

    private boolean canBeSkipped(@NotNull FetchCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "canBeSkipped"));
        }
        if (!callback.canBeSkipped()) {
            return false;
        }
        FetchCallback<K, V> latestFetch = this.myLatestCallback;
        if (callback == latestFetch || latestFetch == null) {
            return false;
        }
        return !callback.getKey().equals(latestFetch.getKey());
    }

    private boolean checkRecentCache(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "checkRecentCache"));
        }
        Future<V> future = this.myRecentFutureMap.get(callback.getKey());
        if (future == null) {
            return false;
        }
        if (future.isDone()) {
            this.processFuture(callback, future);
        } else {
            this.myCheckExecutor.queue((Object)Pair.create(callback, future));
        }
        return true;
    }

    private void fetchAsync(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "fetchAsync"));
        }
        this.myFetchQueue.offer(callback);
        this.myFetchExecutor.queue(() -> {
            FetchCallback next;
            while ((next = (FetchCallback)this.myFetchQueue.poll()) != null) {
                if (this.canBeSkipped(next) || this.checkRecentCache(next)) continue;
                this.fetchSync(next);
            }
        });
    }

    private void fetchSync(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "fetchSync"));
        }
        FutureTask<Object> future = new FutureTask<Object>(() -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "lambda$fetchSync$2"));
            }
            try {
                V result = this.myFetcher.fetch(callback.getKey());
                callback.onSuccess(result);
                return result;
            }
            catch (Exception e) {
                callback.onException(e);
                throw e;
            }
        });
        this.myRecentFutureMap.put(callback.getKey(), future);
        future.run();
    }

    private void processFuture(@NotNull FetchCallback<K, V> consumer, @NotNull Future<V> future) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "processFuture"));
        }
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache", "processFuture"));
        }
        try {
            V result = future.get();
            consumer.onSuccess(result);
        }
        catch (InterruptedException e) {
            consumer.onSuccess(null);
        }
        catch (ExecutionException e) {
            Exception cause = (Exception)ObjectUtils.tryCast((Object)e.getCause(), Exception.class);
            if (cause != null) {
                consumer.onException(cause);
            }
            consumer.onException(e);
        }
    }

    public static abstract class FetchCallback<K, V> {
        private final K myKey;
        private final boolean myCanBeSkipped;

        public FetchCallback(@NotNull K key, boolean canBeSkipped) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache$FetchCallback", "<init>"));
            }
            this.myKey = key;
            this.myCanBeSkipped = canBeSkipped;
        }

        @NotNull
        public K getKey() {
            K k = this.myKey;
            if (k == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache$FetchCallback", "getKey"));
            }
            return k;
        }

        public boolean canBeSkipped() {
            return this.myCanBeSkipped;
        }

        public abstract void onSuccess(@Nullable V var1);

        public abstract void onException(@NotNull Exception var1);
    }

    public static interface Fetcher<K, V> {
        @Nullable
        public V fetch(@NotNull K var1) throws Exception;
    }
}

