/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.HtmlTextCompletionConfidence;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class JSAutoCompletionPopupPolicy
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        IElementType nodeType;
        PsiElement prevContextElement;
        ASTNode node;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
        }
        PsiElement commentOrLiteral = PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{PsiComment.class, JSExpression.class});
        if (commentOrLiteral instanceof JSLiteralExpression) {
            if (JSAutoCompletionPopupPolicy.shouldSkipAutopopupInLiteral((JSLiteralExpression)commentOrLiteral)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
                }
                return threeState;
            }
        } else if (commentOrLiteral instanceof PsiComment && contextElement.getNode().getElementType() != JSDocTokenTypes.DOC_TAG_NAME) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if ((node = (prevContextElement = contextElement).getNode()) != null && ((nodeType = node.getElementType()) == JSTokenTypes.DOT || nodeType == JSTokenTypes.DOT_DOT || nodeType == JSTokenTypes.DOT_DOT_DOT)) {
            prevContextElement = PsiTreeUtil.prevLeaf((PsiElement)prevContextElement);
        }
        if (prevContextElement != null && prevContextElement.getParent() instanceof JSParameterList || prevContextElement instanceof PsiErrorElement) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        PsiElement parent = contextElement.getParent();
        if (parent instanceof JSProperty || parent instanceof JSReferenceExpression && parent.getParent() instanceof ES6Property && ((ES6Property)parent.getParent()).isShorthanded() && !DialectDetector.isES6((PsiElement)psiFile) && !DialectDetector.isTypeScript((PsiElement)psiFile) || parent instanceof TypeScriptPropertySignature) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if (HtmlTextCompletionConfidence.shouldSkipAutopopupInHtml((PsiElement)contextElement, (int)offset)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopup"));
        }
        return threeState;
    }

    private static boolean shouldSkipAutopopupInLiteral(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy", "shouldSkipAutopopupInLiteral"));
        }
        if (literal instanceof JSXmlLiteralExpressionImpl) {
            return false;
        }
        return !JavaScriptReferenceContributor.REQUIRE_ARG_PLACE.accepts((Object)literal);
    }
}

