/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class TypeScriptModifiersUtil {
    public static final TokenSet ALLOW_GLOBAL_CLASS_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});
    public static final TokenSet ALLOW_CLASS_FIELD_MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ACCESS_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STATIC_KEYWORD, JSTokenTypes.READONLY_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD})});
    public static final TokenSet ALLOW_CLASS_METHOD_MODIFIERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ACCESS_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STATIC_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD, JSTokenTypes.ASYNC_KEYWORD})});
    public static final TokenSet ALLOW_GLOBAL_COMMON_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});

    public static boolean isAllowClassModifier(JSClass classElement, IElementType elementType, boolean isTopLevel) {
        if (TypeScriptModifiersUtil.isConstEnum(classElement, elementType)) {
            return true;
        }
        if (isTopLevel && elementType == JSTokenTypes.ABSTRACT_KEYWORD && classElement instanceof TypeScriptClass) {
            return true;
        }
        return isTopLevel && (ALLOW_GLOBAL_CLASS_MODIFIERS.contains(elementType) || TypeScriptModifiersUtil.isCorrectDeclareModifierPlace((PsiElement)classElement, elementType));
    }

    public static boolean isConstEnum(JSClass element, IElementType elementType) {
        return elementType == JSTokenTypes.CONST_KEYWORD && element instanceof TypeScriptEnum;
    }

    public static boolean isCorrectDeclareModifierPlace(PsiElement element, IElementType elementType) {
        return elementType == JSTokenTypes.DECLARE_KEYWORD && !TypeScriptPsiUtil.isAmbientDeclaration(element.getParent());
    }

    public static boolean isAllowVariableModifier(PsiElement variableOrDeclaration, IElementType elementType, boolean isTopLevel) {
        if (variableOrDeclaration instanceof JSParameter && JSTokenTypes.ACCESS_MODIFIERS.contains(elementType)) {
            JSFunction function = ((JSParameter)variableOrDeclaration).getDeclaringFunction();
            return function != null && function.isConstructor();
        }
        if (variableOrDeclaration instanceof JSVarStatement && variableOrDeclaration.getParent() instanceof JSClass && ALLOW_CLASS_FIELD_MODIFIERS.contains(elementType)) {
            return true;
        }
        return TypeScriptModifiersUtil.isAllowCommon(variableOrDeclaration, elementType, isTopLevel);
    }

    public static boolean isAllowFunctionModifier(JSFunction function, IElementType elementType, boolean isTopLevel) {
        if (function.isConstructor() && elementType == JSTokenTypes.STATIC_KEYWORD) {
            return false;
        }
        if (function.getParent() instanceof JSClass && ALLOW_CLASS_METHOD_MODIFIERS.contains(elementType)) {
            return true;
        }
        return TypeScriptModifiersUtil.isAllowCommon((PsiElement)function, elementType, isTopLevel) || elementType == JSTokenTypes.ASYNC_KEYWORD;
    }

    public static boolean isAllowTypeSignature(TypeScriptTypeMember signature, IElementType elementType, boolean isTopLevel) {
        if ((signature instanceof TypeScriptIndexSignature || signature instanceof TypeScriptPropertySignature) && elementType == JSTokenTypes.READONLY_KEYWORD) {
            return true;
        }
        return TypeScriptModifiersUtil.isAllowCommon((PsiElement)signature, elementType, isTopLevel);
    }

    public static boolean isAllowCommon(PsiElement element, IElementType elementType, boolean isTopLevel) {
        if (isTopLevel && TypeScriptModifiersUtil.isCorrectDeclareModifierPlace(element, elementType)) {
            return true;
        }
        return isTopLevel && ALLOW_GLOBAL_COMMON_MODIFIERS.contains(elementType);
    }

    public static boolean isAllowImportModifier(PsiElement importElement, IElementType elementType, boolean isTopLevel) {
        return isTopLevel && ALLOW_GLOBAL_COMMON_MODIFIERS.contains(elementType);
    }

    public static String getModifierErrorMessage(ASTNode modifierNode, boolean isTopLevel) {
        IElementType elementType = modifierNode.getElementType();
        return isTopLevel && elementType != JSTokenTypes.ABSTRACT_KEYWORD && elementType != JSTokenTypes.DECLARE_KEYWORD ? JSBundle.message((String)"typescript.validation.message.invalid.module.member.modifier", (Object[])new Object[]{modifierNode.getText()}) : JSBundle.message((String)"typescript.validation.message.invalid.modifier.cannot.be.here", (Object[])new Object[0]);
    }
}

