/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceExpressionResolver
extends JSReferenceExpressionResolver
implements JSResolveUtil.Resolver<JSReferenceExpressionImpl> {
    public TypeScriptReferenceExpressionResolver(JSReferenceExpressionImpl expression, PsiFile file) {
        super(expression, file);
    }

    @Override
    public ResolveResult[] doResolve() {
        if (this.myReferencedName == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            return new ResolveResult[]{new JSResolveResult(currentParent)};
        }
        Object[] resolveResults = this.doResolveReference();
        if (currentParent instanceof TypeScriptModule) {
            return (ResolveResult[])ArrayUtil.mergeArrays((Object[])resolveResults, (Object[])new ResolveResult[]{new JSResolveResult(currentParent)});
        }
        if ((resolveResults == null || resolveResults.length == 0) && "undefined".equals(this.myReferencedName) && this.myQualifier == null) {
            return new ResolveResult[]{new JSResolveResult((PsiElement)this.myRef)};
        }
        return resolveResults;
    }

    private ResolveResult[] doResolveReference() {
        TypeScriptResolveProcessor localProcessor = new TypeScriptResolveProcessor(this.myReferencedName, this.myContainingFile, (PsiElement)this.myRef);
        if (this.myLocalResolve && (!(this.myQualifier instanceof JSThisExpression) || JSContextResolver.findContextElement((JSThisExpression)this.myQualifier) instanceof JSClass)) {
            if (this.myParent instanceof JSCallExpression) {
                localProcessor.setCheckArgumentTypes(true);
            }
            localProcessor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, this.myQualifier, localProcessor, false, false, null);
            return localProcessor.getResultsAsResolveResults();
        }
        localProcessor.setTypeContext(JSResolveUtil.isExprInTypeContext(this.myRef));
        if (this.myParent instanceof JSCallExpression) {
            localProcessor.setCheckArgumentTypes(true);
        }
        JSTypeEvaluator.evaluateTypes(this.myQualifier, this.myContainingFile, localProcessor, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION);
        ResolveResultSink resultSink = (ResolveResultSink)localProcessor.getResultSink();
        JSResolveResult candidateResult = resultSink.getCandidateResult();
        if (localProcessor.resolved == QualifiedItemProcessor.TypeResolveState.Resolved || localProcessor.resolved == QualifiedItemProcessor.TypeResolveState.Undefined || resultSink.getCompleteResult() != null || candidateResult != null && candidateResult.getResolveProblemKey() != null) {
            return localProcessor.getResultsAsResolveResults();
        }
        return this.resolveFromIndices(localProcessor);
    }

    @Override
    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver", "adjustReferencedName"));
        }
        return TypeScriptReferenceExpressionResolver.adjustPrimitiveTypes(ref);
    }

    @Nullable
    public static String adjustPrimitiveTypes(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver", "adjustPrimitiveTypes"));
        }
        String referenceName = ref.getReferenceName();
        if (JSResolveUtil.isExprInStrictTypeContext(ref) && ref.getQualifier() == null) {
            if ("boolean".equals(referenceName)) {
                referenceName = "Boolean";
            } else if ("string".equals(referenceName) || "number".equals(referenceName)) {
                referenceName = StringUtil.capitalize((String)referenceName);
            }
        }
        return referenceName;
    }

    @Override
    protected void prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver", "prepareProcessor"));
        }
        boolean inDefinition = false;
        boolean allowOnlyCompleteMatches = localProcessor.isEncounteredDynamicClasses();
        if (this.myParent instanceof JSDefinitionExpression) {
            inDefinition = true;
            allowOnlyCompleteMatches = true;
        } else if (!allowOnlyCompleteMatches || this.myQualifier instanceof JSThisExpression) {
            processor.allowPartialResults();
        }
        if (inDefinition || allowOnlyCompleteMatches) {
            processor.setAddOnlyCompleteMatches(true);
        }
        processor.setSkipDefinitions(inDefinition);
        processor.addLocalResults(localProcessor);
    }

    @Override
    protected ResolveResult[] getResultsForDefinition() {
        JSTypeSource source;
        JSType type;
        if (this.myQualifier == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myQualifier instanceof JSReferenceExpression && (type = JSResolveUtil.getExpressionJSType(this.myQualifier)) != null && !(type instanceof JSAnyType) && (source = type.getSource()) != null && source.isExplicitlyDeclared()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }
}

