/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.scratch.JSScratchFileInfoProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveScopeProvider
extends JSElementResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "getResolveScope"));
        }
        FileType type = file.getFileType();
        if (!TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type) && !TypeScriptResolveScopeProvider.isTypeScriptScratchFile(file, project, type)) {
            return null;
        }
        Set<VirtualFile> predefinedLibraryFiles = TypeScriptResolveScopeProvider.getTypeScriptPredefineLibraries(file, project);
        if (predefinedLibraryFiles.contains(file)) {
            return GlobalSearchScope.filesScope((Project)project, predefinedLibraryFiles);
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file);
        if (module == null) {
            return JSResolveUtil.getJavaScriptSymbolsResolveScope(project);
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)JSResolveUtil.ourScopeCache.get((UserDataHolder)module, null)).getValue();
        ScriptingLibraryMappings mappings = (ScriptingLibraryMappings)ServiceManager.getService((Project)project, JSLibraryMappings.class);
        if (mappings != null) {
            Set files = mappings.getLibraryFilesFor(file);
            files.addAll(predefinedLibraryFiles);
            files.removeAll(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
            scopeExcludingJsLibs = scopeExcludingJsLibs.uniteWith(TypeScriptResolveScopeProvider.getFilesAndDirectoriesScope(project, files));
        }
        scopeExcludingJsLibs = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scopeExcludingJsLibs, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        return scopeExcludingJsLibs;
    }

    private static boolean isTypeScriptScratchFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull FileType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isTypeScriptScratchFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isTypeScriptScratchFile"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isTypeScriptScratchFile"));
        }
        return type instanceof LanguageFileType && JSScratchFileInfoProvider.Provider.isScratchForLanguage(project, file, type, ((LanguageFileType)type).getLanguage());
    }

    @NotNull
    private static Set<VirtualFile> getTypeScriptPredefineLibraries(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "getTypeScriptPredefineLibraries"));
        }
        Set<VirtualFile> set = TypeScriptUtil.shouldUseES6Lib(file, project) ? JSCorePredefinedLibrariesProvider.getTypeScriptES6PredefinedLibraryFiles() : JSCorePredefinedLibrariesProvider.getTypeScriptPredefinedLibraryFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "getTypeScriptPredefineLibraries"));
        }
        return set;
    }
}

