/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaScriptTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        PsiElement at;
        int offset;
        if (!JavaScriptTypedHandler.charOfInterest(charTyped)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (file instanceof XmlFile) {
            if (!JavaScriptSupportLoader.isFlexMxmFile(file)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile injectedPsi = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
            if (injectedPsi == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file, (int)offset);
            file = injectedPsi;
        }
        if (!(file instanceof JSFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        offset = editor.getCaretModel().getOffset();
        if (JavaScriptTypedHandler.isNotApplicableByLexer(charTyped, editor, offset)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (file.getContext() == null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        if (charTyped == '.') {
            PsiElement element;
            PsiElement at2 = file.findElementAt(offset - 1);
            PsiElement psiElement = element = at2 != null ? PsiTreeUtil.getNonStrictParentOfType((PsiElement)at2, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class}) : null;
            if (element == null) {
                autoPopupController.autoPopupMemberLookup(editor, null);
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        if (charTyped == ' ' || charTyped == ',') {
            at = file.findElementAt(offset);
            if (at != null && at.getParent() instanceof JSArgumentList) {
                autoPopupController.autoPopupParameterInfo(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (charTyped == ',') {
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        if ((at = file.findElementAt(offset)) != null) {
            if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{PsiComment.class, JSLiteralExpression.class, JSConditionalExpression.class}) != null || at.getParent() instanceof JSSwitchStatement) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (at instanceof PsiWhiteSpace) {
                at = PsiTreeUtil.prevLeaf((PsiElement)at);
            }
            if (at == null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{JSConditionalExpression.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        if (charTyped == '<') {
            Document document = editor.getDocument();
            if (offset > 0 && offset <= document.getTextLength() && document.getCharsSequence().charAt(offset - 1) != '.') {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        autoPopupController.autoPopupMemberLookup(editor, null);
        return TypedHandlerDelegate.Result.STOP;
    }

    private static boolean isNotApplicableByLexer(char charTyped, Editor editor, int offset) {
        if (charTyped == ' ') {
            Document document = editor.getDocument();
            CharSequence charSequence = document.getCharsSequence();
            if (offset > 3 && offset <= document.getTextLength() && (charSequence.charAt(offset - 1) != 'w' || charSequence.charAt(offset - 2) != 'e' || charSequence.charAt(offset - 3) != 'n') && charSequence.charAt(offset - 1) != ':' && charSequence.charAt(offset - 1) != ',') {
                return true;
            }
        }
        if (offset == 0) {
            return true;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        IElementType tokenType = iterator.getTokenType();
        return JSTokenTypes.COMMENTS.contains(tokenType) || tokenType instanceof JSDocElementType || StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tokenType) || JSTokenTypes.STRING_LITERALS.contains(tokenType);
    }

    private static boolean charOfInterest(char charTyped) {
        return charTyped == '<' || charTyped == ' ' || charTyped == ',' || charTyped == '.';
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        PsiElement context;
        if (c == '}' && file instanceof JSFile && (context = file.getContext()) != null) {
            PsiLanguageInjectionHost value = (PsiLanguageInjectionHost)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{XmlAttributeValue.class, XmlText.class});
            Editor realEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            int offset = realEditor.getCaretModel().getOffset();
            if (value != null && realEditor.getDocument().getCharsSequence().charAt(offset) == '}') {
                realEditor.getCaretModel().moveToOffset(offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        if (c == '.') {
            PsiElement at;
            int offset = editor.getCaretModel().getOffset();
            Object object = offset < editor.getDocument().getTextLength() ? file.findElementAt(offset) : (at = offset > 0 ? file.findElementAt(offset - 1) : null);
            if (at != null && at.getParent().getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && !JavaScriptTypedHandler.isNotApplicableByLexer(c, editor, offset)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            }
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Language language;
        int offset;
        PsiElement at;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JavaScriptTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JavaScriptTypedHandler", "charTyped"));
        }
        if (c == '{' && JavaScriptSupportLoader.isFlexMxmFile(file)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            int offset2 = editor.getCaretModel().getOffset();
            PsiElement at2 = file.findElementAt(offset2);
            PsiLanguageInjectionHost value = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)at2, (Class[])new Class[]{XmlAttributeValue.class, XmlText.class});
            if (value != null) {
                String s = StringUtil.stripQuotesAroundValue((String)value.getText());
                int lbraceCount = 0;
                int rbraceCount = 0;
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch == '{') {
                        ++lbraceCount;
                        continue;
                    }
                    if (ch != '}') continue;
                    ++rbraceCount;
                }
                if (lbraceCount == rbraceCount + 1) {
                    editor.getDocument().insertString(offset2, (CharSequence)"}");
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        } else if ((c == ',' || c == ':' || c == '.' && JavaScriptTypedHandler.isIndentChainedCalls(project)) && (at = file.findElementAt((offset = editor.getCaretModel().getOffset()) - 1)) != null && ((language = PsiUtilCore.findLanguageFromElement((PsiElement)at)) == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect)) {
            PsiElement parent;
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            at = file.findElementAt(offset - 1);
            PsiElement psiElement = parent = at != null ? at.getParent() : null;
            if (parent != null) {
                int indentPos = -1;
                IElementType parentType = parent.getNode().getElementType();
                if (parentType == JSStubElementTypes.VAR_STATEMENT || parentType == JSElementTypes.REFERENCE_EXPRESSION) {
                    indentPos = at.getTextOffset() - 1;
                } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(parentType)) {
                    indentPos = parent.getTextOffset() - 1;
                }
                if (indentPos >= 0 && JavaScriptTypedHandler.isAfterLineStart(indentPos, editor.getDocument())) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, indentPos);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        return super.charTyped(c, project, editor, file);
    }

    private static boolean isIndentChainedCalls(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/editing/JavaScriptTypedHandler", "isIndentChainedCalls"));
        }
        JSCodeStyleSettings settings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JSCodeStyleSettings.class);
        return settings.INDENT_CHAINED_CALLS;
    }

    private static boolean isAfterLineStart(int indentPos, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/editing/JavaScriptTypedHandler", "isAfterLineStart"));
        }
        int firstNonSpace = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)indentPos, (String)" \t");
        return document.getCharsSequence().charAt(firstNonSpace) == '\n';
    }
}

