/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.backbone;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.psi.PsiQualifiedReference;
import org.jetbrains.annotations.NotNull;

public class BackboneJSIndexingHandler
extends FrameworkIndexingHandler {
    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/backbone/BackboneJSIndexingHandler", "processCallExpression"));
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && "extend".equals(((JSReferenceExpression)methodExpression).getReferenceName())) {
            JSSymbolNamespace callNamespace;
            JSExpression[] arguments;
            JSQualifiedName qualifierName;
            JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
            JSQualifiedName jSQualifiedName = qualifierName = qualifier instanceof JSReferenceExpression ? JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)qualifier) : null;
            if (qualifierName != null && (arguments = callExpression.getArguments()).length == 1 && arguments[0] instanceof JSObjectLiteralExpression && (callNamespace = JSSymbolUtil.findNamespace((JSExpression)callExpression)) != null && callNamespace.getQualifiedName() != null) {
                outData.addBaseType(callNamespace.getQualifiedName().getQualifiedName(), qualifierName.getQualifiedName());
            }
        }
    }
}

