/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSXLanguageLevelAnnotator
implements Annotator {
    private static final String JSX_SWITCH_DISABLED = "jsx.switch.disabled";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator", "annotate"));
        }
        JSFile file = (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class);
        if (file == null) {
            return;
        }
        Project project = file.getProject();
        if (JSRootConfiguration.getInstance(project).getLanguageLevel() == JSLanguageLevel.JSX || DialectDetector.isJSX((PsiElement)file)) {
            return;
        }
        if (PropertiesComponent.getInstance((Project)project).getBoolean(JSX_SWITCH_DISABLED)) {
            return;
        }
        if (JSXLanguageLevelAnnotator.isJsxFile(file)) {
            Annotation annotation = holder.createWarningAnnotation((PsiElement)file, "Switch language level to JSX Harmony");
            annotation.setFileLevelAnnotation(true);
            annotation.setGutterIconRenderer((GutterIconRenderer)new JsxGutterIconRenderer());
            annotation.registerFix((IntentionAction)new ChangeLanguageLevelFix(JSLanguageLevel.JSX){

                @Override
                @NotNull
                public String getText() {
                    if ("Switch" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$1", "getText"));
                    }
                    return "Switch";
                }

                @Override
                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$1", "invoke"));
                    }
                    super.invoke(project, editor, file);
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            });
            annotation.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    if ("Dismiss" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2", "getText"));
                    }
                    return "Dismiss";
                }

                @NotNull
                public String getFamilyName() {
                    String string = JSBundle.message((String)"javascript.change.language.level.family", (Object[])new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2", "getFamilyName"));
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2", "isAvailable"));
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$2", "invoke"));
                    }
                    PropertiesComponent.getInstance((Project)project).setValue(JSXLanguageLevelAnnotator.JSX_SWITCH_DISABLED, "true");
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }

                public boolean startInWriteAction() {
                    return false;
                }
            });
        }
    }

    private static boolean isJsxFile(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator", "isJsxFile"));
        }
        final Ref jsxRef = Ref.create((Object)false);
        new JSRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (Boolean.TRUE.equals(jsxRef.get())) {
                    return;
                }
                super.visitElement(element);
                if (element instanceof LeafPsiElement && element.getNode().getElementType() == JSTokenTypes.LT) {
                    PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)element);
                    next = next != null ? PsiTreeUtil.nextLeaf((PsiElement)next) : null;
                    PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
                    PsiElement psiElement = prev = prev instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)prev) : prev;
                    if ((next == null || next.getNode().getElementType() != JSTokenTypes.LT) && prev instanceof PsiErrorElement && JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]).equals(((PsiErrorElement)prev).getErrorDescription())) {
                        jsxRef.set((Object)true);
                    }
                }
            }
        }.visitFile((PsiFile)file);
        return (Boolean)jsxRef.get();
    }

    private static class JsxGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private JsxGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = JavaScriptLanguageIcons.Logos.Jsx_16;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXLanguageLevelAnnotator$JsxGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsxGutterIconRenderer;
        }

        public int hashCode() {
            return System.identityHashCode(JavaScriptLanguageIcons.Logos.Jsx_16);
        }
    }
}

