/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.index.JSImplicitElementsIndexFileTypeProvider;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSImplicitElementsIndex
extends FileBasedIndexExtension<String, Collection<JSElementProxy>> {
    public static final ID<String, Collection<JSElementProxy>> INDEX_ID = ID.create((String)"js.implicit.elements.index");
    private final DataIndexer<String, Collection<JSElementProxy>, FileContent> myIndexer = new DataIndexer<String, Collection<JSElementProxy>, FileContent>(){

        @NotNull
        public Map<String, Collection<JSElementProxy>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$1", "map"));
            }
            Map<String, Collection<JSElementProxy>> map = JSIndexContent.indexFile(inputData).getImplicitElements();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$1", "map"));
            }
            return map;
        }
    };

    @NotNull
    public ID<String, Collection<JSElementProxy>> getName() {
        ID<String, Collection<JSElementProxy>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<JSElementProxy>, FileContent> getIndexer() {
        DataIndexer<String, Collection<JSElementProxy>, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<JSElementProxy>> getValueExternalizer() {
        DataExternalizer<Collection<JSElementProxy>> dataExternalizer = new DataExternalizer<Collection<JSElementProxy>>(){

            public void save(@NotNull DataOutput out, Collection<JSElementProxy> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$2", "save"));
                }
                if (value == null) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)0);
                    return;
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (JSElementProxy proxy : value) {
                    proxy.serialize(out);
                }
            }

            public Collection<JSElementProxy> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$2", "read"));
                }
                int size = DataInputOutputUtil.readINT((DataInput)in);
                if (size == 0) {
                    return null;
                }
                ArrayList<JSElementProxy> result = new ArrayList<JSElementProxy>(size);
                for (int i = 0; i < size; ++i) {
                    JSElementProxy proxy = JSElementProxy.deserialize(in);
                    result.add(proxy);
                }
                return result;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(Holder.FILE_TYPES);
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return JSFileElementType.getVersion() + 2;
    }

    public static class JSElementProxy {
        private final int myOffset;
        private final JSImplicitElementImpl.Builder myElement;

        public JSElementProxy(JSImplicitElementImpl.Builder builder, int offset) {
            assert (builder.getProvider() == null) : "provider must be null to have equal deserialized elements";
            this.myElement = builder;
            this.myOffset = offset;
        }

        @NotNull
        public JSOffsetBasedImplicitElement toOffsetBasedImplicitElement(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$JSElementProxy", "toOffsetBasedImplicitElement"));
            }
            JSOffsetBasedImplicitElement jSOffsetBasedImplicitElement = new JSOffsetBasedImplicitElement(this.myElement.copy(), this.myOffset, file);
            if (jSOffsetBasedImplicitElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$JSElementProxy", "toOffsetBasedImplicitElement"));
            }
            return jSOffsetBasedImplicitElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSElementProxy proxy = (JSElementProxy)o;
            if (this.myOffset != proxy.myOffset) {
                return false;
            }
            return this.myElement.equals(proxy.myElement);
        }

        public int hashCode() {
            int result = this.myOffset;
            result = 31 * result + this.myElement.hashCode();
            return result;
        }

        public void serialize(DataOutput out) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOffset);
            this.myElement.toImplicitElement().serialize(out);
        }

        public static JSElementProxy deserialize(DataInput in) throws IOException {
            int offset = DataInputOutputUtil.readINT((DataInput)in);
            JSImplicitElementImpl.Builder element = JSImplicitElementImpl.deserialize(in);
            return new JSElementProxy(element, offset);
        }
    }

    public static class Holder {
        public static final FileType[] FILE_TYPES = JSImplicitElementsIndexFileTypeProvider.Provider.getFileTypes();

        public static boolean containFileType(FileType type) {
            return ArrayUtil.contains((Object)type, (Object[])FILE_TYPES);
        }
    }
}

