/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSPotentiallyInvalidConstructorUsageInspection
extends JSInspection {
    public boolean myConsiderUppercaseFunctionsToBeConstructors = true;

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.potentially.invalid.constructor.usages.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidConstructorUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSNewExpression(JSNewExpression node) {
                String messageKey;
                JSReferenceExpression methodRefExpr;
                String name;
                if (this.mayHaveProblem((JSCallExpression)node) && !StringUtil.isEmpty((String)(name = (methodRefExpr = (JSReferenceExpression)node.getMethodExpression()).getReferencedName())) && (messageKey = JSPotentiallyInvalidConstructorUsageInspection.this.getConstructorProblemKey(methodRefExpr, name)) != null) {
                    PsiElement element = methodRefExpr.getReferenceNameElement();
                    holder.registerProblem((PsiElement)(element != null ? element : methodRefExpr), JSBundle.message((String)messageKey, (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitJSCallExpression(JSCallExpression node) {
                if (this.mayHaveProblem(node)) {
                    if (!JSInheritedLanguagesHelper.constructorCallWithoutNewActual((PsiElement)node)) {
                        return;
                    }
                    JSReferenceExpression methodRefExpr = (JSReferenceExpression)node.getMethodExpression();
                    if (methodRefExpr.getQualifier() != null) {
                        return;
                    }
                    String name = methodRefExpr.getReferencedName();
                    if (!(StringUtil.isEmpty((String)name) || "Object".equals(name) || "Boolean".equals(name))) {
                        JSType type;
                        boolean constructorProblem;
                        JSFunction resolve = JSPsiImplUtils.getPossibleFunction(methodRefExpr.resolve());
                        if (resolve == null) {
                            return;
                        }
                        boolean bl = constructorProblem = JSSymbolUtil.isConstructorName(name) && JSPotentiallyInvalidConstructorUsageInspection.this.myConsiderUppercaseFunctionsToBeConstructors && resolve.isReferencesThis() || JSSymbolUtil.isDefinitelyConstructor((PsiElement)resolve);
                        if (constructorProblem && resolve.constructorCanBeInvokedWithoutNew()) {
                            constructorProblem = false;
                        }
                        if (constructorProblem && (type = resolve.getReturnType()) != null && type.getSource().isExplicitlyDeclared()) {
                            constructorProblem = false;
                        }
                        if (constructorProblem) {
                            InsertNewFix insertNewFix = new InsertNewFix(node);
                            PsiElement element = methodRefExpr.getReferenceNameElement();
                            holder.registerProblem((PsiElement)(element != null ? element : methodRefExpr), JSBundle.message((String)"javascript.constructor.call.without.new.message", (Object[])new Object[0]), new LocalQuickFix[]{insertNewFix});
                        }
                    }
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                String messageKey;
                JSReferenceExpression referenceExpression;
                String name;
                JSExpression qualifier;
                if ("prototype".equals(node.getReferencedName()) && (qualifier = node.getQualifier()) instanceof JSReferenceExpression && !StringUtil.isEmpty((String)(name = (referenceExpression = (JSReferenceExpression)qualifier).getReferencedName())) && this.mayHaveProblem(referenceExpression) && (messageKey = JSPotentiallyInvalidConstructorUsageInspection.this.getConstructorProblemKey(referenceExpression, name)) != null) {
                    PsiElement element = referenceExpression.getReferenceNameElement();
                    holder.registerProblem((PsiElement)(element != null ? element : referenceExpression), JSBundle.message((String)messageKey, (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean mayHaveProblem(JSCallExpression node) {
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    return this.mayHaveProblem((JSReferenceExpression)methodExpression);
                }
                return false;
            }

            private boolean mayHaveProblem(JSReferenceExpression methodRefExpr) {
                JSExpression newQualifier;
                ResolveResult[] name;
                boolean isJustCallContext;
                PsiElement parent = methodRefExpr.getParent();
                boolean bl = isJustCallContext = parent instanceof JSCallExpression && !(parent instanceof JSNewExpression);
                if (isJustCallContext && ("Number".equalsIgnoreCase((String)(name = methodRefExpr.getReferencedName())) || "String".equalsIgnoreCase((String)name) || "Error".equals(name))) {
                    return false;
                }
                for (ResolveResult r : methodRefExpr.multiResolve(false)) {
                    PsiElement elt = r.getElement();
                    if (elt == null) continue;
                    JSType type = null;
                    JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(elt);
                    if (functionItem != null) {
                        elt = functionItem;
                    }
                    if (elt instanceof JSVariable) {
                        if (elt instanceof JSParameter) {
                            return false;
                        }
                        if (!elt.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
                            return false;
                        }
                        type = ((JSVariable)elt).getType();
                    } else {
                        if (elt instanceof JSFunctionExpression) {
                            return false;
                        }
                        if (elt instanceof JSFunction) {
                            PsiElement eltParent = elt.getParent();
                            if ((eltParent instanceof JSClass || eltParent instanceof JSPackageStatement || eltParent instanceof JSFile && eltParent.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) && isJustCallContext) {
                                return false;
                            }
                            if (((JSFunction)elt).getReturnType() != null) {
                                return false;
                            }
                        } else if (elt instanceof JSClass) {
                            return false;
                        }
                    }
                    if (type == null || !(type instanceof JSPrimitiveFunctionType) && !"Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) continue;
                    return false;
                }
                JSReferenceExpression qualifier = methodRefExpr;
                while (qualifier instanceof JSReferenceExpression && (newQualifier = qualifier.getQualifier()) != null) {
                    qualifier = newQualifier;
                }
                if (qualifier instanceof JSReferenceExpression && qualifier != methodRefExpr) {
                    PsiElement resolve = qualifier.resolve();
                    return !(resolve instanceof JSParameter) && !(resolve instanceof JSVariable);
                }
                return !(qualifier instanceof JSThisExpression);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidConstructorUsageInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private String getConstructorProblemKey(JSReferenceExpression methodRefExpr, String name) {
        boolean lowerCasedConstructorProblem = Character.isLowerCase(name.charAt(0)) && this.myConsiderUppercaseFunctionsToBeConstructors && !JSSymbolUtil.isDefinitelyConstructor(methodRefExpr.resolve());
        String messageKey = null;
        if (lowerCasedConstructorProblem) {
            messageKey = "javascript.constructor.with.lower.case.name.used.message";
        } else {
            boolean constructorProblem;
            boolean bl = constructorProblem = !this.myConsiderUppercaseFunctionsToBeConstructors && !JSSymbolUtil.isDefinitelyConstructor(methodRefExpr.resolve());
            if (constructorProblem) {
                messageKey = "javascript.not.a.constructor.call.message";
            }
        }
        return messageKey;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"javascript.assume.uppercase.functions.to.be.constructors", (Object[])new Object[0]), (InspectionProfileEntry)this, "myConsiderUppercaseFunctionsToBeConstructors");
    }

    private static class InsertNewFix
    extends FixAndIntentionAction {
        public InsertNewFix(JSCallExpression node) {
            this.registerElementRefForFix((PsiElement)node, null);
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"insert.new.keyword.fix.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidConstructorUsageInspection$InsertNewFix", "getName"));
            }
            return string;
        }

        @Override
        public boolean startInWriteAction() {
            return true;
        }

        @Override
        protected void applyFix(final Project project, final PsiElement psiElement, PsiFile file, Editor editor) {
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(){

                @Override
                public void run() {
                    PsiElement psi = JSChangeUtil.createStatementFromText(project, "new " + psiElement.getText()).getPsi();
                    psiElement.replace((PsiElement)((JSExpressionStatement)psi).getExpression());
                }
            });
        }
    }
}

