/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSPotentiallyInvalidTargetOfIndexedPropertyAccess
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.potentially.invalid.target.of.indexed.property.access.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidTargetOfIndexedPropertyAccess", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
                PsiElement resolve;
                JSExpression indexExpression = node.getIndexExpression();
                if (indexExpression instanceof JSBinaryExpression && ((JSBinaryExpression)indexExpression).getOperationSign() == JSTokenTypes.COMMA) {
                    indexExpression = ((JSBinaryExpression)indexExpression).getROperand();
                }
                JSExpression qualifier = node.getQualifier();
                if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral() && qualifier instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) instanceof JSClass || resolve instanceof JSFunction && !((JSFunction)resolve).isGetProperty())) {
                    PsiElement element = ((JSReferenceExpression)qualifier).getReferenceNameElement();
                    holder.registerProblem((PsiElement)(element != null ? element : qualifier), JSBundle.message((String)"javascript.potentially.invalid.target.of.indexed.property.access", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidTargetOfIndexedPropertyAccess", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

