/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSPotentiallyInvalidUsageOfThisInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.potentially.invalid.usage.of.this.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1", "visitJSFunctionExpression"));
                }
                this.process((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1", "visitJSFunctionDeclaration"));
                }
                PsiElement parent = JSResolveUtil.findParent((PsiElement)node);
                if (parent instanceof JSClass) {
                    return;
                }
                this.process(node);
            }

            private void process(final @NotNull JSFunction function) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1", "process"));
                }
                THashSet referencedFields = new THashSet();
                function.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor((Set)referencedFields){
                    final /* synthetic */ Set val$referencedFields;
                    {
                        this.val$referencedFields = set;
                    }

                    public void visitJSThisExpression(JSThisExpression node) {
                        String referencedName;
                        PsiElement parent = node.getParent();
                        if (parent instanceof JSReferenceExpression && (referencedName = ((JSReferenceExpression)parent).getReferenceName()) != null) {
                            this.val$referencedFields.add(referencedName);
                        }
                    }

                    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1$1", "visitJSFunctionExpression"));
                        }
                    }

                    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1$1", "visitJSFunctionDeclaration"));
                        }
                    }
                });
                function.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor((Set)referencedFields){
                    JSFunction fun;
                    boolean sameThis;
                    boolean myThisTypeExplicitlyDeclared;
                    final /* synthetic */ Set val$referencedFields;
                    {
                        this.val$referencedFields = set;
                        this.fun = function;
                    }

                    public void visitJSThisExpression(JSThisExpression node) {
                        PsiElement parent;
                        if (this.fun != function && !this.sameThis && !this.myThisTypeExplicitlyDeclared && (parent = node.getParent()) instanceof JSReferenceExpression) {
                            boolean referenceInClass;
                            String referencedName = ((JSReferenceExpression)parent).getReferenceName();
                            boolean bl = referenceInClass = referencedName != null && this.val$referencedFields.contains(referencedName);
                            if (!referenceInClass) {
                                PsiElement resolve = ((JSReferenceExpression)parent).resolve();
                                JSQualifiedNameImpl outerFunctionQName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)function);
                                boolean bl2 = referenceInClass = resolve instanceof JSPsiElementBase && outerFunctionQName != null && outerFunctionQName.equals(((JSPsiElementBase)resolve).getNamespace());
                            }
                            if (referenceInClass) {
                                holder.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.potentially.invalid.usage.of.this", (Object[])new Object[0]), new LocalQuickFix[0]);
                            }
                        }
                    }

                    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1$2", "visitJSFunctionExpression"));
                        }
                        this.proceedFun((JSFunction)node);
                    }

                    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1$2", "visitJSFunctionDeclaration"));
                        }
                        this.proceedFun(node);
                    }

                    private void proceedFun(JSFunction node) {
                        JSFunction prev = this.fun;
                        boolean sameThisSave = this.sameThis;
                        boolean _thisTypeExplicitlyDeclared = this.myThisTypeExplicitlyDeclared;
                        this.fun = node;
                        boolean sameThisAsBefore = false;
                        boolean thisTypeExplicitlyDeclared = false;
                        PsiElement parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)node);
                        if (JSPsiImplUtils.isArrowFunction(node) != null) {
                            sameThisAsBefore = true;
                        }
                        if (parent instanceof JSAssignmentExpression) {
                            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
                            if (lOperand instanceof JSDefinitionExpression) {
                                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                            }
                            if (lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSThisExpression) {
                                sameThisAsBefore = true;
                            }
                        } else if (parent instanceof JSArgumentList) {
                            JSExpression methodExpression;
                            PsiElement grandParent;
                            JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
                            for (int i = 0; i < arguments.length; ++i) {
                                JSExpression initializer;
                                PsiElement resolve;
                                if (arguments[i] != node) continue;
                                if (i + 1 >= arguments.length) break;
                                JSExpression argument = arguments[i + 1];
                                if (argument instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)argument).resolve()) instanceof JSVariable && (initializer = ((JSVariable)resolve).getInitializer()) != null) {
                                    argument = initializer;
                                }
                                if (!(argument instanceof JSThisExpression)) break;
                                sameThisAsBefore = true;
                                break;
                            }
                            if (!sameThisAsBefore && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSThisExpression) {
                                sameThisAsBefore = true;
                            }
                        } else if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSCallExpression) {
                            JSExpression[] arguments;
                            JSCallExpression callExpression = (JSCallExpression)parent.getParent();
                            String name = ((JSReferenceExpression)parent).getReferenceName();
                            if ("bind".equals(name) && (arguments = callExpression.getArguments()).length == 1 && arguments[0] instanceof JSThisExpression) {
                                sameThisAsBefore = true;
                            }
                            if (!sameThisAsBefore) {
                                JSType exprType = JSResolveUtil.getExpressionJSType((JSExpression)callExpression);
                                List<JSType> types = exprType instanceof JSCompositeTypeImpl ? ((JSCompositeTypeImpl)exprType).getTypes() : Collections.singletonList(exprType);
                                for (JSType type : types) {
                                    JSType thisType;
                                    if (!(type instanceof JSFunctionTypeImpl) || (thisType = ((JSFunctionTypeImpl)type).getThisType()) == null || !StringUtil.equals((CharSequence)thisType.getResolvedTypeText(), (CharSequence)JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)this.fun))) continue;
                                    sameThisAsBefore = true;
                                }
                            }
                        }
                        if (JSDocumentationUtils.findContextType((PsiElement)node) != null) {
                            thisTypeExplicitlyDeclared = true;
                        }
                        this.sameThis = sameThisAsBefore;
                        this.myThisTypeExplicitlyDeclared = thisTypeExplicitlyDeclared;
                        super.visitJSFunctionDeclaration(node);
                        this.fun = prev;
                        this.sameThis = sameThisSave;
                        this.myThisTypeExplicitlyDeclared = _thisTypeExplicitlyDeclared;
                    }
                });
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

