/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSConvertParametersToObjectIntention
extends JavaScriptIntention {
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "isAvailable"));
        }
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class);
        return parameterList != null && parameterList.getParameters().length > 0;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement funcGrandParent;
        JSFunction funcRef;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "invoke"));
        }
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class);
        if (parameterList == null) {
            return;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        while (JSPsiImplUtils.isTypeSignature(function)) {
            function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class);
            parameterList = function.getParameterList();
        }
        if (JSPsiImplUtils.isArrowFunction(function) != null) {
            HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.arrow.function", (Object[])new Object[0]));
            return;
        }
        Object object = funcRef = function instanceof JSFunctionExpression ? JSUtils.findInitializedElement((JSExpression)((JSFunctionExpression)function)) : function;
        if (function == null) {
            return;
        }
        JSParameter[] parameters = parameterList.getParameterVariables();
        if (parameters.length == 0) {
            return;
        }
        ArrayList<JSCallExpression> callExpressions = new ArrayList<JSCallExpression>();
        PsiElement funcParent = function.getParent();
        if (funcParent instanceof JSCallExpression) {
            callExpressions.add((JSCallExpression)funcParent);
        }
        if (funcParent instanceof JSParenthesizedExpression && (funcGrandParent = funcParent.getParent()) instanceof JSCallExpression) {
            callExpressions.add((JSCallExpression)funcGrandParent);
        }
        if (funcRef != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> JSConvertParametersToObjectIntention.lambda$invoke$0((JSNamedElement)funcRef, callExpressions), "Find Usages", false, element.getProject());
        }
        JSBlockStatement body = (JSBlockStatement)function.getBody()[0];
        PsiElement anchor = body.getFirstChild();
        ASTNode newObjParam = JSChangeUtil.createExpressionFromText(project, "parameters");
        for (JSParameter parameter : parameters) {
            String parameterName = parameter.getName();
            ASTNode decl = JSChangeUtil.createStatementFromText(project, "var " + parameterName + " = parameters." + parameterName + ";");
            anchor = body.addAfter(decl.getPsi(), anchor);
        }
        JSParameter firstParam = parameters[0];
        JSParameter lastParam = parameters[parameters.length - 1];
        if (parameters.length > 1) {
            parameterList.getNode().removeRange(firstParam.getNode(), lastParam.getNode());
        }
        lastParam.replace(newObjParam.getPsi());
        for (JSCallExpression call : callExpressions) {
            JSArgumentList argumentList = call.getArgumentList();
            JSExpression[] arguments = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
            int argToReplaceCount = Math.min(arguments.length, parameters.length);
            if (argToReplaceCount <= 0) continue;
            StringBuilder builder = new StringBuilder(argToReplaceCount * 4);
            builder.append("{");
            for (int i = 0; i < argToReplaceCount; ++i) {
                builder.append(parameters[i].getName());
                builder.append(" : ");
                builder.append(arguments[i].getText());
                if (i >= argToReplaceCount - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            if (argToReplaceCount > 1) {
                argumentList.getNode().removeRange(arguments[0].getNode(), arguments[argToReplaceCount - 1].getNode());
            }
            JSLanguageDialect dialect = JSUtils.getDialect(call.getContainingFile());
            arguments[argToReplaceCount - 1].replace(JSChangeUtil.createExpressionFromText(project, builder.toString(), dialect).getPsi());
        }
    }

    private static /* synthetic */ void lambda$invoke$0(JSNamedElement funcRef, List callExpressions) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)funcRef).findAll()) {
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (!(parent instanceof JSCallExpression)) continue;
            callExpressions.add((JSCallExpression)parent);
        }
    }
}

