/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.library.ui.JSScriptingContextProvider;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private final JSScriptingContextProvider myProvider = new JSScriptingContextProvider();
    private String myDefaultDocUrl;

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor", "getRootTypePresentation"));
        }
        if (type == OrderRootType.CLASSES) {
            return new OrderRootTypePresentation(this.myProvider.getLibraryTypeName(OrderRootType.CLASSES), JavaScriptLanguageIcons.Library.JsCompact);
        }
        if (type == OrderRootType.SOURCES) {
            return new OrderRootTypePresentation(this.myProvider.getLibraryTypeName(OrderRootType.SOURCES), JavaScriptLanguageIcons.Library.JsSource);
        }
        if (type == OrderRootType.DOCUMENTATION) {
            return new OrderRootTypePresentation(JSBundle.message((String)"js.library.documentation", (Object[])new Object[0]), AllIcons.Nodes.JavaDocFolder);
        }
        return null;
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(String libraryName) {
        LibFileChooserDescriptor libFileChooserDescriptor = new LibFileChooserDescriptor(true);
        if (libFileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor", "createAttachFilesChooserDescriptor"));
        }
        return libFileChooserDescriptor;
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        List<JSLibraryRootsDetector> list = Arrays.asList(new JSLibraryRootsDetector(OrderRootType.CLASSES, true), new JSLibraryRootsDetector(OrderRootType.SOURCES, false));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor", "getRootDetectors"));
        }
        return list;
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        ArrayList<AttachRootButtonDescriptor> myButtonDescriptors = new ArrayList<AttachRootButtonDescriptor>();
        myButtonDescriptors.add(new AttachFromButtonDescriptor(OrderRootType.SOURCES, JSBundle.message((String)"js.library.attach.debug", (Object[])new Object[0])));
        myButtonDescriptors.add(new AttachFromButtonDescriptor(OrderRootType.CLASSES, JSBundle.message((String)"js.library.attach.release", (Object[])new Object[0])));
        myButtonDescriptors.add(new AttachUrlDocDescriptor());
        myButtonDescriptors.add(new DownloadDocDescriptor());
        ArrayList<AttachRootButtonDescriptor> arrayList = myButtonDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor", "createAttachButtons"));
        }
        return arrayList;
    }

    private void collectFilesRecursively(final List<VirtualFile> collectedFiles, VirtualFile dir, final OrderRootType rootType) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$1", "visitFile"));
                }
                if (!file.isDirectory() && JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file.getExtension())) {
                    OrderRootType fileRootType;
                    OrderRootType orderRootType = fileRootType = JSLibraryRootsComponentDescriptor.this.myProvider.isCompact(file) ? OrderRootType.CLASSES : OrderRootType.SOURCES;
                    if (fileRootType == rootType) {
                        collectedFiles.add(file);
                    }
                }
                return true;
            }
        });
    }

    public OrderRootType[] getRootTypes() {
        ArrayList<OrderRootType> rootTypes = new ArrayList<OrderRootType>();
        rootTypes.addAll(Arrays.asList(super.getRootTypes()));
        rootTypes.addAll(Arrays.asList(this.myProvider.getLibraryKind().getAdditionalRootTypes()));
        return rootTypes.toArray(new OrderRootType[rootTypes.size()]);
    }

    @Nullable
    private String getDefaultDocUrl(LibraryEditor libraryEditor) {
        if (this.myDefaultDocUrl == null) {
            for (OrderRootType rootType : this.getRootTypes()) {
                for (VirtualFile file : libraryEditor.getFiles(rootType)) {
                    ScriptingFrameworkDescriptor framework = this.myProvider.detectFramework(file);
                    if (framework == null) continue;
                    this.myDefaultDocUrl = this.myProvider.getDefaultDocUrl(framework);
                    return this.myDefaultDocUrl;
                }
            }
        }
        return this.myDefaultDocUrl;
    }

    private class DownloadDocDescriptor
    extends AttachRootButtonDescriptor {
        private DownloadDocDescriptor() {
            super(OrderRootType.DOCUMENTATION, "Download Documentation...");
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            String offlineDocUrl;
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$DownloadDocDescriptor", "selectFiles"));
            }
            if (libraryEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryEditor", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$DownloadDocDescriptor", "selectFiles"));
            }
            String baseUrl = JSLibraryRootsComponentDescriptor.this.getDefaultDocUrl(libraryEditor);
            if (baseUrl != null && (offlineDocUrl = JSLibraryRootsComponentDescriptor.this.myProvider.getOfflineDocUrl(baseUrl)) != null) {
                Project project = ProjectManager.getInstance().getDefaultProject();
                VirtualFile targetFile = JSLibraryRootsComponentDescriptor.this.myProvider.downloadOfflineDoc(project, offlineDocUrl, parent);
                if (targetFile != null) {
                    return new VirtualFile[]{targetFile};
                }
            }
            return VirtualFile.EMPTY_ARRAY;
        }
    }

    private class AttachUrlDocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlDocDescriptor() {
            super(OrderRootType.DOCUMENTATION, ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachUrlDocDescriptor", "selectFiles"));
            }
            VirtualFile vFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent, (String)JSLibraryRootsComponentDescriptor.this.getDefaultDocUrl(libraryEditor));
            if (vFile != null) {
                return new VirtualFile[]{vFile};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
    }

    private class AttachFromButtonDescriptor
    extends AttachRootButtonDescriptor {
        protected AttachFromButtonDescriptor(@NotNull OrderRootType orderRootType, String buttonText) {
            if (orderRootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderRootType", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachFromButtonDescriptor", "<init>"));
            }
            if (buttonText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonText", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachFromButtonDescriptor", "<init>"));
            }
            super(orderRootType, buttonText);
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$AttachFromButtonDescriptor", "selectFiles"));
            }
            ArrayList<VirtualFile> collectedFiles = new ArrayList<VirtualFile>();
            LibFileChooserDescriptor chooserDescriptor = new LibFileChooserDescriptor(false);
            chooserDescriptor.setTitle(JSBundle.message((String)("js.library.select." + (this.getRootType() == OrderRootType.SOURCES ? "debug" : "release")), (Object[])new Object[0]));
            Project project = contextModule != null ? contextModule.getProject() : null;
            VirtualFile chosenFile = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Component)parent, (Project)project, null);
            if (chosenFile != null && chosenFile.isValid()) {
                if (chosenFile.isDirectory()) {
                    JSLibraryRootsComponentDescriptor.this.collectFilesRecursively(collectedFiles, chosenFile, this.getRootType());
                } else {
                    collectedFiles.add(chosenFile);
                }
            }
            for (VirtualFile file : collectedFiles) {
                ScriptingFrameworkDescriptor framework = JSLibraryRootsComponentDescriptor.this.myProvider.detectFramework(file);
                if (framework == null) continue;
                JSLibraryRootsComponentDescriptor.this.myDefaultDocUrl = JSLibraryRootsComponentDescriptor.this.myProvider.getDefaultDocUrl(framework);
                break;
            }
            return VfsUtilCore.toVirtualFileArray(collectedFiles);
        }
    }

    private class LibFileChooserDescriptor
    extends FileChooserDescriptor {
        public LibFileChooserDescriptor(boolean chooseMultiple) {
            super(true, true, false, true, false, chooseMultiple);
        }

        public boolean isFileSelectable(VirtualFile file) {
            if (!file.isDirectory() && !JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file.getExtension())) {
                return false;
            }
            return super.isFileSelectable(file);
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            if (!file.isDirectory() && !JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file.getExtension())) {
                return false;
            }
            return super.isFileVisible(file, showHiddenFiles);
        }
    }

    private class JSLibraryRootsDetector
    extends RootDetector {
        private final boolean myCompact;

        private JSLibraryRootsDetector(OrderRootType rootType, boolean compact) {
            super(rootType, false, JSLibraryRootsComponentDescriptor.this.myProvider.getLibraryTypeName(rootType));
            this.myCompact = compact;
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector", "detectRoots"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector", "detectRoots"));
            }
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            this.collectRecursively(rootCandidate, result, progressIndicator);
            ArrayList<VirtualFile> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector", "detectRoots"));
            }
            return arrayList;
        }

        private void collectRecursively(@NotNull VirtualFile file, final @NotNull List<VirtualFile> result, final @NotNull ProgressIndicator progressIndicator) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector", "collectRecursively"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector", "collectRecursively"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector", "collectRecursively"));
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryRootsComponentDescriptor$JSLibraryRootsDetector$1", "visitFile"));
                    }
                    if (file.isDirectory()) {
                        progressIndicator.setText2(file.getPath());
                        progressIndicator.checkCanceled();
                    } else if (JSLibraryRootsComponentDescriptor.this.myProvider.acceptsExtension(file.getExtension()) && JSLibraryRootsDetector.this.myCompact == JSLibraryRootsComponentDescriptor.this.myProvider.isCompact(file)) {
                        result.add(file);
                    }
                    return true;
                }
            });
        }
    }
}

