/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSScriptingContextProvider
extends LangScriptingContextProvider {
    @NotNull
    public Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getLanguage"));
        }
        return javascriptLanguage;
    }

    public PersistentLibraryKind getLibraryKind() {
        return JSLibraryKind.INSTANCE;
    }

    public ScriptingLibraryManager getLibraryManager(Project project) {
        return (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
    }

    public boolean acceptsExtension(String fileExt) {
        if (fileExt != null) {
            for (String extension : JSFileReference.IMPLICIT_EXTENSIONS) {
                if (!fileExt.regionMatches(true, 0, extension, 1, fileExt.length())) continue;
                return true;
            }
        }
        return false;
    }

    public ScriptingLibraryMappings getLibraryMappings(Project project) {
        JSLibraryMappings mappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        assert (mappings != null);
        return mappings;
    }

    public boolean isCompact(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "isCompact"));
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }

    @Nullable
    public String getLibraryTypeName(OrderRootType rootType) {
        if (rootType == OrderRootType.CLASSES) {
            return "Release";
        }
        if (rootType == OrderRootType.SOURCES) {
            return "Debug";
        }
        return null;
    }

    public String getDefaultDocUrl(@NotNull ScriptingFrameworkDescriptor framework) {
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getDefaultDocUrl"));
        }
        String baseKey = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion());
        if (baseKey != null) {
            return JSExternalLibraryDocBundle.getBaseUrl(baseKey);
        }
        return null;
    }

    @Nullable
    public ScriptingFrameworkDescriptor detectFramework(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "detectFramework"));
        }
        return JSProjectUtil.detectFramework(file.getUrl());
    }

    @Nullable
    public String getOfflineDocUrl(String defaultDocUrl) {
        String baseKey = JSExternalLibraryDocBundle.getBaseURLKey(defaultDocUrl);
        if (baseKey != null) {
            return JSExternalLibraryDocBundle.getOfflineDocUrl(baseKey);
        }
        return null;
    }

    @Nullable
    public VirtualFile downloadOfflineDoc(Project project, String offlineDocUrl, JComponent parent) {
        return JSScriptingContextProvider.doDownload(project, offlineDocUrl, "Downloading documentation", parent);
    }

    @Nullable
    private static VirtualFile doDownload(Project project, String downloadUrl, String message, JComponent parent) {
        boolean isInTestMode = ApplicationManager.getApplication().isUnitTestMode();
        JSDownloadManager downloadManager = new JSDownloadManager(null);
        Runnable runnable = () -> {
            if (!isInTestMode) {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                downloadManager.setProgressIndicator(progress);
            }
            downloadManager.download(downloadUrl, JSExternalLibraryDocBundle.getOfflineDocExt(downloadUrl));
        };
        boolean tryAgain = false;
        do {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, message, true, project)) continue;
            if (downloadManager.getLastError() != null) {
                if (!isInTestMode) {
                    tryAgain = IOExceptionDialog.showErrorDialog((String)"Download Error", (String)("Can not download from " + downloadUrl + ". " + downloadManager.getLastError()));
                    continue;
                }
                tryAgain = false;
                continue;
            }
            tryAgain = false;
        } while (tryAgain);
        if (downloadManager.getLastError() == null) {
            String targetFilePath;
            if (!isInTestMode && parent != null) {
                JSScriptingContextProvider.showDownloadedStatus(project, parent, downloadManager.getActualSource());
            }
            if ((targetFilePath = downloadManager.getTargetFilePath()) != null) {
                return VfsUtil.findFileByIoFile((File)new File(targetFilePath), (boolean)true);
            }
        }
        return null;
    }

    @NotNull
    public DownloadableFileSetVersions<DownloadableFileSetDescription> getDownloadableLibraryDescriptors(Project project) {
        URL localUrl = JSDownloadManager.class.getResource("jslibraries.xml");
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions("javascript", new URL[]{localUrl});
        if (downloadableFileSetVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getDownloadableLibraryDescriptors"));
        }
        return downloadableFileSetVersions;
    }

    public void filterExistingLibraries(@NotNull Project project, @NotNull List<? extends DownloadableFileSetDescription> descriptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "filterExistingLibraries"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "filterExistingLibraries"));
        }
        JSScriptingContextProvider.doFilterExistingLibraries(project, descriptions);
    }

    private static <T extends DownloadableFileSetDescription> void doFilterExistingLibraries(@NotNull Project project, @NotNull List<T> descriptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doFilterExistingLibraries"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doFilterExistingLibraries"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$doFilterExistingLibraries$1"));
            }
            if (descriptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$doFilterExistingLibraries$1"));
            }
            if (project.isDisposed()) {
                return;
            }
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            ArrayList<DownloadableFileSetDescription> toRemove = new ArrayList<DownloadableFileSetDescription>();
            for (DownloadableFileSetDescription description : descriptions) {
                String ideLibName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
                if (libraryManager.getLibraryByName(ideLibName) == null) continue;
                toRemove.add(description);
            }
            descriptions.removeAll(toRemove);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadLibrary(Project project, DownloadableFileSetDescription description, JComponent parent, Runnable afterDownload) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        HashSet libFiles = new HashSet();
        for (DownloadableFileDescription item : description.getFiles()) {
            VirtualFile libFile = JSScriptingContextProvider.doDownload(project, item.getDownloadUrl(), "Downloading library file", parent);
            if (libFile == null) continue;
            libFiles.add(libFile);
        }
        if (libFiles.size() > 0) {
            AccessToken token = WriteAction.start();
            try {
                String libName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
                ScriptingLibraryManager libraryManager = (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
                LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
                Library library = libTable.getLibraryByName(libName);
                if (library == null) {
                    String baseUrl;
                    ScriptingFrameworkDescriptor framework = this.detectFramework((VirtualFile)libFiles.iterator().next());
                    String[] docUrls = ArrayUtil.EMPTY_STRING_ARRAY;
                    if (framework != null && (baseUrl = this.getDefaultDocUrl(framework)) != null) {
                        docUrls = new String[]{baseUrl};
                    }
                    ScriptingLibraryModel libModel = libraryManager.createLibrary(libName, libFiles.toArray(new VirtualFile[libFiles.size()]), VirtualFile.EMPTY_ARRAY, docUrls, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                    if (framework != null) {
                        libModel.setFrameworkDescriptor(framework);
                    }
                    libraryManager.commitChanges();
                    ScriptingLibraryMappings mappings = (ScriptingLibraryMappings)ServiceManager.getService((Project)project, JSLibraryMappings.class);
                    if (mappings != null) {
                        mappings.associate(null, libName);
                    }
                    if (afterDownload != null) {
                        afterDownload.run();
                    }
                }
            }
            finally {
                token.finish();
            }
        }
    }

    private static void showDownloadedStatus(Project project, Component component, String location) {
        MessageType messageType = MessageType.INFO;
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Successfully downloaded " + location, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).createBalloon();
        Rectangle rect = component.getBounds();
        Point p = new Point(rect.x + 30, rect.y + rect.height - 30);
        RelativePoint point = new RelativePoint(component, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)project, (Disposable)balloon);
    }

    public ScriptingFrameworkDescriptor[] getSupportedFrameworks(Project project) {
        Set<String> keys = JSExternalLibraryDocBundle.getBasePatternKeys();
        ArrayList<ScriptingFrameworkDescriptor> descriptors = new ArrayList<ScriptingFrameworkDescriptor>();
        for (String key : keys) {
            String name = JSExternalLibraryDocBundle.getLibraryName(key);
            descriptors.add(new ScriptingFrameworkDescriptor(name, null));
        }
        Collections.sort(descriptors, (d1, d2) -> {
            int nameResult;
            int n = nameResult = d1.getFrameworkName() != null ? d1.getFrameworkName().compareToIgnoreCase(d2.getFrameworkName()) : -1;
            if (nameResult != 0) {
                return nameResult;
            }
            return d1.getFrameworkVersion() != null ? d1.getFrameworkVersion().compareTo(d2.getFrameworkVersion()) : -1;
        });
        return descriptors.toArray(new ScriptingFrameworkDescriptor[descriptors.size()]);
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = JavaScriptLanguageIcons.Library.JsLibrary;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getFileIcon"));
        }
        return icon;
    }
}

