/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class JSLinterConfigChangeTracker {
    private final AtomicBoolean myTracking;
    private final Project myProject;
    private final Condition<VirtualFile> myFileFilter;

    public JSLinterConfigChangeTracker(@NotNull Project project, @NotNull FileType fileType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker", "<init>"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker", "<init>"));
        }
        this(project, (Condition<VirtualFile>)((Condition)file -> {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker", "lambda$new$0"));
            }
            return file.getFileType() == fileType;
        }));
    }

    public JSLinterConfigChangeTracker(@NotNull Project project, @NotNull Condition<VirtualFile> fileFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker", "<init>"));
        }
        if (fileFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFilter", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker", "<init>"));
        }
        this.myTracking = new AtomicBoolean(false);
        this.myProject = project;
        this.myFileFilter = fileFilter;
    }

    public void startIfNeeded() {
        if (this.myTracking.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (!this.myProject.isDisposed()) {
                    VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new JSLinterConfigFileVfsListener(), (Disposable)this.myProject);
                    EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
                    multicaster.addDocumentListener((DocumentListener)new JSLinterConfigFileDocumentListener(), (Disposable)this.myProject);
                }
            }));
        }
    }

    private void onChange(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker", "onChange"));
        }
        if (this.myFileFilter.value((Object)file) && !this.myProject.isDisposed() && this.isAnalyzerRestartNeeded(this.myProject, file)) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    protected abstract boolean isAnalyzerRestartNeeded(@NotNull Project var1, @NotNull VirtualFile var2);

    private class JSLinterConfigFileDocumentListener
    extends DocumentAdapter {
        private JSLinterConfigFileDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file != null) {
                JSLinterConfigChangeTracker.this.onChange(file);
            }
        }
    }

    private class JSLinterConfigFileVfsListener
    extends VirtualFileAdapter {
        private JSLinterConfigFileVfsListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker$JSLinterConfigFileVfsListener", "fileCreated"));
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker$JSLinterConfigFileVfsListener", "fileDeleted"));
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker$JSLinterConfigFileVfsListener", "fileMoved"));
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/JSLinterConfigChangeTracker$JSLinterConfigFileVfsListener", "fileCopied"));
            }
            JSLinterConfigChangeTracker.this.onChange(event.getFile());
            JSLinterConfigChangeTracker.this.onChange(event.getOriginalFile());
        }
    }
}

