/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.linter.JsqtProcessOutputViewer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsqtViewProcessOutputAction
implements IntentionAction {
    private final String myTitle;
    private final Icon myIcon;
    private final GeneralCommandLine myCommandLine;
    private final ProcessHandler myHandler;
    private final ProcessOutput myOutput;

    public JsqtViewProcessOutputAction(@NotNull String title, @Nullable Icon icon, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler handler, @NotNull ProcessOutput output) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "<init>"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "<init>"));
        }
        this.myTitle = title;
        this.myIcon = icon;
        this.myCommandLine = commandLine;
        this.myHandler = handler;
        this.myOutput = output;
    }

    @NotNull
    public String getText() {
        if ("Details" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "getText"));
        }
        return "Details";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myTitle + ": show details";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JsqtViewProcessOutputAction", "invoke"));
        }
        JsqtProcessOutputViewer.show(project, this.myTitle, this.myIcon, this.myCommandLine, this.myHandler, this.myOutput);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

