/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.history.LocalHistory;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsExternalAnnotator;
import com.intellij.lang.javascript.linter.jscs.JscsExternalRunner;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class JscsReformatterTask
extends Task.Backgroundable {
    @NotNull
    private final Collection<VirtualFile> myRoots;
    private final JscsExternalAnnotator myJscsAnnotator;
    private final JscsState myJscsState;
    private MultiMap<VirtualFile, String> myProblems;
    private final List<VirtualFile> myFiles;

    public JscsReformatterTask(@NotNull Project project, @NotNull Collection<VirtualFile> roots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "<init>"));
        }
        super(project, "Reformatting with JSCS...");
        this.myRoots = roots;
        this.myJscsAnnotator = JscsExternalAnnotator.getInstanceForBatchInspection();
        this.myJscsState = (JscsState)JscsConfiguration.getInstance(this.myProject).getExtendedState().getState();
        this.myProblems = new MultiMap();
        this.myFiles = new ArrayList<VirtualFile>();
        LocalHistory.getInstance().putSystemLabel(this.myProject, JSBundle.message((String)"jscs.action.fix.problems.name.start", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "run"));
        }
        try {
            for (VirtualFile file : this.myRoots) {
                if (file.isDirectory() || !JSUtils.isJavaScriptFile(file)) continue;
                String parentPath = file.getParent() == null ? "" : " (" + file.getParent().getPath() + ")";
                indicator.setText("Processing " + file.getName() + parentPath);
                this.formatFile(file);
            }
        }
        finally {
            RefreshSession session = RefreshQueue.getInstance().createSession(false, false, () -> LocalHistory.getInstance().putSystemLabel(this.myProject, JSBundle.message((String)"jscs.action.fix.problems.name.finish", (Object[])new Object[0])), ModalityState.NON_MODAL);
            session.addAllFiles(this.myRoots);
            session.launch();
        }
    }

    public void onSuccess() {
        if (!this.myProblems.isEmpty()) {
            String join = StringUtil.join((Collection)this.myProblems.entrySet(), entry -> "<a href= '#" + ((VirtualFile)entry.getKey()).getPath() + "'>" + ((VirtualFile)entry.getKey()).getName() + "</a>: " + StringUtil.join((Collection)((Collection)entry.getValue()), (String)", "), (String)"<br/>");
            JscsConfiguration.NOTIFICATION_GROUP.createNotification("", "Problem with JSCS reformatting:<br/>" + join, NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask$1", "hyperlinkUpdate"));
                    }
                    String description = event.getDescription();
                    if (description != null && description.startsWith("#")) {
                        String path = description.substring(1);
                        OpenFileAction.openFile((String)path, (Project)JscsReformatterTask.this.myProject);
                    }
                }
            }).notify(this.myProject);
        }
    }

    private void formatFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "formatFile"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "lambda$formatFile$2"));
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile == null) {
                this.myProblems.putValue((Object)file, (Object)("Can not find PSI file for " + file.getPath()));
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            if (document == null) {
                this.myProblems.putValue((Object)file, (Object)("Can not find Document for " + psiFile.getName()));
                return;
            }
            JSLinterInput<JscsState> input = JSLinterInput.create(this.myProject, psiFile, document, psiFile.getText(), this.myJscsState, null, this.myJscsAnnotator);
            JscsExternalRunner runner = this.myJscsAnnotator.createJscsRunner(input);
            runner.setFix(true);
            JSLinterAnnotationResult<JscsState> result = runner.execute();
            if (result != null) {
                List<JSLinterError> errors = result.getErrors();
                if (result.getFileWideErrorMessage() != null) {
                    this.myProblems.putValue((Object)file, (Object)result.getFileWideErrorMessage().getDescription());
                }
                if (!errors.isEmpty()) {
                    for (JSLinterError error : errors) {
                        this.myProblems.putValue((Object)file, (Object)error.getDescription());
                    }
                }
            }
            if (runner.getSkipReason() != null) {
                this.myProblems.putValue((Object)file, (Object)runner.getSkipReason());
            }
            this.myFiles.add(file);
        });
    }
}

