/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.google.common.base.Splitter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintIgnoreInfo;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigLookupResult;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigFileUtil {
    public static final String EXTENDS_KEY = "extends";
    private static final String AUTO_SCAN_CONFIG_NAME = ".jshintrc";
    private static final String PACKAGE_JSON_JSHINT_CONFIG = "jshintConfig";
    private static final Logger LOG = Logger.getInstance(JSHintConfigFileUtil.class);

    private JSHintConfigFileUtil() {
    }

    public static boolean isJSHintConfigFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "isJSHintConfigFile"));
        }
        PsiFile file = element.getContainingFile();
        return file != null && JSHintConfigFileUtil.isJSHintConfigFile(file);
    }

    public static boolean isJSHintConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "isJSHintConfigFile"));
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return ((Object)((Object)JSHintConfigFileType.INSTANCE)).equals(vFile.getFileType());
    }

    public static boolean isWarningKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "isWarningKey"));
        }
        return key.startsWith("+W") || key.startsWith("-W");
    }

    public static boolean isIgnored(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "isIgnored"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "isIgnored"));
        }
        VirtualFile fileDir = file.getParent();
        if (fileDir == null) {
            return true;
        }
        VirtualFile jshintIgnore = JSLinterConfigFileUtil.findFile(project, fileDir, ".jshintignore");
        if (jshintIgnore == null) {
            return false;
        }
        try {
            JSHintIgnoreInfo ignoreInfo = JSHintConfigFileUtil.parseIgnores(jshintIgnore);
            return ignoreInfo.isIgnore(file);
        }
        catch (IOException e) {
            LOG.warn("Cannot read " + jshintIgnore, (Throwable)e);
            return false;
        }
    }

    @NotNull
    private static JSHintIgnoreInfo parseIgnores(@NotNull VirtualFile jshintIgnore) throws IOException {
        if (jshintIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jshintIgnore", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "parseIgnores"));
        }
        String text = JSLinterConfigFileUtil.loadActualText(jshintIgnore);
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)text);
        ArrayList list = ContainerUtil.newArrayList();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            list.add(line);
        }
        JSHintIgnoreInfo jSHintIgnoreInfo = new JSHintIgnoreInfo(jshintIgnore, list);
        if (jSHintIgnoreInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "parseIgnores"));
        }
        return jSHintIgnoreInfo;
    }

    @Nullable
    public static JSHintConfigLookupResult lookupConfig(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile jshintConfig;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "lookupConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "lookupConfig"));
        }
        VirtualFile fileDir = file.getParent();
        if (fileDir == null) {
            return null;
        }
        VirtualFile packageJson = JSLinterConfigFileUtil.findFile(project, fileDir, "package.json");
        if (packageJson != null) {
            try {
                JSHintOptionsState optionsState = JSHintConfigFileUtil.parsePackageJson(packageJson);
                if (optionsState != null) {
                    return JSHintConfigLookupResult.createSuccessfulResult(packageJson, optionsState);
                }
            }
            catch (IOException e) {
                return JSHintConfigLookupResult.createErrorResult(packageJson, "Failed to read 'jshintConfig' property from package.json");
            }
        }
        if ((jshintConfig = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileDir, AUTO_SCAN_CONFIG_NAME)) != null) {
            return JSHintConfigParser.parse(jshintConfig);
        }
        return null;
    }

    @Nullable
    public static JSHintConfigLookupResult loadConfigByPath(@NotNull String configFilePath) {
        String systemIndependentPath;
        if (configFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "loadConfigByPath"));
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile file = fileSystem.findFileByPath(systemIndependentPath = FileUtil.toSystemIndependentName((String)configFilePath));
        if (file == null || !file.isValid()) {
            file = fileSystem.refreshAndFindFileByPath(systemIndependentPath);
        }
        if (file != null && file.isValid() && !file.isDirectory()) {
            return JSHintConfigParser.parse(file);
        }
        return null;
    }

    @Nullable
    private static JSHintOptionsState parsePackageJson(@NotNull VirtualFile packageJson) throws IOException {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "parsePackageJson"));
        }
        String text = JSLinterConfigFileUtil.loadActualText(packageJson);
        JsonReader reader = new JsonReader((Reader)new StringReader(text));
        reader.setLenient(true);
        JsonToken topToken = reader.peek();
        if (topToken != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Unexpected json element " + topToken);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals(PACKAGE_JSON_JSHINT_CONFIG)) {
                return JSHintConfigFileUtil.parseOptionsState(reader);
            }
            reader.skipValue();
        }
        reader.endObject();
        reader.close();
        return null;
    }

    public static boolean isExtendsKey(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "isExtendsKey"));
        }
        return EXTENDS_KEY.equals(StringUtil.stripQuotesAroundValue((String)element.getText()));
    }

    @NotNull
    static JSHintOptionsState parseOptionsState(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "parseOptionsState"));
        }
        JsonToken topToken = reader.peek();
        if (topToken != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Unexpected json element " + topToken);
        }
        reader.beginObject();
        JSHintOptionsState.Builder builder = new JSHintOptionsState.Builder();
        while (reader.hasNext()) {
            String name = reader.nextName();
            Object value = JsonUtil.nextAny((JsonReader)reader);
            builder.put(name, value);
        }
        reader.endObject();
        JSHintOptionsState jSHintOptionsState = builder.build();
        if (jSHintOptionsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileUtil", "parseOptionsState"));
        }
        return jSHintOptionsState;
    }
}

