/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddRequiredAmdModuleToModulesListFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    private final JSAmdUtil.AmdLoaderCallOnPointers myAmdLoaderCallOnPointers;
    private final String myPath;
    private final String myReferenceName;
    private final boolean myIsSingleQuotes;

    public AddRequiredAmdModuleToModulesListFix(@NotNull JSAmdUtil.AmdLoaderCallOnPointers pointers, String path, String referenceName, boolean isSingleQuotes) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "<init>"));
        }
        this.myAmdLoaderCallOnPointers = pointers;
        this.myPath = path;
        this.myReferenceName = referenceName;
        this.myIsSingleQuotes = isSingleQuotes;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "showHint"));
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myIsSingleQuotes) {
            String string = "Add '" + this.myPath + "' module dependency";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "getText"));
            }
            return string;
        }
        String string = "Add \"" + this.myPath + "\" module dependency";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "invoke"));
        }
        this.invokeImpl();
    }

    @Override
    public String getVarName() {
        return this.myReferenceName;
    }

    private void invokeImpl() {
        JSAmdUtil.AmdLoaderCall amdLoaderCall = this.myAmdLoaderCallOnPointers.toCall();
        if (!amdLoaderCall.isValid()) {
            return;
        }
        JSArrayLiteralExpression modulesArray = amdLoaderCall.getModulesArray();
        JSFunctionExpression callback = amdLoaderCall.getCallBackExpression();
        Project project = callback.getProject();
        String q = this.myIsSingleQuotes ? "'" : "\"";
        PsiFile arrayFile = ImportCommonJSModuleFix.createDummyFile(project, "[" + q + this.myPath + q + "]");
        PsiElement comma = AddRequiredAmdModuleToModulesListFix.createComma(project);
        if (comma == null) {
            return;
        }
        if (modulesArray == null) {
            PsiElement added = callback.getParent().addBefore(comma, (PsiElement)callback);
            callback.getParent().addBefore(arrayFile.getFirstChild(), added);
        } else {
            JSParameterList parameterList = callback.getParameterList();
            if (parameterList != null && parameterList.getParameters().length > modulesArray.getExpressions().length) {
                return;
            }
            int previousParams = modulesArray.getExpressions().length - (parameterList == null ? 0 : parameterList.getParameters().length);
            PsiElement child = arrayFile.getFirstChild();
            JSArrayLiteralExpression arrayLiteralExpression = (JSArrayLiteralExpression)child.getFirstChild();
            JSExpression literal = arrayLiteralExpression.getExpressions()[0];
            if (literal == null) {
                return;
            }
            if (modulesArray.getExpressions().length == 0) {
                modulesArray.addAfter((PsiElement)literal, modulesArray.getFirstChild());
            } else {
                JSExpression[] expressions = modulesArray.getExpressions();
                PsiElement added = modulesArray.addAfter(comma, (PsiElement)expressions[expressions.length - 1]);
                modulesArray.addAfter((PsiElement)literal, added);
            }
            if (previousParams > 0) {
                ParameterNamesGenerator generator = new ParameterNamesGenerator(parameterList == null ? new JSParameter[]{} : parameterList.getParameterVariables());
                for (int i = 0; i < previousParams; ++i) {
                    this.addNewParameter(callback, generator.generate());
                }
            }
        }
        this.addNewParameter(callback, this.myReferenceName);
        DaemonCodeAnalyzer.getInstance((Project)callback.getProject()).restart(callback.getContainingFile());
    }

    private void addNewParameter(JSFunctionExpression callback, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "addNewParameter"));
        }
        JSParameterList list = callback.getParameterList();
        PsiFile file = ImportCommonJSModuleFix.createDummyFile(callback.getProject(), "function(" + name + "){}");
        JSParameter parameter = (JSParameter)PsiTreeUtil.findChildOfType((PsiElement)file, JSParameter.class);
        if (parameter == null) {
            return;
        }
        if (list.getParameters().length == 0) {
            list.addAfter((PsiElement)parameter, list.getFirstChild());
        } else {
            PsiElement comma = AddRequiredAmdModuleToModulesListFix.createComma(callback.getProject());
            if (comma == null) {
                return;
            }
            JSParameterListElement[] parameters = list.getParameters();
            PsiElement added = list.addAfter(comma, (PsiElement)parameters[parameters.length - 1]);
            list.addAfter((PsiElement)parameter, added);
        }
    }

    private static PsiElement createComma(Project project) {
        PsiElement[] children;
        PsiFile file = ImportCommonJSModuleFix.createDummyFile(project, ",");
        for (PsiElement child : children = file.getChildren()) {
            if (!(child instanceof LeafPsiElement) || !",".equals(child.getText())) continue;
            return child;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = AddRequiredAmdModuleToModulesListFix.class.getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Node.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "getFamilyName"));
        }
        return "Node.js";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix", "applyFix"));
        }
        this.invokeImpl();
    }

    private static class ParameterNamesGenerator {
        private final Set<String> myAlreadyUsed = new HashSet<String>();
        private int myCnt = 1;

        public ParameterNamesGenerator(JSParameter[] parameters) {
            for (JSParameter parameter : parameters) {
                this.myAlreadyUsed.add(parameter.getName());
            }
        }

        public String generate() {
            String current;
            while (this.myAlreadyUsed.contains(current = "mod" + this.myCnt++)) {
            }
            return current;
        }
    }
}

