/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInstaller
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(PackageInstaller.class);
    @NotNull
    private final NodeSettings myNodeSettings;
    @NotNull
    private final String myPackageName;
    @Nullable
    private final String myVersion;
    @NotNull
    private final File myWorkingDir;
    @NotNull
    private final PackageManagementService.Listener myListener;
    @Nullable
    private final String myExtraOptions;
    @Nullable
    private String myError;

    public PackageInstaller(@Nullable Project project, @NotNull NodeSettings nodeSettings, @NotNull String packageName, @Nullable String version, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener, @Nullable String extraOptions) {
        if (nodeSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeSettings", "com/intellij/lang/javascript/modules/PackageInstaller", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/modules/PackageInstaller", "<init>"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/modules/PackageInstaller", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/modules/PackageInstaller", "<init>"));
        }
        super(project, "Install npm module '" + packageName + "'", false);
        this.myNodeSettings = nodeSettings;
        this.myPackageName = packageName;
        this.myVersion = version;
        this.myWorkingDir = workingDir;
        this.myListener = listener;
        this.myExtraOptions = extraOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        String npmExePath;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/modules/PackageInstaller", "run"));
        }
        String packageAndVersion = this.myPackageName;
        if (this.myVersion != null) {
            packageAndVersion = packageAndVersion + "@" + this.myVersion;
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"install", packageAndVersion});
        if (this.myExtraOptions != null) {
            Collections.addAll(args, this.myExtraOptions.split(" +"));
        }
        if ((npmExePath = this.myNodeSettings.getGuessedNpmExePath()) == null) {
            String message = "Cannot determine location of npm by node interpreter: " + this.myNodeSettings.getInterpreterPath();
            LOG.warn(message);
            ApplicationManager.getApplication().invokeLater(() -> this.myListener.operationFinished(this.myPackageName, PackageManagementService.ErrorDescription.fromMessage((String)message)), ModalityState.any());
            return;
        }
        GeneralCommandLine commandLine = NodeCommandLineUtil.createNpmCommandLine(this.myWorkingDir, new File(this.myNodeSettings.getInterpreterPath()), new File(npmExePath), args);
        try {
            ApplicationManager.getApplication().invokeLater(() -> this.myListener.operationStarted(this.myPackageName), ModalityState.any());
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = processHandler.runProcess();
            if (output.getExitCode() != 0) {
                this.myError = NodeCommandLineUtil.formatErrorMessage(commandLine, output);
            }
        }
        catch (ExecutionException e) {
            this.myError = e.getMessage();
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myListener.operationFinished(this.myPackageName, PackageManagementService.ErrorDescription.fromMessage((String)this.myError));
                LocalFileSystem.getInstance().refresh(true);
            }, ModalityState.any());
        }
    }

    public static class Component
    implements NpmPackageInstallerLight {
        @Override
        public void installPackage(@Nullable Project project, @NotNull NodeSettings nodeSettings, @NotNull String packageName, @Nullable String version, @NotNull File workingDir, @NotNull PackageManagementService.Listener listener, @Nullable String extraOptions) {
            if (nodeSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeSettings", "com/intellij/lang/javascript/modules/PackageInstaller$Component", "installPackage"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/modules/PackageInstaller$Component", "installPackage"));
            }
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/modules/PackageInstaller$Component", "installPackage"));
            }
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/modules/PackageInstaller$Component", "installPackage"));
            }
            ProgressManager.getInstance().run((Task)new PackageInstaller(project, nodeSettings, packageName, version, workingDir, listener, extraOptions));
        }
    }
}

