/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSGotoTargetRendererProvider;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JavaScriptGotoSuperHandler
implements LanguageCodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        JSExpression rOperand;
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/navigation/JavaScriptGotoSuperHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/navigation/JavaScriptGotoSuperHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/navigation/JavaScriptGotoSuperHandler", "invoke"));
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        if (at == null) {
            return;
        }
        JSNamedElement namedElement = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)at, JSNamedElement.class);
        PsiElement psiElement = parent = namedElement != null ? namedElement.getParent() : null;
        if (namedElement instanceof JSDefinitionExpression && parent instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)parent).getROperand()) instanceof JSFunctionExpression) {
            namedElement = (JSNamedElement)rOperand;
        }
        if (namedElement instanceof JSFunction) {
            JSNamedElement element;
            JSFunction function = (JSFunction)namedElement;
            Collection<JSPsiElementBase> methods = JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function, true);
            if (methods.isEmpty()) {
                methods = JSInheritanceUtil.findImplementedMethods(function);
            }
            String qName = function.getQualifiedName();
            if (function instanceof JSFunctionExpression && (element = JSUtils.findInitializedElement((JSExpression)((JSFunctionExpression)function))) instanceof JSDefinitionExpression) {
                qName = ((JSDefinitionExpression)element).getExpression().getText();
            }
            if (methods.isEmpty() && qName != null && qName.equals(JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)function))) {
                methods = JSTypeEvaluateManager.findNearestExtendedJSTypes((JSPsiElementBase)function, qName);
            }
            String name = JSFormatUtil.formatMethod(function, 1, 0);
            boolean ecma = namedElement.getContainingFile().getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
            JavaScriptGotoSuperHandler.doNavigate(methods, JSBundle.message((String)(ecma ? "choose.super.method" : "choose.super.function"), (Object[])new Object[]{name, methods.size()}), editor);
        } else if (namedElement instanceof JSClass) {
            String name = JSFormatUtil.formatClass((JSClass)namedElement, 1);
            JSClass[] supers = ((JSClass)namedElement).getSupers();
            JavaScriptGotoSuperHandler.doNavigate(Arrays.asList(supers), JSBundle.message((String)"choose.super.classifier", (Object[])new Object[]{name, supers.length}), editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return true;
    }

    private static void doNavigate(Collection<? extends JSPsiNamedElementBase> items, String popupTitle, Editor e) {
        JSGotoTargetRendererProvider.JSClassListCellRenderer renderer = new JSGotoTargetRendererProvider.JSClassListCellRenderer();
        items = JavaScriptGotoSuperHandler.sort(items, renderer);
        PsiElementListNavigator.openTargets((Editor)e, (NavigatablePsiElement[])items.toArray(new NavigatablePsiElement[items.size()]), (String)popupTitle, null, (ListCellRenderer)((Object)renderer));
    }

    public static List<? extends JSPsiNamedElementBase> sort(Collection<? extends JSPsiNamedElementBase> items, PsiElementListCellRenderer<JSPsiNamedElementBase> renderer) {
        ArrayList<? extends JSPsiNamedElementBase> sorted = new ArrayList<JSPsiNamedElementBase>(items);
        Collections.sort(sorted, renderer.getComparator());
        return sorted;
    }
}

