/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeListImpl
extends JSStubElementImpl<JSAttributeListStub>
implements JSAttributeList {
    public static final TokenSet ourModifiersTypeSet = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PUBLIC_KEYWORD, JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PROTECTED_KEYWORD, JSTokenTypes.INTERNAL_KEYWORD, JSTokenTypes.EXPORT_KEYWORD, JSTokenTypes.DECLARE_KEYWORD});
    private static final ArrayFactory<JSAttribute> myArrayFactory = JSAttribute[]::new;
    private volatile Map<String, Object> myNameToAttributesMap;
    private volatile JSAttribute[] myAttributes;
    private static final Key<CachedValue<String>> ourCachedResolvedNsKey = Key.create((String)"ourCachedResolvedNs");
    private static final UserDataCache<CachedValue<String>, JSElement, Object> ourCachedOpenedNsesCache = new UserDataCache<CachedValue<String>, JSElement, Object>(){

        protected CachedValue<String> compute(JSElement jsElement, Object p) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)JSPsiImplUtils.calcNamespaceReference((PsiElement)jsElement), new Object[]{jsElement.getContainingFile()}), false);
        }
    };

    public JSAttributeListImpl(ASTNode node) {
        super(node);
    }

    public JSAttributeListImpl(JSAttributeListStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSAttributeList((JSAttributeList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public String getNamespace() {
        JSAttributeListStub attributeListStub = (JSAttributeListStub)this.getStub();
        if (attributeListStub != null) {
            return attributeListStub.getNamespace();
        }
        JSReferenceExpression namespaceElement = this.getNamespaceElement();
        return namespaceElement != null ? namespaceElement.getText() : null;
    }

    public JSReferenceExpression getNamespaceElement() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
        return node != null ? (JSReferenceExpression)node.getPsi() : null;
    }

    public String resolveNamespaceValue() {
        String ns = this.tryResolveNamespaceValueFromStub();
        if (ns != null) {
            return ns;
        }
        try {
            return (String)((CachedValue)ourCachedOpenedNsesCache.get(ourCachedResolvedNsKey, (UserDataHolder)this, null)).getValue();
        }
        catch (IndexNotReadyException ex) {
            return this.getNamespace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSAttribute[] getAttributes() {
        if (this.myAttributes == null) {
            JSAttributeListImpl jSAttributeListImpl = this;
            synchronized (jSAttributeListImpl) {
                if (this.myAttributes == null) {
                    this.myAttributes = (JSAttribute[])this.getStubOrPsiChildren((IStubElementType)JSStubElementTypes.ATTRIBUTE, (ArrayFactory)myArrayFactory);
                }
            }
        }
        return this.myAttributes;
    }

    @NotNull
    public JSAttribute[] getAttributesByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "getAttributesByName"));
        }
        this.initAttributes();
        Object o = this.myNameToAttributesMap.get(name);
        if (o == null) {
            if (JSAttribute.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "getAttributesByName"));
            }
            return JSAttribute.EMPTY;
        }
        if (o instanceof JSAttribute) {
            JSAttribute[] jSAttributeArray = new JSAttribute[]{(JSAttribute)o};
            if (jSAttributeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "getAttributesByName"));
            }
            return jSAttributeArray;
        }
        JSAttribute[] jSAttributeArray = (JSAttribute[])o;
        if (jSAttributeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "getAttributesByName"));
        }
        return jSAttributeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes() {
        if (this.myNameToAttributesMap == null) {
            JSAttributeListImpl jSAttributeListImpl = this;
            synchronized (jSAttributeListImpl) {
                if (this.myNameToAttributesMap == null) {
                    THashMap map = null;
                    for (JSAttribute attr : this.getAttributes()) {
                        String name = attr.getName();
                        if (name == null) continue;
                        if (map != null) {
                            Object o = map.get(name);
                            if (o == null) {
                                map.put(name, attr);
                                continue;
                            }
                            if (o instanceof JSAttribute) {
                                map.put(name, new JSAttribute[]{(JSAttribute)o, attr});
                                continue;
                            }
                            map.put(name, ArrayUtil.append((Object[])((JSAttribute[])o), (Object)attr, JSAttribute.class));
                            continue;
                        }
                        map = new THashMap();
                        map.put(name, attr);
                    }
                    if (map == null) {
                        map = Collections.emptyMap();
                    }
                    this.myNameToAttributesMap = map;
                }
            }
        }
    }

    public JSAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "findAttributeByName"));
        }
        this.initAttributes();
        Object o = this.myNameToAttributesMap.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof JSAttribute) {
            return (JSAttribute)o;
        }
        return ((JSAttribute[])o)[0];
    }

    public boolean hasExplicitModifier(JSAttributeList.ModifierType modifier) {
        return this.findModifierNode(modifier) != null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myNameToAttributesMap = null;
        this.myAttributes = null;
    }

    protected Object clone() {
        JSAttributeListImpl attrList = (JSAttributeListImpl)((Object)super.clone());
        attrList.myNameToAttributesMap = null;
        attrList.myAttributes = null;
        return attrList;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType explicitAccessType = this.getExplicitAccessType();
        if (explicitAccessType != null) {
            JSAttributeList.AccessType accessType = explicitAccessType;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "getAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = JSUtils.getImplicitAccessType(this.getParent());
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "getAccessType"));
        }
        return accessType;
    }

    public JSAttributeList.AccessType getExplicitAccessType() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getStub();
        if (stub != null) {
            return stub.getExplicitAccessType();
        }
        ASTNode node = this.getNode().findChildByType(ourModifiersTypeSet);
        if (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType == JSTokenTypes.PUBLIC_KEYWORD || nodeType == JSTokenTypes.EXPORT_KEYWORD || nodeType == JSTokenTypes.DECLARE_KEYWORD) {
                return JSAttributeList.AccessType.PUBLIC;
            }
            if (nodeType == JSTokenTypes.PROTECTED_KEYWORD) {
                return JSAttributeList.AccessType.PROTECTED;
            }
            if (nodeType == JSTokenTypes.PRIVATE_KEYWORD) {
                return JSAttributeList.AccessType.PRIVATE;
            }
            if (nodeType == JSTokenTypes.INTERNAL_KEYWORD) {
                return JSAttributeList.AccessType.PACKAGE_LOCAL;
            }
        }
        return null;
    }

    public PsiElement findAccessTypeElement() {
        ASTNode modifier = this.getNode().findChildByType(ourModifiersTypeSet);
        return modifier != null ? modifier.getPsi() : null;
    }

    public JSConditionalCompileVariableReference getConditionalCompileVariableReference() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getStub();
        if (stub != null && !stub.hasConditionalCompilerVariable()) {
            return null;
        }
        ASTNode conditionalCompileVarRef = this.getNode().findChildByType(JSElementTypes.CONDITIONAL_COMPILE_VARIABLE_REFERENCE);
        return conditionalCompileVarRef != null ? (JSConditionalCompileVariableReference)conditionalCompileVarRef.getPsi() : null;
    }

    public boolean hasModifier(JSAttributeList.ModifierType modifier) {
        PsiElement parent;
        JSAttributeListStub stub = (JSAttributeListStub)this.getStub();
        if (stub != null) {
            return stub.hasModifier(modifier);
        }
        if (this.hasExplicitModifier(modifier)) {
            return true;
        }
        if (modifier == JSAttributeList.ModifierType.STATIC && (parent = this.getParent()) instanceof JSNamespaceDeclaration) {
            PsiElement grandParent = JSResolveUtil.findParent(parent);
            return grandParent instanceof JSClass;
        }
        return false;
    }

    @Nullable
    private ASTNode findModifierNode(JSAttributeList.ModifierType modifier) {
        IElementType type = null;
        switch (modifier) {
            case DYNAMIC: {
                type = JSTokenTypes.DYNAMIC_KEYWORD;
                break;
            }
            case OVERRIDE: {
                type = JSTokenTypes.OVERRIDE_KEYWORD;
                break;
            }
            case NATIVE: {
                type = JSTokenTypes.NATIVE_KEYWORD;
                break;
            }
            case STATIC: {
                type = JSTokenTypes.STATIC_KEYWORD;
                break;
            }
            case FINAL: {
                type = JSTokenTypes.FINAL_KEYWORD;
                break;
            }
            case VIRTUAL: {
                type = JSTokenTypes.VIRTUAL_KEYWORD;
                break;
            }
            case DECLARE: {
                type = JSTokenTypes.DECLARE_KEYWORD;
                break;
            }
            case ASYNC: {
                type = JSTokenTypes.ASYNC_KEYWORD;
                break;
            }
            case CONST: {
                type = JSTokenTypes.CONST_KEYWORD;
                break;
            }
            case ABSTRACT: {
                type = JSTokenTypes.ABSTRACT_KEYWORD;
                break;
            }
            case READONLY: {
                type = JSTokenTypes.READONLY_KEYWORD;
            }
        }
        return type != null ? this.getNode().findChildByType(type) : null;
    }

    @Nullable
    public PsiElement findModifierElement(JSAttributeList.ModifierType modifier) {
        ASTNode node = this.findModifierNode(modifier);
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl", "add"));
        }
        if (element.getNode().getElementType() == JSTokenTypes.OVERRIDE_KEYWORD) {
            return JSChangeUtil.doDoAddBefore((PsiElement)this, element, this.getFirstChild());
        }
        return JSChangeUtil.doDoAddAfter((PsiElement)this, element, this.getLastChild());
    }

    @Nullable
    public String tryResolveNamespaceValueFromStub() {
        String resolvedNamespace;
        JSAttributeListStub stub = (JSAttributeListStub)this.getStub();
        if (stub != null && !"-\"-".equals(resolvedNamespace = stub.getResolvedNamespace())) {
            return resolvedNamespace;
        }
        return null;
    }
}

