/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSOffsetBasedImplicitElement
extends JSImplicitElementImpl {
    private final int myOffset;
    @NotNull
    private final PsiFile myFile;

    public JSOffsetBasedImplicitElement(@NotNull JSImplicitElementImpl.Builder builder, int offset, @NotNull PsiFile file) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/impl/JSOffsetBasedImplicitElement", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/impl/JSOffsetBasedImplicitElement", "<init>"));
        }
        super(builder.setProvider((PsiElement)file));
        this.myOffset = offset;
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        JSOffsetBasedImplicitElement jSOffsetBasedImplicitElement = this;
        if (jSOffsetBasedImplicitElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSOffsetBasedImplicitElement", "getNavigationElement"));
        }
        return jSOffsetBasedImplicitElement;
    }

    public void navigate(boolean requestFocus) {
        PsiElement psiElement = this.getElementAtOffset();
        if (psiElement instanceof Navigatable) {
            ((Navigatable)psiElement).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return !(this.myFile instanceof JSFile) || !((JSFile)this.myFile).isMinified();
    }

    @Nullable
    public PsiElement getElementAtOffset() {
        return this.myFile.findElementAt(this.myOffset);
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof XmlAttributeValue) {
            PsiElement psiElement = this.getElementAtOffset();
            return psiElement != null && psiElement.getParent() == another;
        }
        return another instanceof JSOffsetBasedImplicitElement && this.myFile.isEquivalentTo((PsiElement)((JSOffsetBasedImplicitElement)another).myFile) && this.myOffset == ((JSOffsetBasedImplicitElement)another).myOffset && this.structureEquals((JSOffsetBasedImplicitElement)another);
    }

    public int getTextOffset() {
        return this.myOffset;
    }

    @Override
    @NotNull
    protected JSImplicitElementImpl.Builder toBuilder() {
        Builder builder = new Builder(this.myName, this.myOffset, this.myFile);
        this.fillBuilder(builder);
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSOffsetBasedImplicitElement", "toBuilder"));
        }
        return builder2;
    }

    private static class Builder
    extends JSImplicitElementImpl.Builder {
        private final int myOffset;
        @NotNull
        private final PsiFile myFile;

        public Builder(@NotNull String name, int offset, @NotNull PsiFile file) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSOffsetBasedImplicitElement$Builder", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/impl/JSOffsetBasedImplicitElement$Builder", "<init>"));
            }
            super(name, (PsiElement)file);
            this.myOffset = offset;
            this.myFile = file;
        }

        @Override
        public JSImplicitElementImpl toImplicitElement() {
            return new JSOffsetBasedImplicitElement(this, this.myOffset, this.myFile);
        }
    }
}

