/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTextReference
implements PsiPolyVariantReference,
EmptyResolveMessageProvider,
LocalQuickFixProvider {
    @NotNull
    private final String myCanonicalText;
    @NotNull
    private final TextRange myRangeInElement;
    private final boolean myMethodRef;
    protected JSReferenceSet mySet;

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset, boolean methodRef) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        this(set, s, methodRef, new TextRange(offset, offset + s.length()));
    }

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, boolean methodRef, @NotNull TextRange rangeInElement) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        if (rangeInElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInElement", "com/intellij/lang/javascript/psi/impl/JSTextReference", "<init>"));
        }
        this.mySet = set;
        this.myCanonicalText = s;
        this.myRangeInElement = rangeInElement;
        this.myMethodRef = methodRef;
    }

    public PsiElement getElement() {
        return this.mySet.element;
    }

    public TextRange getRangeInElement() {
        return this.myRangeInElement;
    }

    @Nullable
    public PsiElement resolve() {
        Object[] resolveResults = this.multiResolve(false);
        if (resolveResults.length == 1) {
            return resolveResults[0].getElement();
        }
        if (resolveResults.length == 0) {
            return null;
        }
        int validElements = 0;
        PsiElement lastValid = null;
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) continue;
            ++validElements;
            lastValid = resolveResult.getElement();
        }
        if (validElements > 1) {
            return null;
        }
        if (validElements == 1) {
            return lastValid;
        }
        ResolveResult element = (ResolveResult)ArrayUtil.getLastElement((Object[])resolveResults);
        return element != null ? element.getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        int i = StringUtil.lastIndexOfAny((CharSequence)newElementName, (String)".#~");
        if (i != -1) {
            newElementName = newElementName.substring(0, i);
        }
        return JSTextReference.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSTextReference", "bindToElement"));
        }
        String qName = JSPsiImplUtils.getQNameForMove(this.getElement(), element);
        if (qName != null) {
            JSTextReference.handleContentChange(this.getElement(), new TextRange(this.mySet.myReferences[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset()), qName);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            return JSResolveUtil.isReferenceTo(this, this.myCanonicalText, element);
        }
        return false;
    }

    public boolean isPrimary() {
        return this.mySet.getReferences()[0] == this;
    }

    public boolean isOnlyFqns() {
        return this.mySet.onlyFqns;
    }

    public Collection<String> getBaseClassFqns() {
        return this.mySet.myBaseClassFqns;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void processToSink(PsiFile containingFile, ResultSink resultSink) {
        MyResolveProcessor processor = this.createResolveProcessor(resultSink.getName(), resultSink.place, resultSink);
        this.doProcess(containingFile, processor);
    }

    protected MyResolveProcessor createResolveProcessor(String name, PsiElement place, ResultSink resultSink) {
        return new MyResolveProcessor(name, place, resultSink);
    }

    @Nullable
    public List<String> fillContextNames() {
        ArrayList<String> contextNames = null;
        PsiReference prevContextReference = null;
        for (PsiReference ref : this.mySet.myReferences) {
            if (ref == this) break;
            if (contextNames == null) {
                contextNames = new ArrayList<String>(3);
            }
            contextNames.add(ref.getCanonicalText());
            prevContextReference = ref;
        }
        if (contextNames == null && this.myRangeInElement.getStartOffset() > 0) {
            JSExpression expression;
            PsiElement elt = this.findNearestClass();
            if (this.myMethodRef && elt instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)elt).getExpression()) instanceof JSAssignmentExpression) {
                JSExpression jsExpression = ((JSAssignmentExpression)expression).getLOperand();
                if (jsExpression instanceof JSDefinitionExpression) {
                    jsExpression = ((JSDefinitionExpression)jsExpression).getExpression();
                }
                if (jsExpression instanceof JSReferenceExpression) {
                    String qualifier;
                    JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                    boolean stripQualifier = true;
                    if (rOperand instanceof JSFunction && ((JSFunction)rOperand).isConstructor()) {
                        stripQualifier = false;
                    }
                    if (stripQualifier) {
                        jsExpression = ((JSReferenceExpression)jsExpression).getQualifier();
                    }
                    if (jsExpression != null && (qualifier = JSContextResolver.getQualifierOfExprAsString((JSElement)jsExpression)) != null) {
                        contextNames = new ArrayList<String>(3);
                        BaseJSSymbolProcessor.addIndexListFromQName(qualifier, contextNames);
                    }
                }
            }
        } else if (contextNames != null) {
            String qName;
            PsiElement psiElement = prevContextReference.resolve();
            if (psiElement instanceof XmlToken) {
                BaseJSSymbolProcessor.TagContextBuilder builder = new BaseJSSymbolProcessor.TagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement instanceof JSClass && (qName = ((JSClass)psiElement).getQualifiedName()) != null) {
                contextNames = new ArrayList<String>(3);
                BaseJSSymbolProcessor.addIndexListFromQName(qName, contextNames);
            }
        }
        return contextNames;
    }

    public boolean isSoft() {
        return this.mySet.isSoft();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.mySet.element.getContainingFile();
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file, this, new MyResolver(this, file));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    protected ResolveResult[] doResolve(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/psi/impl/JSTextReference", "doResolve"));
        }
        if ("int".equals(this.myCanonicalText) || "uint".equals(this.myCanonicalText) || ("Null".equals(this.myCanonicalText) || "null".equals(this.myCanonicalText) || "Undefined".equals(this.myCanonicalText)) && this.getElement() instanceof JSDocTagValue) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.element)};
        }
        if (this.useActionScriptIndex(psiFile)) {
            MyResolveProcessor processor = this.createResolveProcessor(this.myCanonicalText, (PsiElement)psiFile, new ResolveResultSink((PsiElement)psiFile, this.myCanonicalText));
            this.doProcess(psiFile, processor);
            return processor.getResultsAsResolveResults();
        }
        return this.doSymbolResolve(psiFile);
    }

    public boolean useActionScriptIndex(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/psi/impl/JSTextReference", "useActionScriptIndex"));
        }
        return JSResolveUtil.isActionScript(psiFile) || this.mySet.onlyFqns;
    }

    private void doProcess(PsiFile psiFile, SinkResolveProcessor processor) {
        PsiElement nearestClass = this.findNearestClass();
        int index = this.calcMyIndex();
        if (index == 0) {
            if ("this".equals(this.myCanonicalText) && nearestClass instanceof JSClass) {
                processor.addResult(nearestClass);
                return;
            }
            if (this.myRangeInElement.getStartOffset() > 0) {
                if (nearestClass instanceof JSClass && !(this.mySet.element instanceof JSLiteralExpression)) {
                    processor.setToProcessHierarchy(true);
                    processor.setTypeContext(true);
                    processor.configureClassScope((JSClass)nearestClass);
                    if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                        return;
                    }
                }
            } else if (nearestClass instanceof JSClass) {
                processor.setTypeContext(true);
                processor.setToProcessMembers(false);
                if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                    return;
                }
                if (!this.mySet.onlyFqns && this.mySet.element instanceof JSDocTagValue) {
                    String packageName = JSResolveUtil.getPackageName(nearestClass);
                    processor.setForcedPackageName(packageName);
                    String classQName = !packageName.isEmpty() ? packageName + "." + this.myCanonicalText : this.myCanonicalText;
                    PsiElement clazz = JSDialectSpecificHandlersFactory.forElement(nearestClass).getClassResolver().findClassByQName(classQName, nearestClass);
                    if (clazz != null && !clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), clazz, clazz)) {
                        return;
                    }
                }
            }
            PsiElement startFrom = this.mySet.element;
            PsiElement lastParent = this.mySet.element.getParent();
            if (this.mySet.element instanceof JSLiteralExpression) {
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.mySet.element, JSFunction.class);
                while (fun != null) {
                    startFrom = fun;
                    lastParent = fun.getParent();
                    fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
                }
            }
            JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, this.mySet.element);
            if (!(psiFile instanceof JSFile) && !(psiFile instanceof XmlFile) && psiFile.getContext() == null) {
                JSResolveUtil.processGlobalThings(processor, ResolveState.initial(), (PsiElement)psiFile, (PsiElement)psiFile);
            }
        } else {
            PsiElement psiElement = JSResolveUtil.unwrapProxy(this.mySet.myReferences[index - 1].resolve());
            if (psiElement instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)psiElement).getType() == JSImplicitElement.Type.Tag) {
                psiElement = ((JSOffsetBasedImplicitElement)psiElement).getElementAtOffset();
            }
            if (psiElement instanceof XmlToken) {
                BaseJSSymbolProcessor.TagContextBuilder builder = new BaseJSSymbolProcessor.TagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement != null) {
                JSType type = null;
                if (psiElement instanceof JSVariable) {
                    type = ((JSVariable)psiElement).getType();
                } else if (psiElement instanceof JSFunction && ((JSFunction)psiElement).isGetProperty()) {
                    type = ((JSFunction)psiElement).getReturnType();
                }
                if (type != null) {
                    String typeText = type.getTypeText();
                    typeText = JSTypeUtils.getTypeMatchingNamespace(typeText);
                    String qname = JSImportHandlingUtil.resolveTypeName(typeText, psiElement);
                    assert (qname != null);
                    PsiElement typeClass = JSClassResolver.findClassFromNamespace(qname, psiElement);
                    if (typeClass instanceof JSClass) {
                        psiElement = typeClass;
                    }
                }
                if (psiElement instanceof JSClass) {
                    processor.setToProcessHierarchy(true);
                }
                String packageName = null;
                if (psiElement instanceof JSPackageWrapper) {
                    packageName = ((JSPackageWrapper)psiElement).getQualifiedName();
                } else if (psiElement instanceof JSClass) {
                    packageName = JSResolveUtil.getPackageName(psiElement);
                }
                if (packageName != null) {
                    processor.setForcedPackageName(packageName);
                }
                if (psiElement instanceof JSClass) {
                    processor.configureClassScope((JSClass)psiElement);
                    processor.setAllowUnqualifiedStaticsFromInstance(true);
                }
                psiElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), psiElement, psiElement);
            }
        }
        if (psiFile instanceof XmlFile && !JavaScriptSupportLoader.isMxmlOrFxgFile(psiFile)) {
            JSResolveUtil.processTopLevelClasses(processor, ResolveState.initial(), psiFile.getProject(), JSResolveUtil.getResolveScope((PsiElement)psiFile), this.mySet.onlyFqns ? JSResolveUtil.GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : JSResolveUtil.GlobalSymbolsAcceptanceState.WHATEVER, false);
        }
    }

    private int calcMyIndex() {
        int i;
        for (i = 0; i < this.mySet.myReferences.length && this.mySet.myReferences[i] != this; ++i) {
        }
        return i;
    }

    private PsiElement findNearestClass() {
        PsiElement originalElement;
        PsiElement parent;
        PsiElement elt = this.mySet.element;
        PsiElement candidateBlock = null;
        while (!((parent = elt.getParent()) instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTagChild)) {
            if (parent instanceof JSBlockStatement) {
                candidateBlock = elt;
            }
            if ((elt = parent) != null && !(elt instanceof JSClass)) continue;
        }
        if (parent instanceof XmlTag) {
            if (XmlBackedJSClassImpl.isComponentTag((XmlTag)parent)) {
                XmlTag[] subtags = ((XmlTag)parent).getSubTags();
                if (subtags.length > 0) {
                    elt = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(subtags[0]);
                }
            } else {
                XmlFile xmlFile = (XmlFile)parent.getContainingFile();
                if (JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)xmlFile)) {
                    elt = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
                }
            }
        }
        if (elt != null && !(elt instanceof JSClass) && candidateBlock != null) {
            elt = candidateBlock;
        }
        if (elt != null && (originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)elt)) != null) {
            elt = originalElement;
        }
        return elt;
    }

    private ResolveResult[] doSymbolResolve(PsiFile psiFile) {
        ResolveResult[] localResults;
        String name;
        if ("*".equals(this.myCanonicalText) || "?".equals(this.myCanonicalText)) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.element)};
        }
        if (this.mySet.element instanceof JSDocTagValue && this.myRangeInElement.getStartOffset() == 0 && this.mySet.myReferences.length == 1 && "property".equals(name = ((JSDocTag)this.mySet.element.getParent()).getName())) {
            return new ResolveResult[]{new JSResolveResult(this.mySet.element)};
        }
        List<String> contextIds = this.fillContextNames();
        String text = this.myCanonicalText;
        PsiElement elt = this.getElement();
        if ((elt instanceof JSDocTagValue || elt instanceof JSDocComment) && this.mySet.myReferences.length == 1 && this.mySet.myReferences[this.mySet.myReferences.length - 1] == this && !this.myMethodRef) {
            text = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(text);
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(text, contextIds != null ? ArrayUtil.toStringArray(contextIds) : BaseJSSymbolProcessor.EMPTY_CONTEXT, psiFile, this.mySet.element, BaseJSSymbolProcessor.MatchMode.Any);
        processor.allowPartialResults();
        processor.setAddOnlyCompleteMatches(contextIds != null || !(this.mySet.element instanceof JSLiteralExpression));
        StringBuilder b = new StringBuilder();
        for (PsiReference ref : this.mySet.myReferences) {
            if (b.length() > 0) {
                b.append('.');
            }
            b.append(ref.getCanonicalText());
            if (ref == this) break;
        }
        String str = b.toString();
        PsiElement context = psiFile.getContext();
        if (str.indexOf(46) == -1) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(this.mySet.element, str));
            this.processLocalVariants(psiFile, localProcessor, context);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            return localResults;
        }
        if (context != null) {
            JSResolveUtil.tryProcessXmlFileImplicitElements(context, processor);
        }
        JSReferenceExpressionResolver.processAllSymbols(processor);
        return processor.getResults();
    }

    public void processLocalVariants(PsiFile psiFile, final SinkResolveProcessor<?> processor, PsiElement context) {
        PsiElement next;
        PsiComment psiComment;
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSDocComment.class);
        if (docComment != null) {
            List currentParameters = docComment.getGenericParameters();
            if (!currentParameters.isEmpty()) {
                JSTextReference.processGenericParameters(currentParameters, docComment, processor);
            } else {
                List parameters;
                JSDocComment definitionComment;
                JSQualifiedName namespace;
                PsiElement element = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                if (element instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)element).getNamespace()) != null && (definitionComment = JSGenericsIndex.findGenericParametersComment(namespace.getQualifiedName(), GlobalSearchScope.fileScope((PsiFile)psiFile))) != null && !(parameters = definitionComment.getGenericParameters()).isEmpty()) {
                    JSTextReference.processGenericParameters(parameters, definitionComment, processor);
                }
            }
        }
        if (context != null || this.mySet.myReferences[0] == this && !this.myMethodRef) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.mySet.element, JSFunction.class);
            if (fun != null) {
                String name = processor.getName();
                JSResolveUtil.treeWalkUp(new ResolveProcessor(name){
                    {
                        super(name);
                        this.setProcessingOptions(new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions());
                    }

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSTextReference$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSTextReference$1", "execute"));
                        }
                        return processor.execute(element, state);
                    }
                }, (PsiElement)fun, fun.getFirstChild(), this.mySet.element);
            }
            if (context != null) {
                JSResolveUtil.treeWalkUp(processor, (PsiElement)psiFile, (PsiElement)psiFile, this.mySet.element);
            }
        } else if (this.myMethodRef && (psiComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)this.mySet.element, PsiComment.class)) != null && psiComment.getTokenType() == JSTokenTypes.DOC_COMMENT && (next = JSDocumentationUtils.findAttachedElementFromComment(psiComment)) instanceof JSProperty) {
            JSResolveUtil.treeWalkUp(processor, this.mySet.element, this.mySet.element, next);
        }
    }

    private static void processGenericParameters(@NotNull List<String> parameters, @NotNull JSDocComment comment, @NotNull SinkResolveProcessor<?> processor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/impl/JSTextReference", "processGenericParameters"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/psi/impl/JSTextReference", "processGenericParameters"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSTextReference", "processGenericParameters"));
        }
        for (String parameter : parameters) {
            processor.execute((PsiElement)new JSImplicitElementImpl(parameter, (PsiElement)comment), ResolveState.initial());
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String text = this.getCanonicalText();
        text = "'" + text.replace("'", "''") + "'";
        String string = JSBundle.message((String)(this.mySet.element != null && this.mySet.element.getParent() instanceof TypeScriptImportStatement ? "javascript.unresolved.file" : "javascript.unresolved.variable.or.type.name.message2"), (Object[])new Object[]{text});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSTextReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public LocalQuickFix[] getQuickFixes() {
        return this.mySet.myLocalQuickFixProvider == null ? LocalQuickFix.EMPTY_ARRAY : this.mySet.myLocalQuickFixProvider.getQuickFixes();
    }

    private static PsiElement handleContentChange(PsiElement elt, TextRange range, String newElementName) {
        return ElementManipulators.getManipulator((PsiElement)elt).handleContentChange(elt, range, newElementName);
    }

    static class MyResolver
    implements JSResolveUtil.Resolver<JSTextReference> {
        private final JSTextReference myTextReference;
        private final PsiFile myContainingFile;

        MyResolver(JSTextReference reference, PsiFile file) {
            this.myTextReference = reference;
            this.myContainingFile = file;
        }

        @Override
        public ResolveResult[] doResolve() {
            return this.myTextReference.doResolve(this.myContainingFile);
        }
    }

    protected class MyResolveProcessor
    extends SinkResolveProcessor {
        private String normalizedQN;

        public MyResolveProcessor(String name, @NotNull PsiElement _place, ResultSink sink) {
            if (sink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor", "<init>"));
            }
            super(name, _place, sink);
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            String qName;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSTextReference$MyResolveProcessor", "execute"));
            }
            if (JSTextReference.this.mySet.onlyFqns) {
                if (!(element instanceof JSPackageWrapper) && !(element instanceof JSClass)) {
                    return true;
                }
                if (this.myName != null && element instanceof JSClass && this.myName.equals(((JSClass)element).getName())) {
                    if (this.normalizedQN == null) {
                        this.normalizedQN = StringUtil.stripQuotesAroundValue((String)JSTextReference.this.mySet.myReferenceText).replace(':', '.');
                    }
                    if (!this.normalizedQN.equals(((JSClass)element).getQualifiedName())) {
                        return true;
                    }
                }
            }
            if (JSTextReference.this.mySet.myOnlyDefaultPackage && element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.isEmpty((String)StringUtil.getPackageName((String)qName))) {
                return true;
            }
            return super.execute(element, state);
        }
    }

    public static interface JSDeclarationModuleReference {
    }
}

