/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedItemProcessor<T extends ResultSink>
extends SinkResolveProcessor<T>
implements JSTypeProcessor {
    private final boolean myEcma;
    private final boolean myTypeScript;
    public TypeResolveState resolved = TypeResolveState.Unknown;
    public static final Key<Boolean> RECORD_TYPE_PROPERTY_KEY = Key.create((String)"js.record.type.property");

    public QualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink);
        DialectOptionHolder holder = DialectDetector.dialectOfFile(containingFile);
        this.myEcma = holder != null && holder.isECMA4;
        this.myTypeScript = holder != null && holder.isTypeScript;
        this.setToProcessHierarchy(true);
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "process"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "process"));
        }
        if (type instanceof JSRecordType) {
            this.processRecordTypeImpl((JSRecordType)type, source);
            if (type.getSource().isExplicitlyDeclared() && ((ResultSink)this.getResultSink()).isTypeScript()) {
                this.resolved = TypeResolveState.Resolved;
            }
            return;
        }
        if (evaluateContext.ensureProcessed(type.getTypeText(JSType.TypeTextFormat.SERIALIZED))) {
            return;
        }
        if (!JSTypeUtils.processExpandedType(this, type, evaluateContext, source)) {
            return;
        }
        String typeString = JSTypeUtils.getQualifiedNameMatchingType(type, true);
        if (type instanceof JSAnyType || typeString == null) {
            return;
        }
        PsiElement typeSource = evaluateContext.getSource();
        this.setProcessStatics(false);
        PsiElement placeParent = this.place.getParent();
        boolean setTypeContext = placeParent instanceof JSReferenceListMember;
        if (this.myEcma || source instanceof XmlBackedJSClass) {
            PsiElement clazz;
            PsiElement psiElement = clazz = source != null && (source instanceof JSClass || source instanceof XmlFile) ? source : JSClassResolver.findClassFromNamespace(typeString, this.place);
            if (clazz instanceof JSQualifiedNamedElement && this.needProcessTypeMembers(source, clazz)) {
                this.addTypeFromClass(type, evaluateContext, typeString, typeSource, setTypeContext, (JSQualifiedNamedElement)clazz);
            }
            if (type instanceof JSObjectType) {
                this.resolved = TypeResolveState.Unknown;
            } else if ((clazz == null || !(clazz instanceof JSQualifiedNamedElement)) && type.getSource().isExplicitlyDeclared()) {
                this.resolved = TypeResolveState.Resolved;
            }
        }
    }

    @Override
    public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "processNamespace"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "processNamespace"));
        }
        BaseJSSymbolProcessor.TypeProcessorBase.processNamespaceAsType(this, (JSNamespace)namespace, evaluateContext, source);
    }

    @Override
    public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "processResolvedElement"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "processResolvedElement"));
        }
        if (element instanceof JsonElement) {
            JsonValue value = null;
            if (element instanceof JsonFile) {
                value = ((JsonFile)element).getTopLevelValue();
            } else if (element instanceof JsonProperty) {
                value = ((JsonProperty)element).getValue();
            } else if (element instanceof JsonValue) {
                value = (JsonValue)element;
            }
            if (value instanceof JsonObject) {
                String name = this.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        this.addResult((PsiElement)property);
                    }
                } else {
                    List list = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list) {
                        this.addResult((PsiElement)property);
                    }
                }
                this.resolved = TypeResolveState.Resolved;
            }
        } else if (element instanceof JSFile && (evaluateContext.isJSElementsToApplyEmpty() || evaluateContext.peekJSElementToApply() instanceof JSNewExpression && evaluateContext.getJSElementsToApply().size() == 1) && !ES6PsiUtil.processExportDeclarationInScope((JSElement)((JSFile)element), this, ResolveState.initial(), null, this.place)) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type, PsiElement realSource) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "processRecordTypeImpl"));
        }
        PsiElement sourceElement = realSource != null && realSource != PsiUtilCore.NULL_PSI_ELEMENT ? realSource : type.getSource().getSourceElement();
        boolean processedDeclarationDirectly = false;
        boolean hasCallSignature = false;
        if (sourceElement != null && sourceElement.isValid()) {
            processedDeclarationDirectly = true;
            if (sourceElement instanceof TypeScriptObjectType) {
                this.setProcessStatics(true);
                sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), null, this.place);
                for (JSProperty jSProperty : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    if (!(jSProperty instanceof TypeScriptCallSignature)) continue;
                    hasCallSignature = true;
                    break;
                }
            } else if (sourceElement instanceof JSObjectLiteralExpression) {
                for (JSProperty jSProperty : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                    this.execute((PsiElement)jSProperty, ResolveState.initial());
                }
            } else {
                if (sourceElement instanceof JSClassExpression) {
                    Collection<JSType> constructors = JSTypeUtils.getFunctionType((JSType)type, true);
                    this.setProcessStatics(!constructors.isEmpty());
                    sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place);
                    return;
                }
                processedDeclarationDirectly = false;
            }
        }
        if (!processedDeclarationDirectly) {
            for (JSRecordType.TypeMember typeMember : type.getTypeMembers()) {
                hasCallSignature |= typeMember instanceof JSRecordType.CallSignature;
                if (!(typeMember instanceof JSRecordType.PropertySignature)) continue;
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
                String string = this.getName();
                this.processRecordProperty(sourceElement, propertySignature, string);
            }
        }
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement)) {
            this.processSuperClassMembers(sourceElement, hasCallSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(PsiElement sourceElement, boolean hasCallSignature) {
        int level = ((ResultSink)this.getResultSink()).getNestingLevel();
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        ((ResultSink)this.getResultSink()).setNestingLevel(10);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature ? "Function" : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, object);
            }
        }
        finally {
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    private void processRecordProperty(PsiElement sourceElement, JSRecordType.PropertySignature propertySignature, String name) {
        if (name == null || name.equals(propertySignature.getName())) {
            JSType propertySignatureType = propertySignature.getType();
            JSImplicitElementImpl element = this.createImplicitElement(sourceElement, propertySignature, propertySignatureType);
            element.putUserData(RECORD_TYPE_PROPERTY_KEY, true);
            if (this.getResultSink() instanceof ResolveResultSink && !DialectDetector.isTypeScript(sourceElement)) {
                this.addPossibleCandidateResult((PsiElement)element, null);
            } else {
                this.addResult((PsiElement)element);
            }
        }
    }

    @NotNull
    private JSImplicitElementImpl createImplicitElement(PsiElement sourceElement, JSRecordType.PropertySignature propertySignature, JSType propertySignatureType) {
        JSImplicitElementImpl.Builder builder;
        if (propertySignatureType instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)propertySignatureType;
            JSImplicitFunctionImpl.Builder funBuilder = new JSImplicitFunctionImpl.Builder(propertySignature.getName(), sourceElement);
            funBuilder.setParameters(functionType.getParametersWithName());
            JSType returnType = functionType.getReturnType();
            if (returnType != null) {
                funBuilder.setReturnType(returnType.getTypeText(this.myTypeScript ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE));
            }
            builder = funBuilder;
        } else {
            builder = new JSImplicitElementImpl.Builder(propertySignature.getName(), sourceElement).setProperties(JSImplicitElement.Property.MinorImportance);
            if (propertySignatureType != null) {
                builder.setTypeString(propertySignatureType.getTypeText(this.myTypeScript ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE));
            }
        }
        builder.setProperties(JSImplicitElement.Property.MinorImportance);
        JSImplicitElementImpl jSImplicitElementImpl = builder.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "createImplicitElement"));
        }
        return jSImplicitElementImpl;
    }

    private static JSRecordType getFunctionTypeMembers(@NotNull PsiElement source, String className) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "getFunctionTypeMembers"));
        }
        ArrayList members = ContainerUtil.newArrayList();
        PsiElement context = TypeScriptPsiUtil.getNonStrictTopLevelContainer(source);
        if (context == null) {
            context = source;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(className, context);
        for (PsiElement psiElement : elements) {
            PsiElement container = TypeScriptPsiUtil.getTopLevelContainer(psiElement);
            if (!(psiElement instanceof JSClass) || container == null || TypeScriptPsiUtil.isExternalModule(container) || TypeScriptModuleAccessibilityChecker.INSTANCE.check(context, psiElement) != null || TypeScriptConfigAccessibilityChecker.INSTANCE.check(context, psiElement) != null) continue;
            JSRecordType current = TypeScriptTypeParser.buildTypeFromClass((JSClass)psiElement, false);
            members.addAll(current.getTypeMembers());
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource(context, true), members);
    }

    public static JSRecordType getFunctionTypeMembers(@Nullable PsiElement source) {
        if (source == null || !DialectDetector.isTypeScript(source)) {
            return null;
        }
        return QualifiedItemProcessor.getFunctionTypeMembers(source, "Function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeFromClass(JSType type, JSEvaluateContext evaluateContext, String typeString, PsiElement typeSource, boolean setTypeContext, JSQualifiedNamedElement jsClass) {
        JSExpression placeQualifier;
        JSReferenceExpression evaluateQualifier;
        if ("RemoteObject".equals(jsClass.getName()) && typeSource instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)typeSource).getType() == JSImplicitElement.Type.Tag) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((JSOffsetBasedImplicitElement)typeSource).getElementAtOffset(), XmlTag.class);
            for (XmlTag method : tag.findSubTags("method", tag.getNamespace())) {
                if (!this.execute((PsiElement)method, ResolveState.initial())) break;
            }
            this.resolved = TypeResolveState.Resolved;
            return;
        }
        boolean statics = false;
        if (!(!JSPsiImplUtils.isTheSameClass(typeSource, jsClass) || (evaluateQualifier = evaluateContext.getProcessedExpression()) == null || (placeQualifier = evaluateQualifier.getQualifier()) instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSParenthesizedExpression || placeQualifier instanceof JSParenthesizedExpression)) {
            statics = true;
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            statics = true;
        }
        this.setProcessStatics(statics);
        if (statics) {
            this.setTypeName(jsClass.getQualifiedName());
        }
        boolean saveSetTypeContext = this.isTypeContext();
        boolean saveToProcessMembers = this.isToProcessMembers();
        if (setTypeContext) {
            this.setTypeContext(setTypeContext);
            this.setToProcessMembers(false);
        }
        try {
            JSAttributeList attrList;
            boolean b;
            if (this.resolved != TypeResolveState.Resolved && ("XML".equals(typeString) || "XMLList".equals(typeString))) {
                this.resolved = TypeResolveState.PrefixUnknown;
            }
            if (!(b = jsClass.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), (PsiElement)jsClass, this.place))) {
                this.resolved = TypeResolveState.Resolved;
            }
            if (this.myEcma && ((attrList = ((JSAttributeListOwner)jsClass).getAttributeList()) == null || !attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                this.resolved = TypeResolveState.Resolved;
            }
        }
        finally {
            if (setTypeContext) {
                this.setTypeContext(saveSetTypeContext);
                this.setToProcessMembers(saveToProcessMembers);
            }
        }
    }

    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        return clazz instanceof JSClass;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "execute"));
        }
        if (this.needPackages() && !(element instanceof JSPackageWrapper)) {
            return true;
        }
        if (this.resolved == TypeResolveState.PrefixUnknown && this.myName != null && element instanceof JSFunction && !(this.place.getParent() instanceof JSCallExpression)) {
            return true;
        }
        boolean b = super.execute(element, state);
        if (this.myEcma && this.getResult() != null) {
            this.resolved = TypeResolveState.Resolved;
        }
        return b;
    }

    @Override
    public void prefixResolved() {
        if (this.myEcma || this.myTypeScript) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    @Override
    protected void elementIsNotAccessible(PsiElement element) {
        super.elementIsNotAccessible(element);
        if (this.myEcma || this.myTypeScript) {
            this.resolved = TypeResolveState.Resolved;
        }
    }

    @Override
    public PsiElement getTarget() {
        return null;
    }

    @Override
    public void setUnknownElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor", "setUnknownElement"));
        }
        if (!(element instanceof XmlToken)) {
            boolean currentIsNotResolved = QualifiedItemProcessor.isDummyResolve(element, this.place);
            this.resolved = currentIsNotResolved ? TypeResolveState.PrefixUnknown : TypeResolveState.Unknown;
        }
    }

    private static boolean isDummyResolve(PsiElement element, PsiElement place) {
        if (place instanceof JSReferenceExpressionImpl) {
            JSExpression originalQualifier = BaseJSSymbolProcessor.getOriginalQualifier(((JSReferenceExpressionImpl)place).getResolveQualifier());
            if (originalQualifier instanceof JSCallExpression) {
                originalQualifier = ((JSCallExpression)originalQualifier).getMethodExpression();
            }
            return originalQualifier == element;
        }
        return false;
    }

    public static enum TypeResolveState {
        Unknown,
        Resolved,
        Undefined,
        PrefixUnknown;

    }
}

