/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsProcessor
extends BaseJSSymbolProcessor
implements JSCompletionProcessor {
    private final MultiMap<String, LookupElement> myResults = MultiMap.create();
    private final Set<JSQualifiedName> myNeighbourReferences = new THashSet();
    private final Set<String> myPopulatedResultsNames = new THashSet();
    private final boolean hasSomeSmartnessAvailable;
    private final boolean myProcessOnlyProperties;
    private boolean weAreInConstructorParameters;
    private boolean myStrictTypeContext;
    private final PrefixMatcher myPrefixMatcher = null;
    private String myReferencedParameterName;
    private boolean myStrictlyTyped;
    private final PsiElement myOriginalElement;
    private static final Key<Boolean> ALL_ELEMENTS_ARE_FUNCTIONS = Key.create((String)"js.all.elements.are.functions");
    private static final Key<Boolean> ALL_FUNCTIONS_HAS_NO_PARAMETERS = Key.create((String)"js.all.functions.has.no.parameters");
    private static final Key<Boolean> HAS_BOLD_ELEMENT = Key.create((String)"js.has.bold.element");
    private static final Key<Integer> PRIORITY = Key.create((String)"js.several.definitions.element.priority");
    private static final Key<Integer> PROXIMITY = Key.create((String)"js.several.definitions.element.proximity");
    private static final Key<Boolean> CONTEXT_MATCHES = Key.create((String)"js.lookup.element.context.matches");

    public VariantsProcessor(String[] nameIds, PsiFile targetFile, PsiElement context, BaseJSSymbolProcessor.MatchMode _matchMode) {
        this(nameIds, targetFile, context, _matchMode, false);
    }

    public VariantsProcessor(String[] nameIds, PsiFile targetFile, PsiElement context, BaseJSSymbolProcessor.MatchMode _matchMode, boolean onlyTypeBased) {
        super(targetFile.getOriginalFile(), context, nameIds, _matchMode);
        nameIds = this.myContextNames;
        boolean processOnlyTypes = false;
        this.myCurrentFile = targetFile.getOriginalFile() == targetFile ? null : targetFile.getOriginalFile().getVirtualFile();
        boolean allTypesResolved = false;
        boolean doAddContextIds = true;
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
        if (onlyTypeBased) {
            this.myAddOnlyCompleteMatchesSet = true;
            this.myAddOnlyCompleteMatches = true;
        }
        this.myReferencedParameterName = null;
        if (context instanceof JSReferenceExpression) {
            JSExpression qualifier;
            JSParameterItem parameter;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)refExpr, (JSArgumentList)parent)) != null) {
                this.myReferencedParameterName = parameter.getName();
            }
            if ((qualifier = refExpr.getQualifier()) != null) {
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
                    if (jsClass != null) {
                        this.myAddOnlyCompleteMatchesSet = true;
                        this.myAddOnlyCompleteMatches = true;
                        this.updateCanUseOnlyCompleteMatches(jsClass);
                        doAddContextIds = false;
                    } else if (JSResolveUtil.getTypeFromTagNameInMxml(this.myTargetFile.getContext()) != null) {
                        this.myAddOnlyCompleteMatchesSet = true;
                        this.myAddOnlyCompleteMatches = true;
                    }
                }
                CompletionTypeProcessor processor = new CompletionTypeProcessor();
                JSTypeEvaluator.evaluateTypes(VariantsProcessor.getOriginalQualifier(qualifier), this.myTargetFile, processor);
                allTypesResolved = processor.getAllTypesResolved();
                if (refExpr.getQualifier() instanceof JSCallExpression) {
                    doAddContextIds = false;
                }
                if (this.myStrictlyTyped) {
                    this.myAddOnlyCompleteMatchesSet = true;
                    this.myAddOnlyCompleteMatches = true;
                }
            } else {
                boolean strictTypeContext = JSResolveUtil.isExprInTypeContext(refExpr);
                if (strictTypeContext || this.ecmal4 && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)refExpr)) {
                    this.myAddOnlyCompleteMatchesSet = true;
                    this.myAddOnlyCompleteMatches = true;
                    processOnlyTypes = true;
                    this.myStrictTypeContext = strictTypeContext;
                    allTypesResolved = true;
                    this.addPackageScope(jsClass, (PsiElement)refExpr);
                }
            }
        } else if (context instanceof JSProperty) {
            String qName;
            JSRecordType recordType;
            JSType value;
            JSObjectLiteralExpression objLiteral = (JSObjectLiteralExpression)context.getParent();
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)objLiteral);
            if (expectedType instanceof JSTypeImpl && expectedType.getSource().getLanguage() == JSTypeSource.SourceLanguage.JS && expectedType.getSource().isExplicitlyDeclared() && (value = JSTypeEvaluateManager.expandTypedefs((PsiElement)expectedType.getSource().getScope(), expectedType.getResolvedTypeText())) != null) {
                expectedType = value;
            }
            if ((recordType = JSVariantRecordTypeConverter.getTypeAsRecord(expectedType, context)) != null) {
                this.myTypeInfo.addRecordType(recordType);
                this.myAddOnlyCompleteMatchesSet = true;
                this.myAddOnlyCompleteMatches = true;
            } else if (expectedType instanceof JSNamedType && (qName = JSTypeUtils.getQualifiedNameMatchingType(expectedType, true)) != null) {
                JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(qName), ((JSNamedType)expectedType).isStaticOrInstance(), expectedType.getSource().isExplicitlyDeclared());
                this.myTypeInfo.addType(namespace, true);
            }
        } else if (context instanceof JSDocTagValue) {
            processOnlyTypes = true;
        }
        if (nameIds != null && nameIds.length > 0 && (!allTypesResolved || this.myTypeInfo.typeAllowAnyProperties()) && doAddContextIds) {
            String join = StringUtil.join((String[])nameIds, (String)".");
            this.buildIndexListFromQNameAndCorrectQName(join);
            this.addSupers(join, JSContext.UNKNOWN);
        }
        this.myProcessOnlyTypes = processOnlyTypes;
        boolean bl = this.myProcessOnlyProperties = context instanceof JSProperty && !this.weAreInConstructorParameters;
        if (this.myTypeInfo.typeWasProcessed() && !this.weAreInConstructorParameters && !this.myProcessOnlyProperties) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.hasSomeSmartnessAvailable = this.myTypeInfo.hasExplicitNamespace();
        this.myOriginalElement = CompletionUtil.getOriginalElement((PsiElement)context);
        this.initCheckFileLevelAccess();
    }

    @Override
    protected String addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy, PsiFile jsModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addNamespace"));
        }
        if (this.weAreInConstructorParameters) {
            JSParameterItem matchedParameter;
            PsiElement grandParent;
            JSQualifiedName qualifiedName = namespace.getQualifiedName();
            qualifiedName = JSQualifiedNameImpl.create("options", qualifiedName);
            namespace = new JSNamespaceImpl(qualifiedName, namespace.getJSContext(), namespace.isExplicitlyDeclared());
            PsiElement parent = this.myContext.getParent();
            if (parent instanceof JSExpression && (grandParent = parent.getParent()) instanceof JSArgumentList && (matchedParameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)parent, (JSArgumentList)grandParent)) != null && matchedParameter.getName() != null) {
                qualifiedName = JSQualifiedNameImpl.create(matchedParameter.getName(), qualifiedName);
                JSNamespaceImpl paramNs = new JSNamespaceImpl(qualifiedName, namespace.getJSContext(), namespace.isExplicitlyDeclared());
                super.addNamespace(paramNs, isTopClassInHierarchy, jsModule);
            }
        }
        return super.addNamespace(namespace, isTopClassInHierarchy, jsModule);
    }

    private void updateCanUseOnlyCompleteMatches(JSClass jsClass) {
        JSAttributeList attributeList;
        JSAttributeList jSAttributeList = attributeList = jsClass != null ? jsClass.getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
            this.myAddOnlyCompleteMatches = false;
        }
    }

    public void populateCompletionList(Collection<? extends LookupElement> resultsAsObjects, boolean keepOverloads, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "populateCompletionList"));
        }
        if (resultsAsObjects == null) {
            return;
        }
        for (LookupElement lookupElement : resultsAsObjects) {
            if (!this.myPopulatedResultsNames.add(lookupElement.getLookupString()) && !keepOverloads) continue;
            resultSet.addElement(lookupElement);
        }
    }

    public void collectReferencesUsedInCurrentScope(final PsiElement reference, final boolean qualified) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)reference, JSExecutionScope.class);
        assert (scope != null) : reference.getContainingFile().getName();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSQualifiedName name;
                if (node != reference && node.getQualifier() != null == qualified && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)node)) != null) {
                    VariantsProcessor.this.myNeighbourReferences.add(name);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
            }
        }.visitElement((PsiElement)scope);
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, JSType type) {
        if (type.getSource().isExplicitlyDeclared()) {
            source = JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT;
        }
        return super.isStrictTypingPossible(source, type);
    }

    private void addSupers(@NotNull String type, JSContext staticOrInstance) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addSupers"));
        }
        this.addSupers(new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(type), staticOrInstance, true));
    }

    private void addSupers(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addSupers"));
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        String type = qualifiedName.getQualifiedName();
        JSContext jsContext = namespace.getJSContext();
        String iteratedType = this.myIteratedTypeName;
        if (jsContext == JSContext.STATIC) {
            type = JSNamedType.appendStaticSuffix(type);
        }
        this.myIteratedTypeName = type;
        SmartList parentClasses = new SmartList();
        this.doIterateHierarchy(type, new BaseJSSymbolProcessor.HierarchyProcessor((List)parentClasses, jsContext){
            final /* synthetic */ List val$parentClasses;
            final /* synthetic */ JSContext val$jsContext;
            {
                this.val$parentClasses = list;
                this.val$jsContext = jSContext;
            }

            @Override
            public boolean processNamespace(String type, VirtualFile file) {
                JSType baseType = JSTypeUtils.createType(type, JSTypeSource.EMPTY);
                if (baseType instanceof JSObjectType || baseType == null) {
                    return true;
                }
                String qName = JSTypeUtils.getQualifiedNameMatchingType(baseType, false);
                if (qName != null) {
                    JSContext jsContext = baseType instanceof JSNamedType ? ((JSNamedType)baseType).isStaticOrInstance() : JSContext.UNKNOWN;
                    JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(qName), jsContext, true);
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String qname = clazz.getQualifiedName();
                if ("Object".equals(qname)) {
                    return true;
                }
                if (qname != null) {
                    JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(qname), this.val$jsContext, true);
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return true;
            }
        });
        this.myIteratedTypeName = iteratedType;
        for (JSNamespace parentClass : parentClasses) {
            this.addNamespace(parentClass, false);
        }
        JSTypeSubstitutor genericArguments = (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY);
        if (genericArguments != null && !genericArguments.isEmpty()) {
            for (JSNamespace parentClass : parentClasses) {
                JSQualifiedName parentClassQName = parentClass.getQualifiedName();
                assert (parentClassQName != null);
                JSTypeSubstitutor parentClassTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qualifiedName.getQualifiedName(), parentClassQName.getQualifiedName(), this.myContext, genericArguments);
                parentClass.putUserData(JSNamespace.GENERIC_ARGUMENTS_KEY, (Object)parentClassTypeSubstitutor);
            }
        }
    }

    public void addNeighbourReferences(boolean onlyApplyPriority) {
        for (JSQualifiedName neighbourReference : this.myNeighbourReferences) {
            if (!this.myTypeInfo.hasMatchedNamespace(neighbourReference.getParent(), JSContext.STATIC)) continue;
            String name = neighbourReference.getName();
            Collection elements = this.myResults.get((Object)name);
            if (!elements.isEmpty()) {
                for (LookupElement element : elements) {
                    if (!(element instanceof LookupItem)) continue;
                    int neighborPriority = JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY.getPriorityValue();
                    double itemPriority = ((LookupItem)element).getPriority();
                    int neighborProximity = JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY.getProximityValue();
                    Integer itemProximity = (Integer)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY);
                    if (!((double)neighborPriority > itemPriority) && ((double)neighborPriority != itemPriority || itemProximity == null || neighborProximity <= itemProximity)) continue;
                    JSCompletionUtil.setJSLookupPriority((LookupItem)element, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY);
                }
                continue;
            }
            if (onlyApplyPriority) continue;
            LookupElementBuilder element = LookupElementBuilder.create((String)name);
            element = JSCompletionUtil.withJSLookupPriority((LookupElement)element, JSLookupPriority.NEIGHBOUR_REFERENCES_PRIORITY);
            this.myResults.putValue((Object)name, (Object)element);
        }
    }

    private void buildSeveralDefinitionsElements() {
        for (Map.Entry entry : this.myResults.entrySet()) {
            Boolean function;
            Collection value = (Collection)entry.getValue();
            LookupElement element = value.isEmpty() ? null : (LookupElement)value.iterator().next();
            if (!(element instanceof LookupElementBuilder)) continue;
            Integer priority = (Integer)element.getUserData(PRIORITY);
            Integer proximity = (Integer)element.getUserData(PROXIMITY);
            if (priority == null || proximity == null) continue;
            LookupElementBuilder lookupItem = (LookupElementBuilder)element;
            Boolean bold = (Boolean)element.getUserData(HAS_BOLD_ELEMENT);
            if (bold != null && bold.booleanValue()) {
                lookupItem = lookupItem.withBoldness(true);
            }
            if (Boolean.TRUE.equals(function = (Boolean)element.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS))) {
                lookupItem = lookupItem.withInsertHandler(JSInsertHandler.DEFAULT).withTailText("()");
                JSInsertHandler.ForcedCompleteFunctionType completeFunctionType = Boolean.TRUE.equals(element.getUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS)) ? JSInsertHandler.ForcedCompleteFunctionType.EMPTY_PARAMETERS : JSInsertHandler.ForcedCompleteFunctionType.WITH_PARAMETERS;
                lookupItem.putUserData(JSInsertHandler.FORCED_COMPLETE_FUNCTION, (Object)completeFunctionType);
            }
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupItem, (double)priority.intValue());
            lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)lookupElement, (int)proximity);
            entry.setValue(Collections.singleton(lookupElement));
        }
    }

    private void addResult(@NotNull String name, LookupElement element) {
        LookupElement firstStoredElement;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addResult"));
        }
        Collection elements = this.myResults.get((Object)name);
        LookupElement lookupElement = firstStoredElement = elements.isEmpty() ? null : (LookupElement)elements.iterator().next();
        if (firstStoredElement == null) {
            this.myResults.putValue((Object)name, (Object)element);
        } else if (element instanceof LookupItem || element instanceof PrioritizedLookupElement) {
            int storedItemProximity;
            double storedItemPriority;
            int itemProximity;
            boolean keepCompleteMatchedOverloads = this.typescript;
            double itemPriority = element instanceof LookupItem ? ((LookupItem)element).getPriority() : ((PrioritizedLookupElement)element).getPriority();
            int n = itemProximity = element instanceof PrioritizedLookupElement ? ((PrioritizedLookupElement)element).getExplicitProximity() : ((Integer)ObjectUtils.chooseNotNull((Object)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY), (Object)0)).intValue();
            if (keepCompleteMatchedOverloads && VariantsProcessor.wasCompleteMatch(itemPriority)) {
                this.myResults.putValue((Object)name, (Object)element);
                return;
            }
            PsiElement lookupItemElement = element.getPsiElement();
            PsiElement storedLookupItemElement = firstStoredElement.getPsiElement();
            if (firstStoredElement instanceof LookupItem) {
                storedItemPriority = ((LookupItem)firstStoredElement).getPriority();
                storedItemProximity = (Integer)ObjectUtils.chooseNotNull((Object)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY), (Object)0);
            } else if (firstStoredElement instanceof PrioritizedLookupElement) {
                storedItemPriority = ((PrioritizedLookupElement)firstStoredElement).getPriority();
                storedItemProximity = ((PrioritizedLookupElement)firstStoredElement).getExplicitProximity();
            } else {
                Integer data = (Integer)firstStoredElement.getUserData(PRIORITY);
                storedItemPriority = data != null ? (double)data.intValue() : 0.0;
                Integer proximity = (Integer)firstStoredElement.getUserData(PROXIMITY);
                int n2 = storedItemProximity = proximity != null ? proximity : 0;
            }
            if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
                boolean storedIsProperty;
                boolean currentIsProperty = lookupItemElement instanceof JSProperty && ((JSProperty)lookupItemElement).tryGetFunctionInitializer() != null;
                boolean bl = storedIsProperty = storedLookupItemElement instanceof JSProperty && ((JSProperty)storedLookupItemElement).tryGetFunctionInitializer() != null;
                if (currentIsProperty && !storedIsProperty) {
                    storedItemPriority -= 1.0;
                } else if (!currentIsProperty && storedIsProperty) {
                    itemPriority -= 1.0;
                }
                boolean currentContextMatches = Boolean.TRUE.equals(element.getUserData(CONTEXT_MATCHES));
                boolean storedContextMatches = Boolean.TRUE.equals(firstStoredElement.getUserData(CONTEXT_MATCHES));
                if (currentContextMatches && !storedContextMatches) {
                    storedItemPriority -= 1.0;
                } else if (!currentContextMatches && storedContextMatches) {
                    itemPriority -= 1.0;
                }
            }
            if (itemPriority == storedItemPriority && itemProximity == storedItemProximity) {
                boolean itemIsBold;
                boolean bl = itemIsBold = element instanceof LookupItem && ((LookupItem)element).isBold();
                if (firstStoredElement instanceof LookupItem) {
                    LookupElementBuilder mergedElement = LookupElementBuilder.create((String)name).withTypeText(JSBundle.message((String)"javascript.completion.several.definitions", (Object[])new Object[0]), true);
                    mergedElement.putUserData(PRIORITY, (Object)((int)itemPriority));
                    mergedElement.putUserData(PROXIMITY, (Object)itemProximity);
                    mergedElement.putUserData(HAS_BOLD_ELEMENT, (Object)(itemIsBold || ((LookupItem)firstStoredElement).isBold() ? 1 : 0));
                    JSFunction firstPossibleFunction = JSPsiImplUtils.getPossibleFunction(lookupItemElement);
                    JSFunction secondPossibleFunction = JSPsiImplUtils.getPossibleFunction(storedLookupItemElement);
                    boolean bothAreFunctions = firstPossibleFunction != null && secondPossibleFunction != null;
                    mergedElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)bothAreFunctions);
                    if (bothAreFunctions) {
                        mergedElement.putUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS, (Object)(firstPossibleFunction.getParameters().length == 0 && secondPossibleFunction.getParameters().length == 0 ? 1 : 0));
                    }
                    this.myResults.remove((Object)name);
                    this.myResults.putValue((Object)name, (Object)mergedElement);
                } else if (storedLookupItemElement == null) {
                    if (firstStoredElement.getUserData(ALL_ELEMENTS_ARE_FUNCTIONS) == Boolean.TRUE) {
                        JSFunction possibleFunction = JSPsiImplUtils.getPossibleFunction(lookupItemElement);
                        if (possibleFunction == null) {
                            firstStoredElement.putUserData(ALL_ELEMENTS_ARE_FUNCTIONS, (Object)Boolean.FALSE);
                        } else if (possibleFunction.getParameters().length > 0) {
                            firstStoredElement.putUserData(ALL_FUNCTIONS_HAS_NO_PARAMETERS, (Object)Boolean.FALSE);
                        }
                    }
                    if (firstStoredElement.getUserData(HAS_BOLD_ELEMENT) != Boolean.TRUE && itemIsBold) {
                        firstStoredElement.putUserData(HAS_BOLD_ELEMENT, (Object)Boolean.TRUE);
                    }
                }
            } else if (itemPriority > storedItemPriority || itemPriority == storedItemPriority && itemProximity > storedItemProximity) {
                this.myResults.remove((Object)name);
                this.myResults.putValue((Object)name, (Object)element);
            }
        } else {
            this.myResults.putValue((Object)name, (Object)element);
        }
    }

    static boolean wasCompleteMatch(double priority) {
        return priority > (double)JSLookupPriority.MAX_PRIORITY.getPriorityValue();
    }

    public List<LookupElement> getResults(String qualifiedNameToSkip) {
        this.addNeighbourReferences(false);
        this.buildSeveralDefinitionsElements();
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(this.myResults.size());
        for (LookupElement element : this.myResults.values()) {
            VariantsProcessor.addVariant(qualifiedNameToSkip, results, element);
        }
        return results;
    }

    private static void addVariant(String qualifiedNameToSkip, List<LookupElement> results, LookupElement o) {
        if (qualifiedNameToSkip == null || !qualifiedNameToSkip.equals(o.getLookupString())) {
            results.add(o);
        }
    }

    @NotNull
    public Collection<? extends LookupElement> getCurrentResults() {
        this.addNeighbourReferences(true);
        this.buildSeveralDefinitionsElements();
        Collection collection = this.myResults.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "getCurrentResults"));
        }
        return collection;
    }

    public Collection<? extends LookupElement> getFinalResults() {
        List<LookupElement> recordTypesElements = this.createElementsFromRecordTypes();
        for (LookupElement recordTypesElement : recordTypesElements) {
            this.addResult(recordTypesElement.getLookupString(), recordTypesElement);
        }
        this.addNeighbourReferences(false);
        this.buildSeveralDefinitionsElements();
        return this.myResults.values();
    }

    @NotNull
    private List<LookupElement> createElementsFromRecordTypes() {
        if (this.myTypeInfo.myRecordTypes == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "createElementsFromRecordTypes"));
            }
            return list;
        }
        SmartList result = new SmartList();
        for (JSRecordType recordType : this.myTypeInfo.myRecordTypes) {
            Collection elements;
            JSElementIndexingData indexingData;
            PsiElement element = recordType.getSource().getSourceElement();
            THashMap implicitElements = new THashMap();
            if (element instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)element).getIndexingData()) != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement implicitElement : elements) {
                    JSQualifiedName parentNamespace;
                    JSQualifiedName namespace = implicitElement.getNamespace();
                    if (namespace == null || (parentNamespace = namespace.getParent()) == null || !"options".equals(parentNamespace.getName())) continue;
                    implicitElements.put(implicitElement.getName(), implicitElement);
                }
            }
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                String name = ((JSRecordType.PropertySignature)member).getName();
                JSType type = ((JSRecordType.PropertySignature)member).getType();
                String typeString = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
                PsiElement sourceElement = (PsiElement)implicitElements.get(name);
                if (sourceElement == null) {
                    sourceElement = element;
                }
                LookupElementBuilder builder = LookupElementBuilder.create((Object)(sourceElement != null ? sourceElement : name), (String)name).withBoldness(true).withTypeText(typeString);
                result.add(JSCompletionUtil.withJSLookupPriority((LookupElement)builder, JSLookupPriority.MAX_PRIORITY));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "createElementsFromRecordTypes"));
        }
        return smartList;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "execute"));
        }
        if (element instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)element;
            this.addCompleteMatch(namedElement, namedElement.getName(), BaseJSSymbolProcessor.MatchType.COMPLETE);
        }
        return true;
    }

    @Override
    public String getRequiredName() {
        return null;
    }

    @Override
    public void doAdd(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "doAdd"));
        }
        this.doAdd(element, null);
    }

    public void doAdd(@NotNull JSPsiElementBase element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        Ref typeHierarchyLevel;
        BaseJSSymbolProcessor.MatchType matchType;
        JSDocComment comment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "doAdd"));
        }
        String name = element.getName();
        JSQualifiedName namespace = element.getNamespace();
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (name == null || !BasicJavascriptNamesValidator.isUnqualifiedType(name)) {
            return;
        }
        if (element.isEquivalentTo(this.myOriginalElement)) {
            return;
        }
        if (this.myPopulatedResultsNames.contains(name)) {
            return;
        }
        if (this.isAcceptable(element) != null) {
            return;
        }
        boolean seemsToBePrivateSymbol = JSVisibilityUtil.seemsToBePrivateSymbol(name);
        boolean isClassMember = element.getParent() instanceof JSClass;
        if (isClassMember && element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
            return;
        }
        if (element instanceof JSProperty && (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element)) != null && comment.hasConstructsTag()) {
            return;
        }
        if (seemsToBePrivateSymbol && accessType == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PRIVATE;
        }
        if (isClassMember && accessType == JSAttributeList.AccessType.PRIVATE) {
            return;
        }
        boolean fromTheSameFile = this.myCurrentFile != null && this.myCurrentFile.equals(this.myTargetVirtualFile);
        boolean elementIsVisible = JSVisibilityUtil.isAccessible(namespace, (PsiElement)element, accessType, this.getContextScopeNames(), this.myContext, fromTheSameFile);
        if (element instanceof JSClass && !elementIsVisible) {
            return;
        }
        if (this.myProcessOnlyProperties && (element instanceof JSImplicitElement ? ((JSImplicitElement)element).getType() != JSImplicitElement.Type.Property : !(element instanceof JSProperty) && !(element instanceof JSDefinitionExpression))) {
            return;
        }
        if (this.myProcessOnlyTypes && this.ecmal4) {
            boolean nonAcceptableItem;
            boolean bl = nonAcceptableItem = !(element instanceof JSClass) && !(element instanceof JSPackage) || "Arguments".equals(element.getName());
            if (nonAcceptableItem && !this.myStrictTypeContext) {
                boolean bl2 = nonAcceptableItem = isClassMember || !(element instanceof JSFunction) && !(element instanceof JSVariable);
            }
            if (nonAcceptableItem) {
                return;
            }
        }
        if (((matchType = this.isAcceptableQualifiedItem(element, (Ref<Integer>)(typeHierarchyLevel = new Ref((Object)0)))) == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) && !this.ecmal4 && this.myProcessOnlyTypes) {
            boolean lowerCasedSymbol;
            boolean bl = lowerCasedSymbol = !name.isEmpty() && Character.isLowerCase(name.charAt(0));
            if (lowerCasedSymbol) {
                if (element instanceof JSImplicitElement && !((JSImplicitElement)element).getType().providesNamespace() || element instanceof JSFunction && !((JSFunction)element).isConstructor() && JSPsiImplUtils.signatureIsExplicitlyDeclared((JSFunctionItem)((JSFunction)element))) {
                    matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
                }
            } else if (accessType == JSAttributeList.AccessType.PRIVATE) {
                matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
            }
        }
        boolean addPartial = true;
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL && this.myPrefixMatcher != null) {
            boolean bl = addPartial = !this.myPrefixMatcher.getPrefix().isEmpty() && this.myPrefixMatcher.prefixMatches(name);
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE && (Integer)typeHierarchyLevel.get() > 0 && !elementIsVisible) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL || !elementIsVisible && (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE)) {
            if (addPartial) {
                this.addPartialMatch((PsiElement)element, name);
            }
        } else if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            this.addCompleteMatch(element, name, matchType, (Integer)typeHierarchyLevel.get(), typeSubstitutor);
        }
    }

    private LookupElement addLookupValue(PsiElement _element, @NotNull String name, BaseJSSymbolProcessor.MatchType matchType, Boolean fromRelevantFileOrDirectory, Boolean hasSomeSmartnessAvailable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addLookupValue"));
        }
        JSLookupPriority priority = JSLookupPriority.getLookupPriority(matchType, fromRelevantFileOrDirectory, hasSomeSmartnessAvailable);
        return this.addLookupValue(_element, name, priority, null);
    }

    private LookupElement addLookupValue(PsiElement _element, String name, boolean fromRelevantFileOrDirectory, boolean hasSomeSmartnessAvailable) {
        return this.addLookupValue(_element, name, null, fromRelevantFileOrDirectory, hasSomeSmartnessAvailable);
    }

    @Nullable
    private LookupElement addLookupValue(PsiElement element, @NotNull String name, @NotNull JSLookupPriority priority, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addLookupValue"));
        }
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "addLookupValue"));
        }
        if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
            return null;
        }
        LookupItem<Object> lookupItem = JSLookupUtilImpl.createPrioritizedLookupItem(element, name, priority, this.myElementFromBestClass, this.ecmal4, typeSubstitutor);
        return lookupItem;
    }

    @Override
    protected JSSymbolNamespace calculateContextNames(JSElement element) {
        JSExpression methodExpr;
        PsiElement grandGrandParent;
        PsiElement grandParent;
        if (element instanceof JSProperty && (grandParent = element.getParent().getParent()) instanceof JSArgumentList && (grandGrandParent = grandParent.getParent()) instanceof JSCallExpression && (methodExpr = ((JSCallExpression)grandGrandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            ArrayList<String> names = new ArrayList<String>(3);
            JSElement qualifyingExpression = JSSymbolUtil.getFirstLiteralOrExprArg((JSArgumentList)grandParent);
            String method = qualifyingExpression != null ? StringUtil.unquoteString((String)qualifyingExpression.getText()) : methodExpr.getText();
            BaseJSSymbolProcessor.addIndexListFromQName(method, names);
            this.weAreInConstructorParameters = true;
            return new JSSymbolNamespaceImpl(JSQualifiedNameImpl.fromComponents(names), JSContext.UNKNOWN, true, true);
        }
        if (element instanceof JSReferenceExpression) {
            return JSResolveUtil.buildNamespaceForQualifier(JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)element));
        }
        return null;
    }

    private void addCompleteMatch(Object _element, String name, BaseJSSymbolProcessor.MatchType matchType) {
        this.addCompleteMatch(_element, name, matchType, 0, null);
    }

    private void addCompleteMatch(Object _element, @Nullable String name, BaseJSSymbolProcessor.MatchType matchType, int nestingLevel, JSTypeSubstitutor typeSubstitutor) {
        LookupItem o;
        if (name == null) {
            return;
        }
        if (_element instanceof LookupItem) {
            o = (LookupItem)_element;
        } else {
            JSLookupPriority priority = this.myGlobalStatusHint == BaseJSSymbolProcessor.GlobalStatusHint.GLOBAL && !this.myProcessOnlyTypes ? JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false) : JSLookupPriority.getSameTypeValue(name.equals(this.myReferencedParameterName), matchType, nestingLevel);
            PsiElement element = this.updateElement(_element);
            o = this.addLookupValue(element, name, priority, typeSubstitutor);
            if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT && o != null) {
                o.putUserData(CONTEXT_MATCHES, (Object)Boolean.TRUE);
            }
        }
        if (o != null) {
            this.addResult(name, (LookupElement)o);
        }
    }

    @NotNull
    private PsiElement updateElement(Object _element) {
        Object element;
        if (_element instanceof PsiElement) {
            element = (PsiElement)_element;
        } else {
            String name = _element instanceof JSQualifiedName ? ((JSQualifiedName)_element).getName() : (String)_element;
            JSQualifiedName namespace = _element instanceof JSQualifiedName ? ((JSQualifiedName)_element).getParent() : null;
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)this.myTargetFile).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance);
            element = new JSImplicitElementImpl(builder);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor", "updateElement"));
        }
        return psiElement;
    }

    private void addPartialMatch(PsiElement _element, String name) {
        boolean fromRelevantFileOrDirectory;
        if (this.myAddOnlyCompleteMatches) {
            return;
        }
        if (name == null) {
            return;
        }
        PsiElement element = this.updateElement(_element);
        LookupElement o = this.addLookupValue(element, name, fromRelevantFileOrDirectory = this.isFromRelevantFileOrDirectory(), this.hasSomeSmartnessAvailable);
        if (o != null) {
            this.addResult(name, o);
        }
    }

    private class CompletionTypeProcessor
    extends BaseJSSymbolProcessor.TypeProcessorBase {
        private PsiElement myUnknownElement;

        private CompletionTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "process"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "process"));
            }
            if (context.ensureProcessed(type.getTypeText(JSType.TypeTextFormat.SERIALIZED))) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, type, context, source)) {
                return;
            }
            JSTypeSource typeSource = type.getSource();
            if (type instanceof JSRecordType) {
                if (typeSource.isExplicitlyDeclared()) {
                    VariantsProcessor.this.setAddOnlyCompleteMatches(true);
                }
                VariantsProcessor.this.myTypeInfo.setTypeWasProcessed();
                return;
            }
            if (type instanceof JSMixinTypeImpl) {
                this.process(((JSMixinTypeImpl)type).getBaseType(), context, source);
                String mixedType = JSTypeUtils.getQualifiedNameMatchingType(((JSMixinTypeImpl)type).getMixedType(), true);
                if (mixedType != null) {
                    VariantsProcessor.this.buildIndexListFromQNameAndCorrectQName(mixedType, false, JSContext.UNKNOWN);
                    VariantsProcessor.this.addSupers(mixedType, JSContext.UNKNOWN);
                }
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, true, true);
            if (namespace == null || namespace.getQualifiedName() == null) {
                return;
            }
            String typeString = VariantsProcessor.this.addNamespace(namespace, true, context.getJSModule());
            if ("Window".equalsIgnoreCase(typeString) && VariantsProcessor.this.myGlobalStatusHint == BaseJSSymbolProcessor.GlobalStatusHint.NONGLOBAL) {
                VariantsProcessor.this.myGlobalStatusHint = BaseJSSymbolProcessor.GlobalStatusHint.UNKNOWN;
            }
            VariantsProcessor.this.addSupers(namespace);
            if (type instanceof JSTypeImpl && ((JSTypeImpl)type).inheritsFunction()) {
                VariantsProcessor.this.addNamespace("Function", false, JSContext.INSTANCE, typeSource.isExplicitlyDeclared());
            }
            if (VariantsProcessor.this.isStrictTypingPossible(source, type)) {
                VariantsProcessor.this.myStrictlyTyped = true;
            }
            if (source instanceof JSReferenceExpression && source.getParent() instanceof JSNewExpression || source instanceof JSAssignmentExpression && this.isAssignmentChainOfNewExpression((JSAssignmentExpression)source)) {
                this.setUnknownElement(source.getParent());
            }
        }

        private boolean isAssignmentChainOfNewExpression(JSAssignmentExpression source) {
            JSExpression rOperand = source.getROperand();
            if (rOperand instanceof JSNewExpression) {
                return true;
            }
            if (rOperand instanceof JSAssignmentExpression) {
                return this.isAssignmentChainOfNewExpression((JSAssignmentExpression)rOperand);
            }
            return false;
        }

        @Override
        public PsiElement getTarget() {
            return null;
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "setUnknownElement"));
            }
            this.myUnknownElement = element;
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "processResolvedElement"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor", "processResolvedElement"));
            }
            super.processResolvedElement(element, evaluateContext);
            if (element instanceof PsiFile && !CommonJSUtil.hasReexportedModules((PsiFile)element)) {
                VariantsProcessor.this.setAddOnlyCompleteMatches(true);
            }
        }

        private boolean getAllTypesResolved() {
            return this.myUnknownElement == null;
        }
    }
}

