/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.ecma6.ES7Decorator;
import com.intellij.lang.javascript.psi.stubs.ES7DecoratorStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.typescript.psi.impl.ES7DecoratorImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES7DecoratorStubImpl
extends JSNamedObjectStubBase<ES7Decorator>
implements ES7DecoratorStub {
    @Nullable
    private final JSElementIndexingData myIndexingData;
    private static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = JSPossiblyStoredStubImpl.HAS_INDEXING_DATA_FLAG;
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSNamedObjectStubBase.FLAGS_STRUCTURE, HAS_INDEXING_DATA_FLAG);

    public ES7DecoratorStubImpl(ES7Decorator clazz, StubElement parent) {
        super(clazz, parent, JSStubElementTypes.ES7_DECORATOR);
        JSElementIndexingData indexingData = clazz.getIndexingData();
        this.myIndexingData = indexingData != null && !indexingData.isEmpty() ? indexingData : null;
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingData != null);
    }

    public ES7DecoratorStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.ES7_DECORATOR);
        this.myIndexingData = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataImpl.deserialize(dataStream, this) : null;
    }

    public ES7Decorator createPsi() {
        return new ES7DecoratorImpl(this);
    }

    @Nullable
    public JSElementIndexingData getIndexingData() {
        return this.myIndexingData;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataImpl.serialize(this.myIndexingData, dataStream);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/ES7DecoratorStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        JSElementIndexingDataImpl.index(this.myIndexingData, this, sink);
    }
}

