/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumSetStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.NullableEnumStructureElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class JSAttributeListStubImpl
extends JSStubBase<JSAttributeList>
implements JSAttributeListStub {
    private static final NullableEnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new NullableEnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    private static final EnumSetStructureElement<JSAttributeList.ModifierType> MODIFIER_TYPES_FLAG = new EnumSetStructureElement<JSAttributeList.ModifierType>(JSAttributeList.ModifierType.class);
    private static final BooleanStructureElement HAS_CONDITIONAL_PROPERTY_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(ACCESS_TYPE_FLAG, MODIFIER_TYPES_FLAG, HAS_CONDITIONAL_PROPERTY_FLAG);
    private final StringRef myNamespace;
    private final StringRef myResolvedNamespace;

    public JSAttributeListStubImpl(JSAttributeList clazz, StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSAttributeListStubImpl", "<init>"));
        }
        super(clazz, parent, elementType);
        SmartList modifiers = new SmartList();
        for (JSAttributeList.ModifierType type : JSAttributeList.ModifierType.values()) {
            if (!clazz.hasModifier(type)) continue;
            modifiers.add(type);
        }
        EnumSet<Object> modifierTypes = modifiers.isEmpty() ? EnumSet.noneOf(JSAttributeList.ModifierType.class) : EnumSet.copyOf(modifiers);
        this.writeFlag(MODIFIER_TYPES_FLAG, modifierTypes);
        this.writeFlag(ACCESS_TYPE_FLAG, clazz.getExplicitAccessType());
        this.writeFlag(HAS_CONDITIONAL_PROPERTY_FLAG, clazz.getConditionalCompileVariableReference() != null);
        this.myNamespace = StringRef.fromString((String)clazz.getNamespace());
        this.myResolvedNamespace = StringRef.fromString((String)"-\"-");
    }

    public JSAttributeListStubImpl(StubInputStream dataStream, StubElement parentStub, @NotNull IStubElementType elementType) throws IOException {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSAttributeListStubImpl", "<init>"));
        }
        super(dataStream, parentStub, elementType);
        this.myNamespace = dataStream.readName();
        this.myResolvedNamespace = dataStream.readName();
    }

    public JSAttributeListStubImpl(StubElement parentStub, String namespace, String resolvedNamespace, JSAttributeList.AccessType accessType, JSAttributeList.ModifierType ... modifiers) {
        super(parentStub, (IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
        this.writeFlag(ACCESS_TYPE_FLAG, accessType);
        EnumSet<JSAttributeList.ModifierType> modifierTypes = modifiers.length > 0 ? EnumSet.copyOf(Arrays.asList(modifiers)) : EnumSet.noneOf(JSAttributeList.ModifierType.class);
        this.writeFlag(MODIFIER_TYPES_FLAG, modifierTypes);
        this.myNamespace = StringRef.fromString((String)namespace);
        this.myResolvedNamespace = StringRef.fromString((String)resolvedNamespace);
    }

    public JSAttributeList createPsi() {
        return new JSAttributeListImpl(this);
    }

    public void index(IndexSink sink) {
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        JSAttributeListStubImpl.writeString(this.myNamespace, dataStream);
        JSAttributeListStubImpl.writeString(this.myResolvedNamespace, dataStream);
    }

    public JSAttributeList.AccessType getExplicitAccessType() {
        return this.readFlag(ACCESS_TYPE_FLAG);
    }

    public boolean hasModifier(JSAttributeList.ModifierType modifier) {
        EnumSet modifierTypes = (EnumSet)this.readFlag(MODIFIER_TYPES_FLAG);
        return modifierTypes.contains(modifier);
    }

    public String getNamespace() {
        return StringRef.toString((StringRef)this.myNamespace);
    }

    public String getResolvedNamespace() {
        return StringRef.toString((StringRef)this.myResolvedNamespace);
    }

    public boolean hasConditionalCompilerVariable() {
        return this.readFlag(HAS_CONDITIONAL_PROPERTY_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSAttributeListStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

