/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericParameterImpl
extends JSSimpleTypeBaseImpl {
    @NotNull
    private final String myName;
    @Nullable
    private final JSType myConstraintType;
    private final boolean isCallEnvironment;

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "<init>"));
        }
        this(name, source, null);
    }

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source, @Nullable JSType constraintType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "<init>"));
        }
        this(name, source, constraintType, false);
    }

    public JSGenericParameterImpl(@NotNull String name, JSTypeSource source, @Nullable JSType constraintType, boolean env) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "<init>"));
        }
        super(source);
        this.myName = name;
        this.myConstraintType = constraintType;
        this.isCallEnvironment = env;
    }

    @Nullable
    public JSType getConstraintType() {
        return this.myConstraintType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericParameter((JSType)this);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = format == JSType.TypeTextFormat.SERIALIZED ? '%' + this.myName + '%' : this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (this.myConstraintType == null) {
            return true;
        }
        if (this.myConstraintType != null && this.isCallEnvironment) {
            return this.myConstraintType.isDirectlyAssignableType(elementType, processingContext);
        }
        if (JSTypeCastUtil.isAlwaysAssignableType(elementType)) {
            return true;
        }
        return this.isCallEnvironment || this.isEquivalentTo(elementType, processingContext);
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        if (type instanceof JSGenericParameterImpl) {
            if (!this.myName.equals(((JSGenericParameterImpl)type).myName)) {
                return false;
            }
            JSType secondConstraintType = ((JSGenericParameterImpl)type).myConstraintType;
            if (this.myConstraintType == secondConstraintType) {
                return true;
            }
            if (this.myConstraintType == null || secondConstraintType == null) {
                return false;
            }
            return this.myConstraintType.isEquivalentTo(secondConstraintType, processingContext);
        }
        return false;
    }

    public static JSGenericParameterImpl cloneWithEnvironment(JSGenericParameterImpl type, boolean isMethodCall) {
        return new JSGenericParameterImpl(type.myName, type.getSource(), type.myConstraintType, isMethodCall);
    }

    @NotNull
    public JSGenericParameterImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "copyWithNewSource"));
        }
        JSGenericParameterImpl jSGenericParameterImpl = new JSGenericParameterImpl(this.getTypeText(), source, this.getConstraintType());
        if (jSGenericParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSGenericParameterImpl", "copyWithNewSource"));
        }
        return jSGenericParameterImpl;
    }
}

