/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeImpl
extends JSNamedType {
    @NotNull
    private final String myType;
    private String myResolvedType;
    private JSType myTypedef;
    private boolean myIsResolved;
    private final boolean myInheritsFunction;
    private boolean myIsEnum;
    private boolean myIsLocal;
    private boolean myIsAbstract;
    private static final Key<String> ourQualifiedTypeNameKey = Key.create((String)"qualified.type.name");
    static Key<Map<String, JSType>> ourTypedefsExpandedKey = Key.create((String)"typedefs.expanded");

    JSTypeImpl(@NotNull String type, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean inheritsFunction) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "<init>"));
        }
        if (staticOrInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticOrInstance", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "<init>"));
        }
        super(source, staticOrInstance);
        this.myType = type;
        this.myInheritsFunction = inheritsFunction;
    }

    public void resolveType() {
        if (this.myIsResolved) {
            return;
        }
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            return;
        }
        JSTypeResolveResult result = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveTypeName(this.myType, sourceElement);
        this.myResolvedType = result.getQualifiedName();
        this.setTypeScriptAdditionalParams(result);
        this.myIsResolved = true;
    }

    private void setTypeScriptAdditionalParams(JSTypeResolveResult result) {
        for (PsiElement psiElement : result.getElements()) {
            if (psiElement instanceof TypeScriptTypeAlias) {
                this.myTypedef = ((TypeScriptTypeAlias)psiElement).getParsedTypeDeclaration();
                break;
            }
            if (psiElement instanceof JSClass) {
                if (!((JSClass)psiElement).isNamespaceExplicitlyDeclared()) {
                    this.myIsLocal = true;
                }
                if (psiElement instanceof TypeScriptClass) {
                    this.myIsAbstract = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)((TypeScriptClass)psiElement));
                }
            }
            if (!(psiElement instanceof TypeScriptEnum)) continue;
            this.myIsEnum = true;
        }
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        PsiElement clazz;
        if (!this.isEcma()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String qualifiedType = this.myType;
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        PsiElement resolvedElement = null;
        if (element != null) {
            JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.getScope()).getImportHandler();
            JSTypeResolveResult result = importHandler.resolveTypeName(this.myType, element);
            qualifiedType = result.getQualifiedName();
            Iterator<? extends PsiElement> iterator = result.getElements().iterator();
            if (iterator.hasNext()) {
                resolvedElement = iterator.next();
            }
        }
        PsiElement psiElement = clazz = resolvedElement != null ? resolvedElement : JSResolveUtil.findType(qualifiedType, (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    public boolean isEnum() {
        if (this.isTypeScript()) {
            this.resolveType();
        }
        return this.myIsEnum;
    }

    @Override
    @NotNull
    public String getResolvedTypeText() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            String string = this.myType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "getResolvedTypeText"));
            }
            return string;
        }
        if (!this.myIsResolved) {
            this.resolveType();
        }
        String string = this.myResolvedType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "getResolvedTypeText"));
        }
        return string;
    }

    private static boolean isSourceElementNotValid(PsiElement sourceElement) {
        return sourceElement == null || !sourceElement.isValid();
    }

    @Nullable
    public static JSType fromElement(PsiElement element, PsiElement context) {
        JSType type = null;
        if (element instanceof JSVariable) {
            type = ((JSVariable)element).getType();
        } else if (element instanceof JSFunction) {
            type = JSFunctionImpl.getReturnTypeInContext((JSFunction)element, JSTypeUtils.getScopeInOriginalTree(context));
        }
        return type;
    }

    @Override
    @NotNull
    public String getTypeText() {
        String string = this.myType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "getTypeText"));
        }
        return string;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED || format == JSType.TypeTextFormat.CODE) {
            String string = this.getResolvedTypeText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "getTypeText"));
            }
            return string;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String toProcess = this.myType;
            if (StringUtil.contains((CharSequence)toProcess, (CharSequence)"\"")) {
                toProcess = toProcess.replace("\"", JSNamedType.QUOTE_ESCAPE);
            }
            if (this.isStaticOrInstance() == JSContext.STATIC) {
                toProcess = toProcess + "^s";
            }
            if (this.inheritsFunction()) {
                toProcess = toProcess + "^f";
            }
            String string = toProcess;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = this.getTypeText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "getTypeText"));
        }
        return string;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (this == elementType) {
            return true;
        }
        String qName = this.addToContextQualifierName(processingContext);
        if (this.isExplicitlyDeclared() && !this.isEcma()) {
            JSType typedefValue;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if ((typedefValue = this.getTypedef(qName, processingContext)) != null && elementType != null) {
                String elementTypeText = elementType.getResolvedTypeText();
                if (!JSTypeCastUtil.startRecursiveTypesComparison(qName, elementTypeText, processingContext)) {
                    return true;
                }
                boolean typedefAssignable = typedefValue.isDirectlyAssignableType(elementType, processingContext);
                JSTypeCastUtil.endRecursiveTypesComparison(qName, elementTypeText, processingContext);
                return typedefAssignable;
            }
        }
        if ((assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext)).isStrict()) {
            return assignableResult.isAssignable();
        }
        assert (elementType != null);
        if (this.getTypeContext() == JSTypeContext.STATIC && elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).getTypeContext() == JSTypeContext.STATIC && !this.isAbstract() && ((JSTypeImpl)elementType).isAbstract()) {
            return false;
        }
        return this.getTypeHelper().isAssignableToNamedType(this, elementType, processingContext);
    }

    @NotNull
    private String addToContextQualifierName(@Nullable ProcessingContext processingContext) {
        String qName;
        Map cachesMap;
        Map map = cachesMap = processingContext != null ? (Map)processingContext.get((Object)this) : null;
        if (cachesMap == null && processingContext != null) {
            cachesMap = new THashMap();
            processingContext.put((Object)this, (Object)cachesMap);
        }
        if ((qName = (String)ourQualifiedTypeNameKey.get(cachesMap)) == null) {
            this.resolveType();
            qName = this.getResolvedTypeText();
            ourQualifiedTypeNameKey.set(cachesMap, (Object)qName);
        }
        String string = qName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "addToContextQualifierName"));
        }
        return string;
    }

    public boolean isEquivalentTo(JSType type, ProcessingContext processingContext) {
        if (JSTypeCastUtil.isEquivalentCommon(this, type, processingContext)) {
            return true;
        }
        if (!(type instanceof JSTypeImpl)) {
            return false;
        }
        JSTypeImpl jsType = (JSTypeImpl)type;
        boolean areEquals = this.getResolvedTypeText().equals(type.getResolvedTypeText());
        if (!areEquals) {
            return false;
        }
        if (!this.myIsLocal && !jsType.myIsLocal) {
            return true;
        }
        return this.getSource().getSourceElement() == jsType.getSource().getSourceElement();
    }

    @Nullable
    public JSType getTypedef(@Nullable String qName, @Nullable ProcessingContext processingContext) {
        JSType typedefValue;
        boolean contextContainedTypedefsMap;
        if (qName == null) {
            qName = this.getResolvedTypeText();
        }
        Map evaluatedTypedefs = processingContext == null ? null : (Map)processingContext.get(ourTypedefsExpandedKey);
        boolean bl = contextContainedTypedefsMap = evaluatedTypedefs != null;
        if (processingContext != null && evaluatedTypedefs == null) {
            evaluatedTypedefs = new THashMap();
        }
        if (processingContext != null && evaluatedTypedefs.containsKey(qName)) {
            typedefValue = (JSType)evaluatedTypedefs.get(qName);
        } else {
            this.resolveType();
            if (this.myTypedef == null) {
                this.myTypedef = JSTypeEvaluateManager.expandTypedefs((PsiElement)this.getScope(), qName);
            }
            typedefValue = this.myTypedef;
        }
        if (processingContext != null) {
            evaluatedTypedefs.put(qName, typedefValue);
        }
        if (processingContext != null && !contextContainedTypedefsMap) {
            processingContext.put(ourTypedefsExpandedKey, (Object)evaluatedTypedefs);
        }
        return typedefValue;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeImpl((JSType)this);
    }

    public boolean inheritsFunction() {
        return this.myInheritsFunction;
    }

    @Override
    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "copyWithNewSource"));
        }
        JSTypeImpl jSTypeImpl = this.copyWithNewSource(source, false);
        if (jSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "copyWithNewSource"));
        }
        return jSTypeImpl;
    }

    public JSTypeImpl copyWithNewSource(JSTypeSource newSource, boolean resolve) {
        if (this.myIsResolved || resolve) {
            this.resolveType();
            JSTypeImpl type = new JSTypeImpl(this.getTypeText(), newSource, this.getTypeContext(), this.myInheritsFunction);
            type.myIsResolved = true;
            type.myResolvedType = this.myResolvedType;
            type.myIsEnum = this.myIsEnum;
            type.myTypedef = this.myTypedef;
            type.myIsLocal = this.myIsLocal;
            type.myIsAbstract = this.myIsAbstract;
            return type;
        }
        return new JSTypeImpl(this.getTypeText(), newSource, this.getTypeContext(), this.myInheritsFunction);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.resolveQualifiedType(this);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "substitute"));
        }
        return jSType;
    }

    public static JSType resolveQualifiedType(JSTypeBaseImpl type) {
        JSType declaration;
        if (!type.getSource().isTypeScript()) {
            return type;
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (item != null && item instanceof TypeScriptTypeAlias && elements.size() == 1 && (declaration = ((TypeScriptTypeAlias)item).getParsedTypeDeclaration()) != null) {
            if (type instanceof JSGenericTypeImpl) {
                Map<String, JSType> generics = JSTypeCastUtil.collectGenericsFroApplying((JSGenericTypeImpl)type, (TypeScriptTypeParameterListOwner)((TypeScriptTypeAlias)item));
                declaration = JSTypeUtils.applyGenericArguments(declaration, generics);
            }
            return declaration;
        }
        return TypeScriptTypeParser.buildResolvedType(elements, type);
    }

    public boolean isLocal() {
        if (this.isTypeScript()) {
            this.resolveType();
        }
        return this.myIsLocal;
    }

    public boolean isAbstract() {
        if (this.isTypeScript()) {
            this.resolveType();
        }
        return this.myIsAbstract;
    }

    @Override
    @NotNull
    public JSRecordType asRecordType() {
        JSRecordType jSRecordType = this.asRecordTypeNoCache();
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeImpl", "asRecordType"));
        }
        return jSRecordType;
    }
}

