/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPrimitiveFunctionType
extends JSSpecialNamedTypeImpl {
    public JSPrimitiveFunctionType(JSTypeSource source, JSTypeContext staticOrInstance) {
        super(source, staticOrInstance);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if ("Function" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveFunctionType", "getTypeText"));
        }
        return "Function";
    }

    @Override
    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSTypeImpl) {
            JSType resolvedElementType;
            if (((JSTypeImpl)elementType).inheritsFunction()) {
                return true;
            }
            if (this.isTypeScript() && (resolvedElementType = elementType.substitute()) != elementType) {
                return this.isDirectlyAssignableType(resolvedElementType, processingContext);
            }
        }
        if (elementType instanceof JSRecordType) {
            for (JSRecordType.TypeMember member : ((JSRecordType)elementType).getTypeMembers()) {
                if (!(member instanceof JSRecordType.CallSignature)) continue;
                return true;
            }
            return false;
        }
        return elementType instanceof JSNullType || elementType instanceof JSFunctionTypeImpl || super.isDirectlyAssignableType(elementType, processingContext);
    }
}

