/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.ChangeSignatureUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureProcessor
extends BaseRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)JSChangeSignatureProcessor.class.getName());
    protected final JSFunction myMethod;
    private final JSAttributeList.AccessType myVisibility;
    private final String myMethodName;
    private final String myReturnType;
    protected final JSParameterInfo[] myParameters;
    private final Set<JSFunction> myMethodsToPropagateParameters;
    private final boolean myChangeVisibility;
    private final PsiFile myMethodContainingFile;
    private Condition<JSFunction> myDeclarationsFilter = Conditions.alwaysTrue();
    private final int myMethodParamsNumber;

    public JSChangeSignatureProcessor(JSFunction method, JSAttributeList.AccessType visibility, String methodName, String returnType, JSParameterInfo[] parameters, Set<JSFunction> methodsToPropagateParameters) {
        super(method.getProject());
        this.myMethod = method;
        this.myMethodContainingFile = method.getContainingFile();
        this.myMethodParamsNumber = JSChangeSignatureProcessor.getNumberOfParams(method);
        this.myVisibility = visibility;
        this.myMethodName = methodName;
        this.myReturnType = returnType;
        this.myParameters = parameters;
        this.myMethodsToPropagateParameters = methodsToPropagateParameters;
        JSAttributeList attributeList = method.getAttributeList();
        this.myChangeVisibility = attributeList != null && this.myVisibility != attributeList.getAccessType();
    }

    public void setDeclarationsFilter(Condition<JSFunction> declarationsFilter) {
        this.myDeclarationsFilter = declarationsFilter;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor", "createUsageViewDescriptor"));
        }
        ChangeSignatureUsageViewDescriptor changeSignatureUsageViewDescriptor = new ChangeSignatureUsageViewDescriptor(usages);
        if (changeSignatureUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor", "createUsageViewDescriptor"));
        }
        return changeSignatureUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        class MyProcessor
        implements Processor<PsiReference> {
            JSElement myRebindTo;

            MyProcessor(JSElement rebindTo) {
                this.myRebindTo = rebindTo;
            }

            public boolean process(PsiReference psiReference) {
                PsiElement element = psiReference.getElement();
                if (!(element instanceof JSReferenceExpression)) {
                    return true;
                }
                if (JSChangeSignatureProcessor.this.myMethod instanceof JSFunctionExpression) {
                    JSExpression rOperand;
                    if (element.getParent() instanceof JSVariable && JSResolveUtil.isSelfReference(element)) {
                        declarations.add(new FunctionExpressionDeclarationUsageInfo(element.getParent(), null));
                        return true;
                    }
                    if (element.getParent() instanceof JSDefinitionExpression && element.getParent().getParent() instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)element.getParent().getParent()).getROperand()) == JSChangeSignatureProcessor.this.myMethod) {
                        return true;
                    }
                } else if (element.getParent() instanceof JSVariable && JSResolveUtil.isSelfReference(element)) {
                    return true;
                }
                usages.add(new OtherUsageInfo(element, this.myRebindTo, JSChangeSignatureProcessor.this.myParameters, element.getParent() instanceof JSSuperExpression || JSChangeSignatureProcessor.this.shouldPropagate(element), (Integer)minMaxParameters.first, (Integer)minMaxParameters.second));
                return true;
            }
        }
        Object parent;
        JSVariable field;
        Trinity<Integer, Integer, Boolean> minMaxParameters;
        Collection<OtherUsageInfo> usages;
        Collection<UsageInfo> declarations;
        block19: {
            JSFunction[] couple;
            JSFunction[] jSFunctionArray;
            Object clazz;
            block17: {
                block20: {
                    block18: {
                        declarations = Collections.synchronizedCollection(new HashSet());
                        usages = Collections.synchronizedCollection(new HashSet());
                        minMaxParameters = ValidateTypesUtil.getMinMaxParameters((JSParameterItem[])this.myMethod.getParameters());
                        field = null;
                        if (!(this.myMethod instanceof JSFunctionExpression)) break block17;
                        parent = this.myMethod.getParent();
                        if (!(parent instanceof JSVariable)) break block18;
                        ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope()).forEach((Processor)new MyProcessor((JSElement)((JSVariable)parent)));
                        break block19;
                    }
                    if (!(parent instanceof JSAssignmentExpression)) break block20;
                    JSDefinitionExpression definitionExpression = (JSDefinitionExpression)((JSAssignmentExpression)parent).getLOperand();
                    ReferencesSearch.search((PsiElement)definitionExpression, (SearchScope)definitionExpression.getUseScope()).forEach((Processor)new MyProcessor((JSElement)definitionExpression));
                    break block19;
                }
                if (!(parent instanceof JSProperty)) break block19;
                ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope()).forEach((Processor)new MyProcessor((JSElement)((JSProperty)parent)));
                break block19;
            }
            JSFunction complementary = null;
            if (this.myMethod.isGetProperty()) {
                clazz = JSUtils.getMemberContainingClass((PsiElement)this.myMethod);
                complementary = clazz.findFunctionByNameAndKind(this.myMethod.getName(), JSFunction.FunctionKind.SETTER);
                field = clazz.findFieldByName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethod.getName(), this.myProject));
            } else if (this.myMethod.isSetProperty()) {
                clazz = JSUtils.getMemberContainingClass((PsiElement)this.myMethod);
                complementary = clazz.findFunctionByNameAndKind(this.myMethod.getName(), JSFunction.FunctionKind.GETTER);
                field = clazz.findFieldByName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethod.getName(), this.myProject));
            } else if (this.myMethod.isConstructor()) {
                for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls(this.myMethod)) {
                    usages.add(new OtherUsageInfo((PsiElement)superCall.getMethodExpression(), (JSElement)this.myMethod, this.myParameters, this.shouldPropagate((PsiElement)superCall), (Integer)minMaxParameters.first, (Integer)minMaxParameters.second));
                }
            }
            if (complementary != null) {
                JSFunction[] jSFunctionArray2 = new JSFunction[2];
                jSFunctionArray2[0] = this.myMethod;
                jSFunctionArray = jSFunctionArray2;
                jSFunctionArray2[1] = complementary;
            } else {
                JSFunction[] jSFunctionArray3 = new JSFunction[1];
                jSFunctionArray = jSFunctionArray3;
                jSFunctionArray3[0] = this.myMethod;
            }
            for (JSFunction method : couple = jSFunctionArray) {
                THashSet inheritors = new THashSet();
                JSInheritanceUtil.iterateMethodsDown(method, new Processor<JSFunction>((Collection)inheritors){
                    final /* synthetic */ Collection val$inheritors;
                    {
                        this.val$inheritors = collection2;
                    }

                    public synchronized boolean process(JSFunction jsFunction) {
                        if (JSChangeSignatureProcessor.this.myDeclarationsFilter.value((Object)jsFunction)) {
                            declarations.add(new MethodDeclarationUsageInfo(jsFunction, null));
                            this.val$inheritors.add(jsFunction);
                        }
                        return true;
                    }
                });
                for (JSFunction inheritor : inheritors) {
                    ReferencesSearch.search((PsiElement)inheritor, (SearchScope)inheritor.getUseScope()).forEach((Processor)new MyProcessor((JSElement)inheritor));
                }
                ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope()).forEach((Processor)new MyProcessor((JSElement)method));
                declarations.add(new MethodDeclarationUsageInfo(method, null));
            }
        }
        if (this.myMethod instanceof JSFunctionExpression) {
            parent = this.myMethod.getParent();
            if (parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSProperty) {
                declarations.add(new FunctionExpressionDeclarationUsageInfo((PsiElement)parent, null));
            } else {
                declarations.add(new MethodDeclarationUsageInfo(this.myMethod, null));
            }
        } else {
            declarations.add(new MethodDeclarationUsageInfo(this.myMethod, null));
        }
        this.findPropagationUsages(declarations, usages);
        if (field != null) {
            declarations.add(new FieldDeclarationUsageInfo(field));
            ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).forEach((Processor)new MyProcessor((JSElement)field));
        }
        for (UsageInfo usageInfo : declarations) {
            if (!(usageInfo instanceof FunctionDeclarationUsageInfoBase)) continue;
            ((FunctionDeclarationUsageInfoBase)usageInfo).searchForParametersUsages();
        }
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(declarations);
        result.addAll(usages);
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected void findPropagationUsages(Collection<UsageInfo> declarations, Collection<OtherUsageInfo> usages) {
        if (!this.myMethodsToPropagateParameters.isEmpty()) {
            ArrayList<JSParameterInfo> addedParams = new ArrayList<JSParameterInfo>();
            for (JSParameterInfo parameter : this.myParameters) {
                if (parameter.getOldIndex() != -1 || !StringUtil.isNotEmpty((String)parameter.getDefaultValue())) continue;
                addedParams.add(parameter);
            }
            for (JSFunction toPropagate : this.myMethodsToPropagateParameters) {
                List<JSParameterInfo> p = JSMethodDescriptor.getParameters(toPropagate);
                p.addAll(addedParams);
                JSParameterInfo[] newDeclarationParams = p.toArray(new JSParameterInfo[p.size()]);
                Trinity<Integer, Integer, Boolean> propagateMinMaxParameters = ValidateTypesUtil.getMinMaxParameters((JSParameterItem[])toPropagate.getParameters());
                Processor consumer = psiReference -> {
                    PsiElement element = psiReference.getElement();
                    if (!(element instanceof JSReferenceExpression)) {
                        return true;
                    }
                    if (!(element.getParent() instanceof JSCallExpression)) {
                        return true;
                    }
                    usages.add(new OtherUsageInfo(element, null, newDeclarationParams, this.shouldPropagate(element), (Integer)propagateMinMaxParameters.first, (Integer)propagateMinMaxParameters.second));
                    return true;
                };
                if (toPropagate instanceof JSFunctionExpression) {
                    declarations.add(new FunctionExpressionDeclarationUsageInfo(toPropagate.getParent(), newDeclarationParams));
                    ReferencesSearch.search((PsiElement)toPropagate.getParent(), (SearchScope)toPropagate.getParent().getUseScope()).forEach(consumer);
                    continue;
                }
                for (JSFunction top : JSInheritanceUtil.findTopMethods(toPropagate)) {
                    ReferencesSearch.search((PsiElement)top, (SearchScope)top.getUseScope()).forEach(consumer);
                    if (JSChangeSignatureProcessor.getNumberOfParams(top) != JSChangeSignatureProcessor.getNumberOfParams(toPropagate) || !this.myDeclarationsFilter.value((Object)top)) continue;
                    declarations.add(new MethodDeclarationUsageInfo(top, newDeclarationParams));
                }
                if (!toPropagate.isConstructor()) continue;
                for (JSCallExpression callExpression : JSInheritanceUtil.findSuperConstructorCalls(toPropagate)) {
                    usages.add(new OtherUsageInfo((PsiElement)callExpression.getMethodExpression(), null, newDeclarationParams, this.shouldPropagate((PsiElement)callExpression), (Integer)propagateMinMaxParameters.first, (Integer)propagateMinMaxParameters.second));
                }
            }
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor", "performRefactoring"));
        }
        HashSet filesToOptimizeImports = new HashSet();
        ArrayList<UsageInfo> secondStepUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usageInfos) {
            if (usage instanceof FunctionDeclarationUsageInfoBase || usage instanceof FieldDeclarationUsageInfo) {
                this.refactorDeclarationOrUsage(usage, (Collection<PsiFile>)filesToOptimizeImports);
                continue;
            }
            secondStepUsages.add(usage);
        }
        for (UsageInfo usage : secondStepUsages) {
            this.refactorDeclarationOrUsage(usage, (Collection<PsiFile>)filesToOptimizeImports);
        }
        ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
        for (PsiFile affectedFile : filesToOptimizeImports) {
            formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(affectedFile));
        }
        JSRefactoringUtil.format(formatters);
    }

    private void refactorDeclarationOrUsage(UsageInfo usage, Collection<PsiFile> filesToOptimizeImports) {
        if (usage instanceof FunctionDeclarationUsageInfoBase) {
            JSFunction function = ((FunctionDeclarationUsageInfoBase)usage).getFunction();
            JSParameterInfo[] paramsOverride = ((FunctionDeclarationUsageInfoBase)usage).getParamsOverride();
            MultiMap<JSParameter, UsageInfo> paramsUsages = ((FunctionDeclarationUsageInfoBase)usage).getParamsUsages();
            if (paramsOverride != null) {
                JSChangeSignatureUtil.setParameters(function, paramsUsages, filesToOptimizeImports, this.getLangForProcessing(), paramsOverride);
                filesToOptimizeImports.add(function.getContainingFile());
            } else if (function.getKind() != this.myMethod.getKind() || this.myMethodParamsNumber == JSChangeSignatureProcessor.getNumberOfParams(function)) {
                this.refactorMethodDeclaration(function, filesToOptimizeImports, paramsUsages);
            }
        } else if (usage instanceof FieldDeclarationUsageInfo) {
            this.refactorFieldDeclaration(((FieldDeclarationUsageInfo)usage).getElement(), filesToOptimizeImports);
        } else {
            OtherUsageInfo u = (OtherUsageInfo)usage;
            PsiElement refExpr = u.getElement();
            JSElement referencedElement = u.getRebindTo();
            if (referencedElement != null && refExpr instanceof JSReferenceExpression) {
                refExpr = ((JSReferenceExpression)refExpr).bindToElement((PsiElement)referencedElement);
            }
            if (refExpr.getParent() instanceof JSCallExpression) {
                JSE4XNamespaceReference namespaceRef;
                JSExpression methodExpression = ((JSCallExpression)refExpr.getParent()).getMethodExpression();
                boolean superCall = methodExpression instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSSuperExpression;
                this.refactorCall((JSCallExpression)refExpr.getParent(), u.getParameters(), u.isPropagate() || superCall, u.myMinParams, u.myMaxParams, filesToOptimizeImports);
                if (this.myChangeVisibility && (namespaceRef = (JSE4XNamespaceReference)PsiTreeUtil.findChildOfType((PsiElement)((JSCallExpression)refExpr.getParent()).getMethodExpression(), JSE4XNamespaceReference.class)) != null) {
                    namespaceRef.delete();
                }
            }
        }
    }

    private void refactorCall(JSCallExpression callExpression, JSParameterInfo[] parameters, boolean propagate, int minParams, int maxParams, Collection<PsiFile> filesToOptimizeImports) {
        JSArgumentList list;
        JSExpression[] oldArguments = callExpression.getArguments();
        if (oldArguments.length < minParams || oldArguments.length > maxParams) {
            return;
        }
        JSArgumentList newArgList = (JSArgumentList)JSChangeUtil.createExpressionFromText(this.myProject, "dummy()", this.getLangForProcessing()).findChildByType(JSElementTypes.ARGUMENT_LIST).getPsi();
        HashSet importStatements = new HashSet();
        for (int i = 0; i < parameters.length; ++i) {
            JSParameterInfo p = parameters[i];
            if (p.getOldIndex() == -1) {
                String value;
                if (StringUtil.isEmpty((String)p.getDefaultValue())) {
                    for (int j = i; j < parameters.length; ++j) {
                        JSParameterInfo p2 = parameters[j];
                        LOG.assertTrue((StringUtil.isNotEmpty((String)p2.getInitializer()) || JSRefactoringUtil.isEllipsisType(p2.getTypeText())) && StringUtil.isEmpty((String)p2.getDefaultValue()));
                    }
                    break;
                }
                if (propagate) {
                    value = p.getName();
                } else {
                    String defaultValue = p.getDefaultValue();
                    if (StringUtil.isEmpty((String)defaultValue)) {
                        defaultValue = JSTypeUtils.defaultValueOfType(p.getTypeText());
                    } else {
                        JSChangeSignatureProcessor.computeRequiredImportStatements(defaultValue, (PsiElement)callExpression, (Collection<String>)importStatements);
                    }
                    value = JSChangeSignatureProcessor.getEscaped(defaultValue, (PsiElement)callExpression);
                }
                JSVarStatement varStatement = (JSVarStatement)JSChangeUtil.createJSTreeFromText(this.myProject, "var v = " + value, this.getLangForProcessing()).getPsi();
                JSVariable var = varStatement.getVariables()[0];
                JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
                newArgList.addBefore((PsiElement)var.getInitializer(), newArgList.getLastChild());
                continue;
            }
            if (JSRefactoringUtil.isEllipsisType(p.getTypeText())) {
                for (int j = p.getOldIndex(); j < oldArguments.length; ++j) {
                    JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
                    newArgList.addBefore((PsiElement)oldArguments[j], newArgList.getLastChild());
                }
                break;
            }
            if (oldArguments.length <= p.getOldIndex()) continue;
            JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
            newArgList.addBefore((PsiElement)oldArguments[p.getOldIndex()], newArgList.getLastChild());
        }
        newArgList = (JSArgumentList)((list = callExpression.getArgumentList()) != null ? list.replace((PsiElement)newArgList) : callExpression.addAfter((PsiElement)newArgList, (PsiElement)callExpression.getMethodExpression()));
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newArgList);
        if (!importStatements.isEmpty()) {
            FormatFixer formatFixer = ImportUtils.insertImportStatements((PsiElement)callExpression, (Collection<String>)importStatements);
            if (formatFixer != null) {
                formatFixer.fixFormat();
            }
            filesToOptimizeImports.add(callExpression.getContainingFile());
        }
    }

    public static void computeRequiredImportStatements(String text, final PsiElement context, final Collection<String> result) {
        PsiElement element = JSChangeUtil.createJSTreeFromText(context.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
        element.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)context);
        element.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                String qName;
                ResolveResult[] resolveResults = node.multiResolve(false);
                if (resolveResults.length != 1 || !(resolveResults[0] instanceof JSResolveResult)) {
                    return;
                }
                JSResolveResult resolveResult = (JSResolveResult)resolveResults[0];
                if (resolveResult.getElement() == null || resolveResult.getResolveProblemKey() != null && !"javascript.qualified.name.is.not.imported.message".equals(resolveResult.getResolveProblemKey())) {
                    return;
                }
                PsiElement resolved = resolveResult.getElement();
                if (resolved instanceof JSFunction && ((JSFunction)resolved).isConstructor()) {
                    resolved = resolved.getParent();
                }
                if ((resolved instanceof JSClass || (resolved instanceof JSFunction || resolved instanceof JSVariable) && resolved.getParent() instanceof JSPackageStatement) && (qName = ((JSQualifiedNamedElement)resolved).getQualifiedName()).contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)qName), JSResolveUtil.getPackageNameFromPlace(context))) {
                    result.add(qName);
                }
            }
        });
    }

    private static String getEscaped(String value, PsiElement context) {
        if (value.contains("\"")) {
            if (JSChangeSignatureProcessor.needsApos(context)) {
                return value.replace('\"', '\'');
            }
        } else if (value.contains("'") && !JSChangeSignatureProcessor.needsApos(context)) {
            return value.replace('\'', '\"');
        }
        return value;
    }

    private static boolean needsApos(PsiElement context) {
        if (context.getContainingFile().getContext() instanceof XmlAttributeValue) {
            return true;
        }
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)context, JSEmbeddedContent.class, (boolean)true);
        return embeddedContent != null && !(embeddedContent.getParent() instanceof XmlTag);
    }

    private static void addCommaIfNeeded(JSArgumentList newArgList) {
        if (newArgList.getArguments().length > 0) {
            JSChangeSignatureUtil.addComma((PsiElement)newArgList);
        }
    }

    private void refactorMethodDeclaration(JSFunction function, Collection<PsiFile> filesToOptimizeImports, MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (this.myMethodName != null && !this.myMethodName.isEmpty()) {
            PsiElement element;
            JSExpression expression;
            JSExpression lOperand;
            PsiElement parent;
            if (function instanceof JSFunctionExpression && (parent = function.getParent()) instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (element = ((JSReferenceExpression)expression).resolve()) instanceof JSVariable) {
                ((JSVariable)element).setName(this.myMethodName);
            }
            function.setName(this.myMethodName);
        }
        if (function instanceof JSFunctionExpression && function.getParent() instanceof JSVariable) {
            JSAttributeList attributeList = ((JSVariable)function.getParent()).getAttributeList();
            if (attributeList != null && attributeList.getAccessType() != this.myVisibility) {
                JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)((JSVariable)function.getParent()), this.myVisibility);
            }
        } else {
            JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)function);
            JSAttributeList attributeList = function.getAttributeList();
            if (clazz != null && (this.myVisibility == JSAttributeList.AccessType.PACKAGE_LOCAL && function.isConstructor() || clazz.isInterface())) {
                JSChangeVisibilityUtil.removeAccessModifier((JSAttributeListOwner)function);
            } else if (attributeList != null && attributeList.getAccessType() != this.myVisibility) {
                JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)function, this.myVisibility);
            }
        }
        PsiFile containingFile = function.getContainingFile();
        if (this.myMethod.getKind() == function.getKind()) {
            JSRefactoringUtil.setType((JSNamedElement)function, this.myReturnType, false);
            JSChangeSignatureUtil.setParameters(function, paramsUsages, filesToOptimizeImports, this.getLangForProcessing(), this.myParameters);
        } else if (this.myMethod.isGetProperty() && function.isSetProperty()) {
            JSParameterListElement[] params = function.getParameters();
            String name = params.length > 0 ? params[0].getName() : "value";
            JSChangeSignatureUtil.setParameters(function, paramsUsages, filesToOptimizeImports, this.getLangForProcessing(), new JSParameterInfo(name, this.myReturnType, "", "", -1));
        } else if (this.myMethod.isSetProperty() && function.isGetProperty()) {
            JSRefactoringUtil.setType((JSNamedElement)function, this.myParameters[0].getTypeText(), false);
        }
        filesToOptimizeImports.add(containingFile);
    }

    private void refactorFieldDeclaration(JSVariable field, Collection<PsiFile> filesToOptimizeImports) {
        field.setName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethodName, this.myProject));
        JSRefactoringUtil.setType((JSNamedElement)field, this.myMethod.isGetProperty() ? this.myReturnType : this.myParameters[0].getTypeText(), false);
        filesToOptimizeImports.add(field.getContainingFile());
    }

    protected String getCommandName() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{JSFormatUtil.formatMethod(this.myMethod, 4353, 0, 0, null)});
    }

    private static int getNumberOfParams(JSFunction function) {
        return function.getParameters().length;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof FunctionDeclarationUsageInfoBase) {
                JSClass clazz;
                JSFunction method = ((FunctionDeclarationUsageInfoBase)usageInfo).getFunction();
                boolean ignored = false;
                JSParameterInfo[] paramsOverride = ((FunctionDeclarationUsageInfoBase)usageInfo).getParamsOverride();
                if (paramsOverride != null || this.myMethod.getKind() == method.getKind()) {
                    if (paramsOverride != null || this.myMethodParamsNumber == JSChangeSignatureProcessor.getNumberOfParams(method)) {
                        JSParameterInfo[] newParameters = paramsOverride != null ? paramsOverride : this.myParameters;
                        JSChangeSignatureProcessor.checkLocalCollisions(method, newParameters, (MultiMap<PsiElement, String>)conflicts);
                    } else {
                        String methodDescription = RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true);
                        conflicts.putValue((Object)method, (Object)JSBundle.message((String)(JSUtils.getMemberContainingClass((PsiElement)this.myMethod).isInterface() ? "change.signature.conflict.incompatible.implementation" : "change.signature.conflict.incompatible.override"), (Object[])new Object[]{methodDescription, RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)true), StringUtil.capitalize((String)methodDescription)}));
                        ignored = true;
                    }
                } else if (this.myMethod.isGetProperty() && method.isSetProperty()) {
                    JSParameterListElement[] params = method.getParameters();
                    String name = params.length > 0 ? params[0].getName() : "value";
                    JSChangeSignatureProcessor.checkLocalCollisions(method, new JSParameterInfo[]{new JSParameterInfo(name, this.myReturnType, "", "", -1)}, (MultiMap<PsiElement, String>)conflicts);
                }
                if (ignored || paramsOverride != null || Comparing.equal((String)this.myMethodName, (String)method.getName()) || (clazz = JSUtils.getMemberContainingClass((PsiElement)method)) == null) continue;
                JSFunction pattern = ((JSClass)JSChangeUtil.createStatementFromText(this.myProject, "class Dummy{function " + this.myMethodName + "(){}}", this.getLangForProcessing()).getPsi()).findFunctionByName(this.myMethodName);
                JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)pattern, clazz, (MultiMap<PsiElement, String>)conflicts);
                continue;
            }
            if (!(usageInfo instanceof FieldDeclarationUsageInfo)) continue;
            JSVariable field = ((FieldDeclarationUsageInfo)usageInfo).getElement();
            JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)field);
            String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethodName, this.myProject);
            JSVariable pattern = ((JSClass)JSChangeUtil.createStatementFromText(this.myProject, "class Dummy{var " + fieldName + "(){}}", this.getLangForProcessing()).getPsi()).findFieldByName(fieldName);
            JSRefactoringConflictsUtil.checkMemberExist((JSAttributeListOwner)pattern, clazz, (MultiMap<PsiElement, String>)conflicts);
        }
        if (this.myChangeVisibility) {
            boolean differentPackages;
            String topClassQName = JSUtils.getMemberContainingClass((PsiElement)this.myMethod).getQualifiedName();
            Ref hasSubMethods = new Ref((Object)false);
            boolean bl = differentPackages = !JSInheritanceUtil.iterateMethodsDown(this.myMethod, (Processor<JSFunction>)((Processor)jsFunction -> {
                hasSubMethods.set((Object)true);
                String qName = JSUtils.getMemberContainingClass((PsiElement)jsFunction).getQualifiedName();
                return !JSPsiImplUtils.differentPackageName(topClassQName, qName);
            }));
            if (((Boolean)hasSubMethods.get()).booleanValue() && (this.myVisibility == JSAttributeList.AccessType.PRIVATE || differentPackages && this.myVisibility == JSAttributeList.AccessType.PACKAGE_LOCAL)) {
                String message = JSBundle.message((String)"{0}.visibility.will.break.methods.hierarchy", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)this.myMethod, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT), JSFormatUtil.formatVisibility(this.myVisibility)});
                conflicts.putValue((Object)this.myMethod, (Object)StringUtil.capitalize((String)message));
            }
            for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                JSElement rebindTo;
                if (!(usageInfo instanceof OtherUsageInfo) || !((rebindTo = ((OtherUsageInfo)usageInfo).getRebindTo()) instanceof JSAttributeListOwner)) continue;
                JSRefactoringConflictsUtil.checkAccessibility((JSAttributeListOwner)rebindTo, null, this.myVisibility.name(), usageInfo.getElement(), (MultiMap<PsiElement, String>)conflicts, true, JSVisibilityUtil.DEFAULT_OPTIONS);
            }
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    private static void checkLocalCollisions(JSFunction function, JSParameterInfo[] newParameters, MultiMap<PsiElement, String> conflicts) {
        HashSet deletedOrRenamedParameters = new HashSet();
        Object[] oldParameters = function.getParameterVariables();
        ContainerUtil.addAll((Collection)deletedOrRenamedParameters, (Object[])oldParameters);
        for (JSParameterInfo parameterInfo : newParameters) {
            if (parameterInfo.getOldIndex() == -1) continue;
            Object oldParameter = oldParameters[parameterInfo.getOldIndex()];
            if (!parameterInfo.getName().equals(oldParameter.getName())) continue;
            deletedOrRenamedParameters.remove(oldParameter);
        }
        boolean isDeclaringMethod = !JSInheritanceUtil.hasSuperMethods(function);
        Condition filter = arg_0 -> JSChangeSignatureProcessor.lambda$checkLocalCollisions$2(isDeclaringMethod, (Set)deletedOrRenamedParameters, arg_0);
        for (JSParameterInfo parameterInfo : newParameters) {
            int oldParameterIndex = parameterInfo.getOldIndex();
            if (oldParameterIndex != -1) {
                Object parameter = oldParameters[oldParameterIndex];
                if (parameterInfo.getName().equals(parameter.getName())) continue;
                JSChangeSignatureProcessor.reportLocalCollisions(function, parameterInfo.getName(), false, conflicts, (Condition<PsiElement>)filter);
                continue;
            }
            JSChangeSignatureProcessor.reportLocalCollisions(function, parameterInfo.getName(), true, conflicts, (Condition<PsiElement>)filter);
        }
    }

    @Nullable
    public static PsiElement getCollidingElement(JSFunction function, final String name, final Condition<PsiElement> filter) {
        final Ref result = new Ref();
        function.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$3", "execute"));
                }
                if (!(element instanceof JSVariable)) {
                    return true;
                }
                if (!name.equals(((JSVariable)element).getName())) {
                    return true;
                }
                if (!filter.value((Object)element)) {
                    return true;
                }
                result.set((Object)element);
                return false;
            }
        }, ResolveState.initial(), function.getFirstChild(), (PsiElement)function);
        return (PsiElement)result.get();
    }

    private static void reportLocalCollisions(JSFunction function, String name, boolean newParameter, MultiMap<PsiElement, String> conflicts, Condition<PsiElement> filter) {
        PsiElement element = JSChangeSignatureProcessor.getCollidingElement(function, name, filter);
        if (element != null) {
            String message = RefactoringBundle.message((String)(newParameter ? "there.is.already.a.0.in.1.it.will.conflict.with.the.new.parameter" : "there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter"), (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)function, (boolean)true)});
            conflicts.putValue((Object)function, (Object)StringUtil.capitalize((String)message));
        }
    }

    protected boolean shouldPropagate(PsiElement element) {
        return this.myMethodsToPropagateParameters.contains(PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class));
    }

    private JSLanguageDialect getLangForProcessing() {
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)this.myMethodContainingFile);
        return dialect != null ? dialect : JavaScriptSupportLoader.ECMA_SCRIPT_L4;
    }

    private static /* synthetic */ boolean lambda$checkLocalCollisions$2(boolean isDeclaringMethod, Set deletedOrRenamedParameters, PsiElement psiElement) {
        return (isDeclaringMethod || !(psiElement instanceof JSParameter)) && !deletedOrRenamedParameters.contains(psiElement);
    }

    protected static class OtherUsageInfo
    extends UsageInfo {
        @Nullable
        private final SmartPsiElementPointer<JSElement> myRebindTo;
        private final JSParameterInfo[] myParameters;
        private final boolean myPropagate;
        private final int myMinParams;
        private final int myMaxParams;

        public OtherUsageInfo(PsiElement element, @Nullable JSElement rebindTo, JSParameterInfo[] parameters, boolean propagate, int minParams, int maxParams) {
            super(element);
            this.myRebindTo = rebindTo == null ? null : SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)rebindTo);
            this.myParameters = parameters;
            this.myPropagate = propagate;
            this.myMinParams = minParams;
            this.myMaxParams = maxParams;
        }

        @Nullable
        public JSElement getRebindTo() {
            return this.myRebindTo == null ? null : (JSElement)this.myRebindTo.getElement();
        }

        public JSParameterInfo[] getParameters() {
            return this.myParameters;
        }

        public boolean isPropagate() {
            return this.myPropagate;
        }
    }

    private static class FieldDeclarationUsageInfo
    extends UsageInfo {
        public FieldDeclarationUsageInfo(JSVariable field) {
            super((PsiElement)field);
        }

        public JSVariable getElement() {
            return (JSVariable)super.getElement();
        }
    }

    private static class FunctionExpressionDeclarationUsageInfo
    extends FunctionDeclarationUsageInfoBase {
        public FunctionExpressionDeclarationUsageInfo(PsiElement variableOrAssigment, @Nullable JSParameterInfo[] paramsOverride) {
            super(variableOrAssigment, paramsOverride);
        }

        @Override
        @Nullable
        protected JSFunction getFunction() {
            PsiElement element = this.getElement();
            if (element == null) {
                return null;
            }
            return (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)element, JSFunctionExpression.class);
        }
    }

    protected static class MethodDeclarationUsageInfo
    extends FunctionDeclarationUsageInfoBase {
        public MethodDeclarationUsageInfo(JSFunction function, @Nullable JSParameterInfo[] paramsOverride) {
            super((PsiElement)function, paramsOverride);
        }

        public JSFunction getElement() {
            return (JSFunction)super.getElement();
        }

        @Override
        @Nullable
        protected JSFunction getFunction() {
            return this.getElement();
        }
    }

    static abstract class FunctionDeclarationUsageInfoBase
    extends UsageInfo {
        private final JSParameterInfo[] myParamsOverride;
        private final MultiMap<JSParameter, UsageInfo> myParamsUsages = new MultiMap();

        protected FunctionDeclarationUsageInfoBase(PsiElement element, @Nullable JSParameterInfo[] paramsOverride) {
            super(element);
            this.myParamsOverride = paramsOverride;
        }

        @Nullable
        protected abstract JSFunction getFunction();

        public JSParameterInfo[] getParamsOverride() {
            return this.myParamsOverride;
        }

        public MultiMap<JSParameter, UsageInfo> getParamsUsages() {
            return this.myParamsUsages;
        }

        public void searchForParametersUsages() {
            JSFunction function = this.getFunction();
            if (function == null) {
                return;
            }
            JSParameterList parameterList = function.getParameterList();
            if (parameterList == null) {
                return;
            }
            for (JSParameter parameter : parameterList.getParameterVariables()) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                    if (JSResolveUtil.isSelfReference((PsiElement)parameter, reference.getElement())) continue;
                    this.myParamsUsages.putValue((Object)parameter, (Object)new UsageInfo(reference));
                }
            }
        }
    }
}

