/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import org.jetbrains.annotations.NotNull;

public class JSParameterInfo
implements ParameterInfo {
    private final int myOldIndex;
    private String myName = "";
    private String myTypeText = "";
    private String myDefaultValue = "";
    private String myInitializer = "";
    private boolean myIsOptional;

    public static JSParameterInfo build(@NotNull JSParameter parameter, int index) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterInfo", "build"));
        }
        JSExpression initializerExpr = parameter.getInitializer();
        String initializer = initializerExpr == null ? null : initializerExpr.getText();
        JSType type = parameter.getType();
        String typeText = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        return new JSParameterInfo(parameter.getName(), typeText, initializer, null, index, parameter.isOptional());
    }

    public JSParameterInfo(String name, String type, String initializer, String defaultValue, int oldIndex, boolean optional) {
        this(name, type, initializer, defaultValue, oldIndex);
        this.myIsOptional = optional;
    }

    public JSParameterInfo(String name, String type, String initializer, String defaultValue, int oldIndex) {
        this.myName = name;
        this.myInitializer = initializer;
        this.myOldIndex = oldIndex;
        this.myTypeText = type;
        this.myDefaultValue = defaultValue;
    }

    public String getName() {
        return this.myName;
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getTypeText() {
        return "null".equals(this.myTypeText) ? "*" : this.myTypeText;
    }

    public void setTypeText(String type) {
        this.myTypeText = type;
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public String getInitializer() {
        return this.myInitializer;
    }

    public void setInitializer(String initializer) {
        this.myInitializer = initializer;
    }

    public boolean isOptional() {
        return this.myIsOptional;
    }

    public void setOptional(boolean optional) {
        this.myIsOptional = optional;
    }
}

