/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractedFunctionSignatureInfoBuilder;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.ECMA4FunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ECMA4ExtractedFunctionSignatureInfoBuilder
extends JSExtractedFunctionSignatureInfoBuilder {
    private static final ECMA4FunctionSignatureGenerator ECMA4_GENERATOR = new ECMA4FunctionSignatureGenerator();

    @Override
    protected JSFunctionSignatureGenerator getGenerator() {
        return ECMA4_GENERATOR;
    }

    @Override
    protected void fill(JSFunctionSignatureInfo result, JSExtractFunctionSettings settings, JSExtractFunctionHandler.IntroductionScope introductionScope, PsiElement anchor) {
        super.fill(result, settings, introductionScope, anchor);
        ECMA4ExtractedFunctionSignatureInfoBuilder.setStatic(result, settings, anchor);
        ECMA4ExtractedFunctionSignatureInfoBuilder.setAccessType(result, settings);
        ECMA4ExtractedFunctionSignatureInfoBuilder.setReturnType(result, introductionScope, anchor);
    }

    private static void setReturnType(JSFunctionSignatureInfo result, JSExtractFunctionHandler.IntroductionScope introductionScope, PsiElement anchor) {
        String typeName = JSResolveUtil.getShortTypeName(introductionScope.returnType, true);
        if (JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(typeName, anchor, introductionScope.returnType, true)) {
            typeName = introductionScope.returnType;
        }
        result.setReturnType(typeName);
    }

    @Override
    @Nullable
    protected String getStringType(@NotNull JSVariable variable, @Nullable JSExtractFunctionSettings.ParameterInfo parameterInfo) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/refactoring/extractMethod/ECMA4ExtractedFunctionSignatureInfoBuilder", "getStringType"));
        }
        String type = ECMA4ExtractedFunctionSignatureInfoBuilder.getStringTypeImpl(variable, parameterInfo);
        String shortenedType = JSResolveUtil.getShortenedType(type, (PsiElement)variable);
        return StringUtil.isEmpty((String)shortenedType) ? "*" : shortenedType;
    }
}

