/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class JSConstructorReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public JSConstructorReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher", "processQuery"));
        }
        PsiElement element = p.getElementToSearch();
        if (!(element instanceof JSFunction) || !((JSFunction)element).isConstructor()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSClass)) {
            return;
        }
        SearchScope searchScope = p.getEffectiveSearchScope();
        JSClassSearch.searchClassInheritors((JSClass)parent, false).forEach(jsClass -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher", "lambda$processQuery$1"));
            }
            return JSInheritanceUtil.processSuperCallsIn(jsClass, (Processor<JSCallExpression>)((Processor)jsCallExpression -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher", "lambda$null$0"));
                }
                if (PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)jsCallExpression)) {
                    return consumer.process((Object)jsCallExpression.getMethodExpression().getReference());
                }
                return false;
            }));
        });
    }
}

