/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSResolveStatisticsCollector {
    private static final JSResolveStatisticsCollector INSTANCE = new JSResolveStatisticsCollector();
    private static final JSResolveStatisticsCollector DUMMY_INSTANCE = new JSResolveStatisticsCollector(){

        @Override
        public void consume(ResolveSource resolveSource, int count) {
        }
    };
    private final Collection<ResolveSourceAndCount> myResults = Collections.synchronizedList(new ArrayList());

    private JSResolveStatisticsCollector() {
    }

    @NotNull
    public static JSResolveStatisticsCollector getInstance() {
        JSResolveStatisticsCollector jSResolveStatisticsCollector = DUMMY_INSTANCE;
        if (jSResolveStatisticsCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/statistics/JSResolveStatisticsCollector", "getInstance"));
        }
        return jSResolveStatisticsCollector;
    }

    public void consume(ResolveSource resolveSource, int count) {
        this.myResults.add(new ResolveSourceAndCount(resolveSource, count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceResults() {
        int[] results = new int[ResolveSource.values().length];
        Collection<ResolveSourceAndCount> collection = this.myResults;
        synchronized (collection) {
            for (ResolveSourceAndCount result : this.myResults) {
                int n = result.mySource.ordinal();
                results[n] = results[n] + 1;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < results.length; ++i) {
            builder.append(ResolveSource.values()[i].name()).append(" : ").append(results[i]).append('\n');
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResultsCountDistribution() {
        int[] groups = new int[]{0, 1, 2, 5, 10, 20, 50, 100};
        int[][] results = new int[ResolveSource.values().length][groups.length];
        Collection<ResolveSourceAndCount> collection = this.myResults;
        synchronized (collection) {
            for (ResolveSourceAndCount result : this.myResults) {
                int group = Arrays.binarySearch(groups, result.myCount);
                if (group < 0) {
                    group = -group - 2;
                }
                int[] nArray = results[result.mySource.ordinal()];
                int n = group;
                nArray[n] = nArray[n] + 1;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < results.length; ++i) {
            for (int group = 0; group < groups.length; ++group) {
                builder.append(ResolveSource.values()[i].name()).append(", ");
                if (group == groups.length - 1) {
                    builder.append(groups[group]).append('+');
                } else {
                    int from = groups[group];
                    int to = groups[group + 1] - 1;
                    builder.append(from);
                    if (to > from) {
                        builder.append(" - ").append(to);
                    }
                }
                builder.append(" : ").append(results[i][group]).append('\n');
            }
        }
        return builder.toString();
    }

    private static class ResolveSourceAndCount {
        ResolveSource mySource;
        int myCount;

        public ResolveSourceAndCount(ResolveSource source, int count) {
            this.mySource = source;
            this.myCount = count;
        }
    }

    public static enum ResolveSource {
        LOCAL,
        QUALIFIED,
        PROCESSED_BY_QNAME,
        PROCESSED_BY_NAME,
        SYMBOL;

    }
}

