/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSIndexedPropertyAccessExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSDefinitionExpressionStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionElementType
extends JSStubElementType<JSDefinitionExpressionStub, JSDefinitionExpression> {
    public JSDefinitionExpressionElementType() {
        super("DEFINITION_EXPRESSION");
    }

    public JSDefinitionExpressionStub createStub(@NotNull JSDefinitionExpression psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSDefinitionExpressionElementType", "createStub"));
        }
        return new JSDefinitionExpressionStubImpl(psi, parentStub);
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSDefinitionExpressionImpl(node);
    }

    @NotNull
    public JSDefinitionExpressionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSDefinitionExpressionElementType", "deserialize"));
        }
        JSDefinitionExpressionStubImpl jSDefinitionExpressionStubImpl = new JSDefinitionExpressionStubImpl(dataStream, parentStub);
        if (jSDefinitionExpressionStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSDefinitionExpressionElementType", "deserialize"));
        }
        return jSDefinitionExpressionStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode(node);
        if (expressionNode == null) {
            return false;
        }
        if (expressionNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            Language language;
            ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(expressionNode);
            return JSReferenceExpressionImpl.getQualifierNode(expressionNode) != null || nameElement == null || !((language = JSTreeUtil.getLanguage(node)) instanceof TypeScriptLanguageDialect) && !(language instanceof ECMAL4LanguageDialect) && !JSTreeUtil.definedInScopeAndUp(nameElement.getText(), node);
        }
        if (expressionNode.getElementType() == JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION) {
            ASTNode index = JSIndexedPropertyAccessExpressionImpl.getIndexExpression(expressionNode);
            return index != null && (index.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && JSLiteralExpressionImpl.isQuotedLiteral(index) || index.getElementType() == JSElementTypes.REFERENCE_EXPRESSION);
        }
        return false;
    }
}

