/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.messages.MessageBus;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompiledFilePropertyPusher
implements FilePropertyPusher<Boolean> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("ts_compiled_flag", 1, true);

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "initExtra"));
        }
    }

    @NotNull
    public Key<Boolean> getFileDataKey() {
        Key<Boolean> key = JSLanguageService.GENERATED_FILE_MARKER;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "getFileDataKey"));
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public Boolean getDefaultValue() {
        Boolean bl = false;
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "getDefaultValue"));
        }
        return bl;
    }

    @Nullable
    public Boolean getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "getImmediateValue"));
        }
        if (file == null) {
            return false;
        }
        Boolean resultValue = TypeScriptCompiledFilePropertyPusher.readAttribute(file);
        if (resultValue != null) {
            return resultValue;
        }
        return false;
    }

    @Nullable
    private static Boolean readAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "readAttribute"));
        }
        DataInputStream stream = PERSISTENCE.readAttribute(file);
        try {
            if (stream != null) {
                Boolean bl = stream.readBoolean();
                return bl;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    @Nullable
    public Boolean getImmediateValue(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "getImmediateValue"));
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "acceptsFile"));
        }
        FileType fileType = file.getFileType();
        return fileType == JavaScriptSupportLoader.JAVASCRIPT || fileType == JsonFileType.INSTANCE;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "acceptsDirectory"));
        }
        return false;
    }

    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Boolean value) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "persistAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "persistAttribute"));
        }
        if (fileOrDir.isDirectory()) {
            return;
        }
        if (value == Boolean.FALSE) {
            return;
        }
        Boolean attr = TypeScriptCompiledFilePropertyPusher.readAttribute(fileOrDir);
        if (attr == value) {
            return;
        }
        TypeScriptCompiledFilePropertyPusher.writeAttribute(fileOrDir);
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir);
    }

    public static void writeAttribute(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "writeAttribute"));
        }
        DataOutputStream stream = PERSISTENCE.writeAttribute(fileOrDir);
        try {
            stream.writeBoolean(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompiledFilePropertyPusher", "afterRootsChanged"));
        }
    }
}

