/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TypeScriptCompiler", storages={@Storage(value="typescript-compiler.xml")})
public class TypeScriptCompilerSettings
implements PersistentStateComponent<CompilerSettings> {
    public static final String[] CONFIG_PARAMS = new String[]{"-p", "--p", "--project", "-project"};
    public static final String DEFAULT_SCOPE = "Project Files";
    public static final String TYPESCRIPT_COMPILER_EXCLUDE_GENERATED_FROM_INDEX = "typescript.compiler.exclude.generated.from.index";
    private final Project myProject;
    public static String[] TYPESCRIPT_SERVICE_FILES = new String[]{"tsserver.js", "tsserverlibrary.js"};
    private CompilerSettings myState = new CompilerSettings();

    public static boolean useNewTypeScriptService(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.isUseService() && (!settings.isCompilerEnabled() || settings.isUseConfigForCompiler());
    }

    public static TypeScriptCompilerSettings getSettings(Project project) {
        return (TypeScriptCompilerSettings)ServiceManager.getService((Project)project, TypeScriptCompilerSettings.class);
    }

    public TypeScriptCompilerSettings(Project project) {
        this.myProject = project;
    }

    @Nullable
    public CompilerSettings getState() {
        return this.myState;
    }

    public void loadState(CompilerSettings state) {
        this.myState = state;
    }

    public boolean isCompilerEnabled() {
        return this.myState.isCompilerEnabled;
    }

    public String getTypeScriptCompilerParams() {
        return this.myState.typeScriptCompilerParams;
    }

    public void setTypeScriptCompilerParams(@Nullable String typeScriptCompilerParams) {
        this.myState.typeScriptCompilerParams = StringUtil.nullize((String)typeScriptCompilerParams, (boolean)true);
    }

    public boolean isUseServiceCompletion() {
        return this.myState.useServiceCompletion;
    }

    public void setImmediateCompileEnabled(boolean value) {
        this.myState.isCompilerEnabled = value;
    }

    public void setTypeScriptServiceDirectory(@Nullable String path) {
        this.myState.typeScriptServiceDirectory = PathMacroManager.getInstance((ComponentManager)this.myProject).expandPath(StringUtil.nullize((String)path, (boolean)true));
    }

    @Nullable
    public String getTypeScriptServiceDirectory() {
        return PathMacroManager.getInstance((ComponentManager)this.myProject).expandPath(this.myState.typeScriptServiceDirectory);
    }

    public TypeScriptCompilerVersionType getVersionType() {
        return this.myState.versionType;
    }

    public void setVersionType(TypeScriptCompilerVersionType type) {
        this.myState.versionType = type;
    }

    @Nullable
    public String getNodeInterpreter() {
        return this.myState.nodeInterpreterTextField;
    }

    public void setNodeInterpreter(String nodeInterpreterTextField) {
        this.myState.nodeInterpreterTextField = StringUtil.nullize((String)nodeInterpreterTextField, (boolean)true);
    }

    @NotNull
    public String getScopeName() {
        String scopeName = this.myState.scopeName;
        String string = scopeName == null ? DEFAULT_SCOPE : scopeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings", "getScopeName"));
        }
        return string;
    }

    public void setScopeName(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings", "setScopeName"));
        }
        this.myState.scopeName = scopeName;
    }

    public boolean isGenerateSourceMap() {
        return this.myState.generateSourceMap;
    }

    public void setGenerateSourceMap(boolean generateSourceMap) {
        this.myState.generateSourceMap = generateSourceMap;
    }

    @NotNull
    public String getTypeScriptServiceDirectoryOrDefault() {
        if (this.myState.typeScriptServiceDirectory != null) {
            String string = this.myState.typeScriptServiceDirectory;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings", "getTypeScriptServiceDirectoryOrDefault"));
            }
            return string;
        }
        String string = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile().getAbsolutePath(), "external").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerSettings", "getTypeScriptServiceDirectoryOrDefault"));
        }
        return string;
    }

    public static boolean excludeGeneratedFilesFromJSIndex() {
        return PropertiesComponent.getInstance().getBoolean(TYPESCRIPT_COMPILER_EXCLUDE_GENERATED_FROM_INDEX, true);
    }

    public boolean isTrackFileSystemChanges() {
        return this.myState.trackFileSystemChanges;
    }

    public boolean isCompilerEnabledAndNeedTrackChanges() {
        return this.isCompilerEnabled() && this.isTrackFileSystemChanges();
    }

    public void setTrackFileSystemChanges(boolean trackFileSystemChanges) {
        this.myState.trackFileSystemChanges = trackFileSystemChanges;
    }

    public static String getOSDependTypeScriptServicesPathByDirectory(String path) {
        String normalizePath = StringUtil.trimEnd((String)FileUtil.normalize((String)path), (String)"/");
        return FileUtil.toSystemDependentName((String)normalizePath);
    }

    public boolean isHasOutDirectory() {
        return this.myState.hasOutDirectory;
    }

    public void setHasOutDirectory(boolean pHasOutPath) {
        this.myState.hasOutDirectory = pHasOutPath;
    }

    public String getOutDirectory() {
        return this.myState.outDirectory;
    }

    public void setOutDirectory(String outDirectory) {
        this.myState.outDirectory = StringUtil.nullize((String)outDirectory, (boolean)true);
    }

    public String getMainFilePath() {
        return this.myState.mainFilePath;
    }

    public void setMainFilePath(String mainFilePath) {
        this.myState.mainFilePath = StringUtil.nullize((String)mainFilePath, (boolean)true);
    }

    public boolean isUseMainFile() {
        return this.myState.useMainFile;
    }

    public void setUseMainFile(boolean useMainFile) {
        this.myState.useMainFile = useMainFile;
    }

    public static boolean acceptFileType(FileType type) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type);
    }

    public void setUseConfigForCompiler(boolean value) {
        this.myState.useConfig = value;
    }

    public boolean isUseConfigForCompiler() {
        return this.myState.useConfig;
    }

    public boolean isUseService() {
        return this.myState.useService;
    }

    public void setUseService(boolean useService) {
        this.myState.useService = useService;
    }

    public static Collection<String> getPossibleOutputDirectories(Project project) {
        String outDirectory;
        ArrayList files = ContainerUtil.newArrayList();
        for (TypeScriptConfig config : TypeScriptConfigService.Provider.getConfigFiles(project)) {
            String directory = config.getOutDirectory();
            if (directory == null) continue;
            files.add(directory);
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        String directory = settings.getOutDirectory();
        if (!StringUtil.isEmpty((String)directory) && !StringUtil.contains((CharSequence)"$", (CharSequence)directory) && (outDirectory = TypeScriptConfigUtil.getOutDirectory(project.getBaseDir(), directory)) != null) {
            files.add(outDirectory);
        }
        return files;
    }

    static class CompilerSettings {
        public boolean isCompilerEnabled = false;
        public String typeScriptServiceDirectory = null;
        public String typeScriptCompilerParams = null;
        public String nodeInterpreterTextField = null;
        public String scopeName = "Project Files";
        public boolean generateSourceMap = true;
        public boolean trackFileSystemChanges = true;
        public boolean hasOutDirectory = false;
        public String outDirectory = "$FileDir$";
        public String mainFilePath = null;
        public boolean useMainFile = false;
        public boolean useConfig = false;
        public boolean useService = false;
        public boolean useServiceCompletion = true;
        public TypeScriptCompilerVersionType versionType = TypeScriptCompilerVersionType.EMBEDDED;

        CompilerSettings() {
        }
    }

    public static enum TypeScriptCompilerVersionType {
        EMBEDDED{

            @Override
            public String getTitle(TypeScriptCompilerSettings settings) {
                return String.format("%s (bundled)", JSBundle.message((String)"typescript.compiler.embedded.version", (Object[])new Object[0]));
            }
        }
        ,
        SERVICE_DIRECTORY{

            @Override
            public String getTitle(TypeScriptCompilerSettings settings) {
                return "custom";
            }
        }
        ,
        GITHUB{

            @Override
            public String getTitle(TypeScriptCompilerSettings settings) {
                return null;
            }
        };


        public abstract String getTitle(TypeScriptCompilerSettings var1);
    }
}

