/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptUpdateFilesContent;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    private static final int TIME_TO_MERGE = 2000;
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    @NotNull
    private final MergingUpdateQueue myCompileQueue;

    public TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        super(project, settings);
        this.myCompileQueue = new MergingUpdateQueue("TypeScript Compile queue", 2000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCleanCommandToCompiler"));
        }
        JSLanguageService process = this.getProcess();
        if (process != null) {
            this.sendCommand(new TypeScriptReloadProjectsCommand());
            process.resetCaches();
        }
    }

    @Override
    @Nullable
    public Future<List<JSLanguageServiceAnnotationResult>> updateFilesAndGetErrors(@NotNull TypeScriptCompileInfoBuilder.FileHighlightingInfo info, boolean useCache) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateFilesAndGetErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        this.updateImpl(info.updateContext, true);
        String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(info.file);
        TypeScriptGetErrCommand getError = new TypeScriptGetErrCommand(path, info.fileTimestamp);
        return process.executeWithCache(getError, new JSLanguageServiceCacheableCommandProcessor<List<JSLanguageServiceAnnotationResult>>(){

            @Override
            public List<JSLanguageServiceAnnotationResult> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                JSLanguageServiceToolWindowManager toolWindowManager;
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement bodyProperty = element.get(TypeScriptServerServiceImpl.BODY_FIELD);
                if (bodyProperty == null) {
                    return null;
                }
                ImmutableList results = TypeScriptServerServiceImpl.parseAnnotationResult(bodyProperty);
                if (results != null && (toolWindowManager = TypeScriptServerServiceImpl.this.myToolWindowManager) != null) {
                    ApplicationManager.getApplication().invokeLater(() -> toolWindowManager.logCurrentErrors((ImmutableList<JSLanguageServiceAnnotationResult>)results, false), TypeScriptServerServiceImpl.this.myProject.getDisposed());
                }
                return results;
            }

            @Override
            @NotNull
            public List<JSLanguageServiceAnnotationResult> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSLanguageServiceAnnotationResult> result) {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                List<JSLanguageServiceAnnotationResult> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                return list;
            }
        });
    }

    @Nullable
    private static ImmutableList<JSLanguageServiceAnnotationResult> parseAnnotationResult(@NotNull JsonElement bodyProperty) {
        if (bodyProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyProperty", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "parseAnnotationResult"));
        }
        TypeScriptDiagnosticsResponse result = (TypeScriptDiagnosticsResponse)new Gson().fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        ArrayList results = ContainerUtil.newArrayList();
        if (result == null || result.infos == null || result.infos.length == 0) {
            return null;
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body : result.infos) {
            String file = body.file;
            for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : body.diagnostics) {
                String category = diagnostic.category;
                if (category == null) {
                    category = "error";
                }
                TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
                TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
                results.add(new JSLanguageServiceAnnotationResult(diagnostic.text, file, category, start.line, start.offset, end.line, end.offset));
            }
        }
        return ContainerUtil.immutableList((List)results);
    }

    private void addFileToCompileQueue(@NotNull Collection<String> fileNames, boolean toFlush) {
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
        if (!fileNames.isEmpty()) {
            fileNames.stream().filter(el -> !TypeScriptUtil.isDefinitionFile(el)).map(el -> {
                TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                args.file = el;
                return args;
            }).forEach(this::queueCompileTask);
        }
        if (toFlush) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> ((MergingUpdateQueue)this.myCompileQueue).flush());
        }
    }

    private boolean isCompileEnabled() {
        return this.mySettings.isCompilerEnabledAndNeedTrackChanges();
    }

    private void queueCompileTask(final @NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueCompileTask"));
        }
        this.myCompileQueue.queue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.sendCompileCommand(args);
            }
        });
    }

    private void sendCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCompileCommand"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null || process.getState() != JSLanguageService.State.STARTED) {
            return;
        }
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)((Consumer)answer -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get(BODY_FIELD);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return;
            }
            TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(this.myProject, jsonElement.getAsJsonObject(), GENERATED_FILES_FIELD);
        }));
    }

    @Override
    @NotNull
    protected JSLanguageServiceImpl createService(boolean useConfig) {
        JSLanguageServiceImpl service = new JSLanguageServiceImpl(this.myProject, new TypeScriptServiceStandardOutputProtocol(this.myProject, useConfig), this.myToolWindowManager, new TypeScriptLanguageServiceCacheImpl(this.myProject));
        Consumer<JSLanguageService> initializer = this.getInitializedCallback();
        initializer.consume((Object)service);
        JSLanguageServiceImpl jSLanguageServiceImpl = service;
        if (jSLanguageServiceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createService"));
        }
        return jSLanguageServiceImpl;
    }

    @Override
    public void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
        if (!this.isCompileEnabled()) {
            return;
        }
        List fileNames = ContainerUtil.mapNotNull(files, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && null == el.getUserData(JSLanguageService.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        this.addFileToCompileQueue(fileNames, false);
    }

    @Override
    @Nullable
    public Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "update"));
        }
        return this.updateImpl(context, false);
    }

    @Nullable
    private Future<Boolean> updateImpl(@NotNull JSLanguageServiceUpdateContext context, final boolean compile) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateImpl"));
        }
        TypeScriptLanguageServiceUpdateFilesCommand command = new TypeScriptLanguageServiceUpdateFilesCommand(context.timestamps, context.contents);
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        return process.execute(command, new JSLanguageServiceCommandResultProcessor<Boolean>(){

            @Override
            @NotNull
            public Boolean process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$3", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$3", "process"));
                }
                if (serviceObject instanceof TypeScriptUpdateFilesContent && TypeScriptServerServiceImpl.this.isCompileEnabled()) {
                    TypeScriptServerServiceImpl.this.addFileToCompileQueue(((TypeScriptUpdateFilesContent)serviceObject).files.keySet(), compile);
                }
                Boolean bl = true;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$3", "process"));
                }
                return bl;
            }
        });
    }

    @NotNull
    protected Consumer<JSLanguageService> getInitializedCallback() {
        Consumer consumer = service -> ReadAction.run(() -> {
            TypeScriptLanguageServiceEvents events = TypeScriptLanguageServiceEvents.getService(this.myProject);
            Set<VirtualFile> filesToOpen = TypeScriptLanguageServiceUtil.getOpenedFiles(this.myProject).keySet();
            for (final VirtualFile vFile : filesToOpen) {
                service.execute(events.createOpenEditorCommand(vFile), new JSLanguageServiceCommandResultProcessor<Object>(){

                    @Override
                    public Object process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                        if (serviceObject == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                        }
                        if (answer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                        }
                        service.resetCaches();
                        ReadAction.run(() -> {
                            PsiFile file;
                            if (service.getState() == JSLanguageService.State.DISPOSED) {
                                return;
                            }
                            if (vFile.isValid() && !TypeScriptServerServiceImpl.this.myProject.isDisposed() && (file = PsiManager.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).findFile(vFile)) != null) {
                                DaemonCodeAnalyzer.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).restart(file);
                            }
                        });
                        return null;
                    }
                });
            }
        });
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getInitializedCallback"));
        }
        return consumer;
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileFileAndGetErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        String path = file.getCanonicalPath();
        if (path == null || TypeScriptUtil.isDefinitionFile(path)) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileConfigProjectAndGetErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.tsConfig = TypeScriptCompilerConfigUtil.normalizeNameAndPath(config.getConfigFile());
        return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
    }

    @NotNull
    private JSLanguageServiceCommandResultProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandResultProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandResultProcessor = new JSLanguageServiceCommandResultProcessor<JSLanguageServiceResultContainer>(){

            @Override
            public JSLanguageServiceResultContainer process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement body = element.get(TypeScriptServerServiceImpl.BODY_FIELD);
                if (body == null || !body.isJsonObject()) {
                    return null;
                }
                JsonObject bodyObject = body.getAsJsonObject();
                TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(TypeScriptServerServiceImpl.this.myProject, bodyObject, TypeScriptServerServiceImpl.GENERATED_FILES_FIELD);
                ImmutableList annotationResults = TypeScriptServerServiceImpl.parseAnnotationResult((JsonElement)bodyObject);
                return new JSLanguageServiceResultContainer(annotationResults == null ? ContainerUtil.emptyList() : annotationResults, ContainerUtil.emptyList());
            }
        };
        if (jSLanguageServiceCommandResultProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompileResultProcessor"));
        }
        return jSLanguageServiceCommandResultProcessor;
    }
}

