/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.projectView.TypeScriptNestingTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static final String[] EXTENSIONS = new String[]{".js", ".js.map", ".jsx", ".jsx.map", ".d.ts"};
    private static final String[] ALL_EXTENSIONS = ArrayUtil.mergeArrays((String[])EXTENSIONS, (String[])new String[]{".ts", ".tsx"});

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
        }
        if (!(parent instanceof PsiDirectoryNode)) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (!this.hasTypeScriptFiles(children)) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        MultiMap equalFileNamesFiles = MultiMap.createSet();
        HashMap nameToTypeScriptFiles = ContainerUtil.newHashMap();
        HashSet typeScriptFiles = ContainerUtil.newHashSet();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof PsiFileNode)) continue;
            PsiFileNode psiFileNode = (PsiFileNode)child;
            PsiFile value = (PsiFile)psiFileNode.getValue();
            VirtualFile virtualFile = psiFileNode.getVirtualFile();
            if (virtualFile == null) continue;
            String name = TypeScriptNestingTreeStructureProvider.getName(virtualFile);
            if (value == null || StringUtil.isEmpty((String)name)) continue;
            boolean isGeneratedFile = TypeScriptNestingTreeStructureProvider.fileCanBeGenerated(virtualFile);
            if (isGeneratedFile && !StringUtil.isEmpty((String)name)) {
                equalFileNamesFiles.putValue((Object)name, (Object)value);
            }
            if (isGeneratedFile || !TypeScriptCompilerSettings.acceptFileType(value.getFileType())) continue;
            nameToTypeScriptFiles.put(name, value);
            typeScriptFiles.add(psiFileNode);
        }
        if (typeScriptFiles.isEmpty()) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        List list = ContainerUtil.mapNotNull(children, node -> {
            if (!(node instanceof PsiFileNode)) {
                return node;
            }
            PsiFileNode psiFileNode = (PsiFileNode)node;
            VirtualFile file = psiFileNode.getVirtualFile();
            if (file == null) {
                return node;
            }
            String name = TypeScriptNestingTreeStructureProvider.getName(file);
            if (StringUtil.isEmpty((String)name)) {
                return node;
            }
            if (typeScriptFiles.contains(node)) {
                if (!StringUtil.isEmpty((String)name) && equalFileNamesFiles.get((Object)name).size() > 0) {
                    return new TypeScriptNestingTreeNode(psiFileNode);
                }
                return node;
            }
            if (nameToTypeScriptFiles.containsKey(name) && equalFileNamesFiles.get((Object)name).contains(psiFileNode.getValue())) {
                return null;
            }
            return node;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "modify"));
        }
        return list;
    }

    public boolean hasTypeScriptFiles(@NotNull Collection<AbstractTreeNode> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "hasTypeScriptFiles"));
        }
        boolean hasTypeScriptFiles = false;
        for (AbstractTreeNode child : children) {
            PsiFileNode psiFileNode;
            PsiFile value;
            if (!(child instanceof PsiFileNode) || !((value = (PsiFile)(psiFileNode = (PsiFileNode)child).getValue()) instanceof JSFile) || !TypeScriptCompilerSettings.acceptFileType(value.getFileType())) continue;
            hasTypeScriptFiles = true;
            break;
        }
        return hasTypeScriptFiles;
    }

    @Nullable
    public static String getName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "getName"));
        }
        return TypeScriptNestingTreeStructureProvider.getName(file.getName());
    }

    @Nullable
    public static String getName(@Nullable String fullName) {
        String extension = JSFileReference.findExtension(fullName, ALL_EXTENSIONS);
        if (extension == null) {
            return fullName;
        }
        return fullName.substring(0, fullName.length() - extension.length());
    }

    public static boolean fileCanBeGenerated(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/projectView/TypeScriptNestingTreeStructureProvider", "fileCanBeGenerated"));
        }
        return JSFileReference.findExtension(file.getName(), EXTENSIONS) != null;
    }

    @Nullable
    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }
}

