/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileModuleReference
extends JSFileReference {
    public TypeScriptFileModuleReference(String text, int i, TextRange textRange, FileReferenceSet refSet) {
        super(text, i, textRange, refSet, TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
    }

    public String getNewFileTemplateName() {
        return "TypeScript_module.ts";
    }

    @Override
    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "innerResolveInContext"));
        }
        super.innerResolveInContext(referenceText, context, results, caseSensitive);
        this.innerResolveAdditionalRoots(referenceText, context, results, caseSensitive);
        TypeScriptFileModuleReference.removeNotExternalModules(results);
    }

    private static void removeNotExternalModules(Collection<ResolveResult> results) {
        Iterator<ResolveResult> iterator = results.iterator();
        while (iterator.hasNext()) {
            ResolveResult result = iterator.next();
            PsiElement element = result.getElement();
            if (!(element instanceof JSFile) || ((JSFile)element).isCommonJSModule()) continue;
            iterator.remove();
        }
    }

    private void innerResolveAdditionalRoots(@NotNull String s, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        Collection<PsiFileSystemItem> dirs;
        PsiElement element;
        TypeScriptConfig config;
        FileReferenceSet set;
        String requiredModuleName;
        boolean isRelative;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "innerResolveAdditionalRoots"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "innerResolveAdditionalRoots"));
        }
        boolean startsWithDot = this.getText().startsWith(".");
        if (!startsWithDot && (isRelative = (requiredModuleName = (set = this.getFileReferenceSet()).getPathString()).startsWith(".")) && (config = TypeScriptConfigUtil.getConfigForPsiFile((element = set.getElement()).getContainingFile())) != null && (dirs = config.getRootDirs()).contains(context)) {
            for (PsiFileSystemItem dir : dirs) {
                if (dir == context) continue;
                super.innerResolveInContext(s, dir, results, caseSensitive);
            }
        }
    }

    protected Object createLookupItem(PsiElement candidate) {
        return JSCompletionUtil.createLookupElementForJSModule(candidate);
    }

    @Override
    protected void processDirectoriesFromCurrentIterator(@NotNull Iterator<ResolveResult> iterator, @NotNull Collection<ResolveResult> results) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "processDirectoriesFromCurrentIterator"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "processDirectoriesFromCurrentIterator"));
        }
        ArrayList toAdd = ContainerUtil.newArrayList();
        while (iterator.hasNext()) {
            ResolveResult nodeModulesResolveResult;
            ResolveResult result = iterator.next();
            PsiElement possibleDirectory = result.getElement();
            if (!(possibleDirectory instanceof PsiDirectory) || (nodeModulesResolveResult = this.resolveDirectoryAsNodeModules(possibleDirectory)) == null) continue;
            iterator.remove();
            toAdd.add(nodeModulesResolveResult);
        }
        if (!toAdd.isEmpty()) {
            results.addAll(toAdd);
        }
    }

    protected ResolveResult resolveDirectoryAsNodeModules(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference", "resolveDirectoryAsNodeModules"));
        }
        Project project = this.getElement().getProject();
        return JSExactFileReference.resolveForNpmPackages(element, new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project));
    }

    @Override
    protected boolean isAllowFolders() {
        return true;
    }
}

