/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring.extractMethod;

import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.lang.typescript.refactoring.extractMethod.TypeScriptExtractedFunctionSignatureGenerator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class TypeScriptExtractFunctionHandler
extends JSExtractFunctionHandler {
    @Override
    protected JSExtractFunctionSettings showDialog(PsiFile file, JSExtractFunctionHandler.ContextInfo ci, ExtractedFunctionSignatureGenerator signatureGenerator, @NotNull JSExtractFunctionHandler.IntroductionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/refactoring/extractMethod/TypeScriptExtractFunctionHandler", "showDialog"));
        }
        JSExtractFunctionDialog dialog = new JSExtractFunctionDialog((PsiElement)file, signatureGenerator, ci, scope);
        if (scope.isClassContext()) {
            TypeScriptExtractFunctionHandler.initDialog(dialog);
        }
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog;
    }

    @Override
    protected String createMethodCallStringAfterExtractMethod(JSExtractFunctionSettings settings, JSExtractFunctionHandler.ContextInfo contextInfo, String callArgs, String callPrefix) {
        return super.createMethodCallStringAfterExtractMethod(settings, contextInfo, callArgs, callPrefix);
    }

    private static void initDialog(JSExtractFunctionDialog dialog) {
        JSVisibilityPanel panel = dialog.getVisibilityPanel();
        String visibility = panel.getVisibility();
        JSAttributeList.AccessType oneOfPossibleType = (JSAttributeList.AccessType)ContainerUtil.find((Iterable)JSAttributeList.TYPESCRIPT_ACCESS_TYPE_LIST, type -> type.name().equals(visibility));
        if (oneOfPossibleType == null) {
            panel.setVisibility(JSAttributeList.AccessType.PUBLIC.name());
        }
    }

    @Override
    @NotNull
    protected ExtractedFunctionSignatureGenerator getSignatureGenerator() {
        TypeScriptExtractedFunctionSignatureGenerator typeScriptExtractedFunctionSignatureGenerator = new TypeScriptExtractedFunctionSignatureGenerator();
        if (typeScriptExtractedFunctionSignatureGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/refactoring/extractMethod/TypeScriptExtractFunctionHandler", "getSignatureGenerator"));
        }
        return typeScriptExtractedFunctionSignatureGenerator;
    }
}

