/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.javascript.JSFileReference;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class TypeScriptConfigJsonReferenceContributor
extends PsiReferenceContributor {
    public static final String OUT_PROPERTY = "out";
    public static final String OUT_DIR_PROPERTY = "outDir";
    private static final PsiFilePattern.Capture<JsonFile> TS_CONFIG_FILE_PATTERN = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withName("tsconfig.json");
    public static final PsiElementPattern.Capture<JsonStringLiteral> STRING_LITERAL_IN_CONFIG = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(TS_CONFIG_FILE_PATTERN);
    private static final ElementPattern<? extends PsiElement> PATTERN_FILES_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("files"));
    private static final ElementPattern<? extends PsiElement> PATTERN_EXCLUDE_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("exclude"));
    private static final ElementPattern<? extends PsiElement> PATTERN_INCLUDE_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("include"));
    private static final ElementPattern<? extends PsiElement> PATTERN_ROOT_DIRS_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("rootDirs"));
    private static final ElementPattern<? extends PsiElement> PATTERN_TYPES_ROOT_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("typeRoots"));
    private static final ElementPattern<? extends PsiElement> PATTERN_OUT_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("out"));
    private static final ElementPattern<? extends PsiElement> PATTERN_BASE_URL_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("baseUrl"));
    private static final ElementPattern<? extends PsiElement> PATTERN_OUT_DIR = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("outDir"));
    private static final ElementPattern<? extends PsiElement> PATTERN_DECLARATION_DIR = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("declarationDir"));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor", "registerReferenceProviders"));
        }
        PsiReferenceProvider referenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1", "getReferencesByElement"));
                }
                if (element instanceof JsonStringLiteral) {
                    String value = ((JsonStringLiteral)element).getValue();
                    FileReference[] fileReferenceArray = new FileReferenceSet(value, element, 1, null, false){

                        public FileReference createFileReference(TextRange range, int index, String text) {
                            return new JSFileReference(text, index, range, this, TypeScriptReferenceContributor.TYPESCRIPT_EXTENSIONS){

                                @Override
                                protected boolean isAllowFolders() {
                                    return true;
                                }

                                protected Object createLookupItem(PsiElement candidate) {
                                    return JSCompletionUtil.createLookupElementForJSModule(candidate);
                                }
                            };
                        }
                    }.getAllReferences();
                    if (fileReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1", "getReferencesByElement"));
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        };
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PATTERN_FILES_ARRAY, PATTERN_OUT_FILE, PATTERN_OUT_DIR, PATTERN_EXCLUDE_ARRAY, PATTERN_INCLUDE_ARRAY, PATTERN_BASE_URL_FILE, PATTERN_TYPES_ROOT_ARRAY, PATTERN_DECLARATION_DIR, PATTERN_ROOT_DIRS_ARRAY}), referenceProvider, 100.0);
    }
}

