/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import com.sixrr.inspectjs.functionmetrics.NestingDepthVisitor;
import org.jetbrains.annotations.NotNull;

public class NestingDepthJSInspection
extends FunctionMetricsInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("overly.nested.function.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/NestingDepthJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.FUNCTIONMETRICS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/NestingDepthJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("nesting.depth.limit", new Object[0]);
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        NestingDepthVisitor visitor = new NestingDepthVisitor();
        function.accept((PsiElementVisitor)visitor);
        int nestingDepth = visitor.getMaximumDepth();
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.is.overly.nested.error.string", nestingDepth);
        }
        return InspectionJSBundle.message("anonymous.function.is.overly.nested.error.string", nestingDepth);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/NestingDepthJSInspection$Visitor", "visitJSFunctionDeclaration"));
            }
            NestingDepthVisitor visitor = new NestingDepthVisitor();
            function.accept((PsiElementVisitor)visitor);
            int count = visitor.getMaximumDepth();
            if (count <= NestingDepthJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function);
        }

        @Override
        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }
    }
}

