/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class NonBlockStatementBodyJSInspection
extends JavaScriptInspection {
    private final InspectionJSFix fix = new WrapBodyFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("non.block.statement.body.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.STYLE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof JSIfStatement) {
            return InspectionJSBundle.message("non.block.branch.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("non.block.body.error.string", new Object[0]);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$Visitor", "visitJSDoWhileStatement"));
            }
            super.visitJSDoWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$Visitor", "visitJSWhileStatement"));
            }
            super.visitJSWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$Visitor", "visitJSForStatement"));
            }
            super.visitJSForStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$Visitor", "visitJSForInStatement"));
            }
            super.visitJSForInStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (body instanceof JSBlockStatement) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$Visitor", "visitJSIfStatement"));
            }
            super.visitJSIfStatement(statement);
            JSStatement thenBranch = statement.getThen();
            if (thenBranch != null && !(thenBranch instanceof JSBlockStatement) && !JSInheritedLanguagesHelper.skipNonBlockBranch((PsiElement)thenBranch)) {
                this.registerStatementError((JSStatement)statement, statement);
                return;
            }
            JSStatement elseBranch = statement.getElse();
            if (elseBranch != null && !(elseBranch instanceof JSBlockStatement) && !(elseBranch instanceof JSIfStatement)) {
                this.registerStatementError((JSStatement)statement, statement);
            }
        }
    }

    private static class WrapBodyFix
    extends InspectionJSFix {
        private WrapBodyFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionJSBundle.message("wrap.statement.body.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/NonBlockStatementBodyJSInspection$WrapBodyFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement statementIdentifier = descriptor.getPsiElement();
            JSStatement statement = (JSStatement)statementIdentifier.getParent();
            if (statement instanceof JSLoopStatement) {
                JSStatement body = ((JSLoopStatement)statement).getBody();
                WrapBodyFix.wrapStatement(body);
            } else {
                JSStatement elseBranch;
                JSIfStatement ifStatement = (JSIfStatement)statement;
                JSStatement thenBranch = ifStatement.getThen();
                if (thenBranch != null && !(thenBranch instanceof JSBlockStatement)) {
                    WrapBodyFix.wrapStatement(thenBranch);
                }
                if ((elseBranch = ifStatement.getElse()) != null && !(elseBranch instanceof JSBlockStatement)) {
                    WrapBodyFix.wrapStatement(elseBranch);
                }
            }
        }

        private static void wrapStatement(JSStatement statement) throws IncorrectOperationException {
            String text = statement.getText();
            WrapBodyFix.replaceStatement(statement, '{' + text + '}');
        }
    }
}

