/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CommandLineArgumentsTokenizer
extends StringTokenizer {
    private static String DEFAULT_DELIMITERS = " \t\n\r\f";
    private List myTokens = new ArrayList();
    private int myCurrentToken = 0;

    public CommandLineArgumentsTokenizer(String str) {
        super(str, DEFAULT_DELIMITERS, true);
        this.parseTokens();
    }

    public CommandLineArgumentsTokenizer(String str, String delim) {
        super(str, delim, true);
        this.parseTokens();
    }

    @Override
    public boolean hasMoreTokens() {
        return this.myCurrentToken < this.myTokens.size();
    }

    @Override
    public String nextToken() {
        return (String)this.myTokens.get(this.myCurrentToken++);
    }

    @Override
    public int countTokens() {
        return this.myTokens.size() - this.myCurrentToken;
    }

    @Override
    public String nextToken(String delim) {
        throw new RuntimeException("Not implemented");
    }

    private void parseTokens() {
        String token;
        while ((token = this.nextTokenInternal()) != null) {
            this.myTokens.add(token);
        }
    }

    private String nextTokenInternal() {
        String nextToken;
        while ((nextToken = super.hasMoreTokens() ? super.nextToken() : null) != null && nextToken.length() == 1 && DEFAULT_DELIMITERS.indexOf(nextToken.charAt(0)) >= 0) {
        }
        if (nextToken == null) {
            return null;
        }
        int quotationMarks = 0;
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int i;
            if ((i = nextToken.indexOf(34)) >= 0) {
                ++quotationMarks;
                buffer.append(nextToken.substring(0, i));
                nextToken = nextToken.substring(i + 1);
                continue;
            }
            buffer.append(nextToken);
            nextToken = quotationMarks % 2 == 1 && super.hasMoreTokens() ? super.nextToken() : null;
            if (nextToken == null) break;
        }
        return buffer.toString();
    }
}

