/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.completion.PlayCompletionUtils;
import com.intellij.play.completion.beans.PlayFastTagDescriptor;
import com.intellij.play.completion.beans.PlayTagDescriptor;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.references.PlayCustomTagNamePsiReference;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlayCustomTagPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider", "getReferencesByElement"));
        }
        HashSet set = new HashSet();
        PlayTag playTag = (PlayTag)element;
        String name = playTag.getName();
        if (!StringUtil.isEmptyOrSpaces((String)name) && PlayCustomTagPsiReferenceProvider.isCustomTag(playTag)) {
            if (name.contains(".")) {
                String namespaceName = StringUtil.getPackageName((String)name);
                String tagName = StringUtil.getShortName((String)name);
                set.addAll(PlayCustomTagPsiReferenceProvider.getNamespaceReferences((PlayTag)element, namespaceName));
                set.add(new PlayCustomTagNamePsiReference((PlayTag)element, tagName, name));
            } else {
                set.add(new PlayCustomTagNamePsiReference((PlayTag)element, name, name));
            }
        }
        PsiReference[] psiReferenceArray = set.toArray(new PsiReference[set.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static Collection<? extends PsiReference> getNamespaceReferences(@NotNull PlayTag element, @NotNull String namespaceName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider", "getNamespaceReferences"));
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceName", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider", "getNamespaceReferences"));
        }
        final Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return Collections.emptySet();
        }
        HashSet references = new HashSet();
        HashSet descriptors = new HashSet();
        int offset = element.getText().indexOf(namespaceName);
        for (final PlayFastTagDescriptor fastTagDescriptor : PlayPathUtils.getFastTags(module)) {
            if (!namespaceName.equals(fastTagDescriptor.getNamespaceValue())) continue;
            descriptors.add(new PsiReferenceBase<PlayTag>(element, TextRange.create((int)offset, (int)(offset + namespaceName.length()))){

                public PsiElement resolve() {
                    JamStringAttributeElement<String> namespace = fastTagDescriptor.getNamespace();
                    return namespace == null ? null : namespace.getPsiElement();
                }

                @NotNull
                public Object[] getVariants() {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider$1", "getVariants"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
            });
        }
        if (descriptors.size() > 0) {
            references.add(new PsiMultiReference(descriptors.toArray(new PsiReference[descriptors.size()]), (PsiElement)element));
        }
        PackageReferenceSet set = new PackageReferenceSet(namespaceName, (PsiElement)element, offset){

            public Set<PsiPackage> getInitialContext() {
                HashSet packages = new HashSet();
                Set<PsiDirectory> roots = PlayPathUtils.getCustomTagRoots(module);
                for (PsiDirectory root : roots) {
                    PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(root);
                    if (psiPackage == null) continue;
                    packages.add(psiPackage);
                }
                return packages;
            }
        };
        references.addAll(set.getReferences());
        return references;
    }

    private static boolean isCustomTag(PlayTag tag) {
        String tagName = tag.getName();
        if (!StringUtil.isEmptyOrSpaces((String)tagName)) {
            for (PlayTagDescriptor descriptor : PlayCompletionUtils.getPredefinedTagDescriptors()) {
                if (!tagName.equals(descriptor.getTagName())) continue;
                return false;
            }
        }
        return true;
    }
}

